/*
 * Decompiled with CFR 0.152.
 */
package sun.security.validator;

import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneOffset;
import java.util.Date;
import sun.security.util.Debug;
import sun.security.validator.ValidatorException;
import sun.security.x509.X509CertImpl;

final class CamerfirmaTLSPolicy {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final String FINGERPRINT = "063E4AFAC491DFD332F3089B8542E94617D893D7FE944E10A7937EE29D9693C0";
    private static final LocalDate APRIL_15_2025 = LocalDate.of(2025, Month.APRIL, 15);

    static void checkDistrust(X509Certificate[] x509CertificateArray) throws ValidatorException {
        X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
        String string = CamerfirmaTLSPolicy.fingerprint(x509Certificate);
        if (string == null) {
            throw new ValidatorException("Cannot generate fingerprint for trust anchor of TLS server certificate");
        }
        if (FINGERPRINT.equalsIgnoreCase(string)) {
            Date date = x509CertificateArray[0].getNotBefore();
            LocalDate localDate = date.toInstant().atZone(ZoneOffset.UTC).toLocalDate();
            CamerfirmaTLSPolicy.checkNotBefore(localDate, APRIL_15_2025, x509Certificate);
        }
    }

    private static String fingerprint(X509Certificate x509Certificate) {
        return X509CertImpl.getFingerprint("SHA-256", x509Certificate);
    }

    private static void checkNotBefore(LocalDate localDate, LocalDate localDate2, X509Certificate x509Certificate) throws ValidatorException {
        if (localDate.isAfter(localDate2)) {
            throw new ValidatorException("TLS Server certificate issued after " + localDate2 + " and anchored by a distrusted legacy Camerfirma root CA: " + x509Certificate.getSubjectX500Principal(), ValidatorException.T_UNTRUSTED_CERT, x509Certificate);
        }
    }

    private CamerfirmaTLSPolicy() {
    }
}

