/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.internal.components;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.common.registry.ManagedProvider;
import org.openhab.core.ui.components.UIComponentProvider;
import org.openhab.core.ui.components.UIComponentRegistryFactory;
import org.openhab.core.ui.internal.components.ManagedUIComponentProvider;
import org.openhab.core.ui.internal.components.UIComponentRegistryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={UIComponentRegistryFactory.class}, immediate=true)
public class UIComponentRegistryFactoryImpl
implements UIComponentRegistryFactory {
    private final Logger logger = LoggerFactory.getLogger(UIComponentRegistryFactoryImpl.class);
    private final ComponentFactory<ManagedUIComponentProvider> providerFactory;
    private final BundleContext bc;
    Map<String, UIComponentRegistryImpl> registries = new ConcurrentHashMap<String, UIComponentRegistryImpl>();
    Set<ComponentInstance<ManagedUIComponentProvider>> createdProviders = new CopyOnWriteArraySet<ComponentInstance<ManagedUIComponentProvider>>();
    Map<String, Set<UIComponentProvider>> providers = new ConcurrentHashMap<String, Set<UIComponentProvider>>();

    @Activate
    public UIComponentRegistryFactoryImpl(@Reference(target="(component.factory=org.openhab.core.ui.component.provider.factory)") ComponentFactory<ManagedUIComponentProvider> factory, BundleContext bc) {
        this.providerFactory = factory;
        this.bc = bc;
    }

    @Override
    public UIComponentRegistryImpl getRegistry(String namespace) {
        UIComponentRegistryImpl registry = this.registries.get(namespace);
        if (registry == null) {
            if (!this.managedProviderAvailable(namespace)) {
                this.logger.debug("Creating managed provider for '{}'", (Object)namespace);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("ui.namespace", namespace);
                ComponentInstance instance = this.providerFactory.newInstance(properties);
                this.createdProviders.add((ComponentInstance<ManagedUIComponentProvider>)instance);
            }
            Set<UIComponentProvider> namespaceProviders = this.providers.get(namespace);
            registry = new UIComponentRegistryImpl(namespace, namespaceProviders);
            this.registries.put(namespace, registry);
        }
        return registry;
    }

    @Deactivate
    public void deactivate() {
        this.createdProviders.forEach(ComponentInstance::dispose);
    }

    private boolean managedProviderAvailable(String namespace) {
        try {
            return this.bc.getServiceReferences(UIComponentProvider.class, null).stream().map(arg_0 -> ((BundleContext)this.bc).getService(arg_0)).anyMatch(s -> namespace.equals(s.getNamespace()) && s instanceof ManagedProvider);
        }
        catch (InvalidSyntaxException e) {
            return false;
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void addProvider(UIComponentProvider provider) {
        UIComponentRegistryImpl registry = this.registries.get(provider.getNamespace());
        if (registry != null) {
            registry.addProvider(provider);
        }
        this.registerProvider(provider);
    }

    void removeProvider(UIComponentProvider provider) {
        UIComponentRegistryImpl registry = this.registries.get(provider.getNamespace());
        if (registry != null) {
            registry.removeProvider(provider);
        }
        this.unregisterProvider(provider);
    }

    private void registerProvider(UIComponentProvider provider) {
        Set<UIComponentProvider> existing = this.providers.get(provider.getNamespace());
        if (existing == null) {
            existing = Set.of();
        }
        HashSet<UIComponentProvider> updated = new HashSet<UIComponentProvider>(existing);
        updated.add(provider);
        this.providers.put(provider.getNamespace(), Set.copyOf(updated));
    }

    private void unregisterProvider(UIComponentProvider provider) {
        Set<UIComponentProvider> existing = this.providers.get(provider.getNamespace());
        if (existing != null && !existing.isEmpty()) {
            HashSet<UIComponentProvider> updated = new HashSet<UIComponentProvider>(existing);
            updated.remove(provider);
            this.providers.put(provider.getNamespace(), Set.copyOf(updated));
        }
    }
}

