/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.util.function.Consumer;
import org.osgi.util.function.Function;
import org.osgi.util.function.Predicate;
import org.osgi.util.promise.DeferredPromiseImpl;
import org.osgi.util.promise.FailedPromiseImpl;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.promise.ResolvedPromiseImpl;
import org.osgi.util.promise.Success;

abstract class PromiseImpl<T>
implements Promise<T> {
    private final PromiseFactory factory;
    private final ConcurrentLinkedQueue<Runnable> callbacks;

    PromiseImpl(PromiseFactory factory) {
        this.factory = Objects.requireNonNull(factory);
        this.callbacks = new ConcurrentLinkedQueue();
    }

    <V> DeferredPromiseImpl<V> deferred() {
        return new DeferredPromiseImpl(this.factory);
    }

    <V> ResolvedPromiseImpl<V> resolved(V v) {
        return new ResolvedPromiseImpl<V>(v, this.factory);
    }

    <V> FailedPromiseImpl<V> failed(Throwable f) {
        return new FailedPromiseImpl(f, this.factory);
    }

    @Override
    public Promise<T> onResolve(Runnable callback) {
        Objects.requireNonNull(callback);
        if (this.isDone() && (callback instanceof InlineCallback || this.factory.allowCurrentThread())) {
            try {
                callback.run();
            }
            catch (Throwable t) {
                PromiseImpl.uncaughtException(t);
            }
        } else {
            this.callbacks.offer(callback);
            this.notifyCallbacks();
        }
        return this;
    }

    void notifyCallbacks() {
        Runnable callback;
        if (!this.isDone()) {
            return;
        }
        while ((callback = this.callbacks.poll()) != null) {
            this.execute(callback);
        }
    }

    void execute(Runnable operation) {
        try {
            try {
                this.factory.executor().execute(operation);
            }
            catch (RejectedExecutionException e) {
                operation.run();
            }
        }
        catch (Throwable t) {
            PromiseImpl.uncaughtException(t);
        }
    }

    ScheduledFuture<?> schedule(Runnable operation, long delay, TimeUnit unit) {
        try {
            try {
                return this.factory.scheduledExecutor().schedule(operation, delay, unit);
            }
            catch (RejectedExecutionException e) {
                this.execute(operation);
            }
        }
        catch (Throwable t) {
            PromiseImpl.uncaughtException(t);
        }
        return null;
    }

    static void uncaughtException(Throwable t) {
        try {
            Thread thread = Thread.currentThread();
            thread.getUncaughtExceptionHandler().uncaughtException(thread, t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Promise<T> onSuccess(Consumer<? super T> success) {
        return this.onResolve(new OnSuccess(success));
    }

    @Override
    public Promise<T> onFailure(Consumer<? super Throwable> failure) {
        return this.onFailure(failure, Throwable.class);
    }

    @Override
    public <F> Promise<T> onFailure(Consumer<? super F> failure, Class<? extends F> failureType) {
        return this.onResolve(new OnFailure<F>(failure, failureType));
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success, Failure failure) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        Objects.requireNonNull(deferredPromiseImpl);
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.Then<T>(this, success, failure));
        return chained.orDone();
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success) {
        return this.then(success, null);
    }

    @Override
    public Promise<T> thenAccept(Consumer<? super T> consumer) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        Objects.requireNonNull(deferredPromiseImpl);
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.ThenAccept(this, consumer));
        return chained.orDone();
    }

    @Override
    public Promise<T> filter(Predicate<? super T> predicate) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        Objects.requireNonNull(deferredPromiseImpl);
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.Filter(this, predicate));
        return chained.orDone();
    }

    @Override
    public <R> Promise<R> map(Function<? super T, ? extends R> mapper) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        Objects.requireNonNull(deferredPromiseImpl);
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.Map<T>(this, mapper));
        return chained.orDone();
    }

    @Override
    public <R> Promise<R> flatMap(Function<? super T, Promise<? extends R>> mapper) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        Objects.requireNonNull(deferredPromiseImpl);
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.FlatMap<T>(this, mapper));
        return chained.orDone();
    }

    @Override
    public Promise<T> recover(Function<Promise<?>, ? extends T> recovery) {
        return this.recover(recovery, Throwable.class);
    }

    @Override
    public Promise<T> recover(Function<Promise<?>, ? extends T> recovery, Class<?> failureType) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        Objects.requireNonNull(deferredPromiseImpl);
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.Recover(this, recovery, failureType));
        return chained.orDone();
    }

    @Override
    public Promise<T> recoverWith(Function<Promise<?>, Promise<? extends T>> recovery) {
        return this.recoverWith(recovery, Throwable.class);
    }

    @Override
    public Promise<T> recoverWith(Function<Promise<?>, Promise<? extends T>> recovery, Class<?> failureType) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        Objects.requireNonNull(deferredPromiseImpl);
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.RecoverWith(this, recovery, failureType));
        return chained.orDone();
    }

    @Override
    public Promise<T> fallbackTo(Promise<? extends T> fallback) {
        return this.fallbackTo(fallback, Throwable.class);
    }

    @Override
    public Promise<T> fallbackTo(Promise<? extends T> fallback, Class<?> failureType) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        Objects.requireNonNull(deferredPromiseImpl);
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.FallbackTo(this, fallback, failureType));
        return chained.orDone();
    }

    @Override
    public Promise<T> timeout(long millis) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        Objects.requireNonNull(deferredPromiseImpl);
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.Timeout(this, millis));
        return chained.orDone();
    }

    @Override
    public Promise<T> delay(long millis) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        Objects.requireNonNull(deferredPromiseImpl);
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.Delay(this, millis));
        return chained.orDone();
    }

    @Override
    public CompletionStage<T> toCompletionStage() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.onResolve(new ToCompletionStage(completableFuture));
        return completableFuture;
    }

    abstract void result(Result<? super T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <R> void result(Promise<? extends R> promise, Result<? super R> consumer) {
        Object value;
        Throwable fail;
        if (promise instanceof PromiseImpl) {
            PromiseImpl impl = (PromiseImpl)promise;
            impl.result(consumer);
            return;
        }
        if (!promise.isDone()) {
            consumer.accept(null, (Throwable)((Object)new AssertionError((Object)"promise not resolved")));
            return;
        }
        boolean interrupted = Thread.interrupted();
        try {
            fail = promise.getFailure();
            value = fail == null ? (Object)promise.getValue() : null;
        }
        catch (Throwable e) {
            fail = e;
            value = null;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        consumer.accept(value, fail);
    }

    static interface InlineCallback {
    }

    private final class OnSuccess
    implements Runnable,
    Result<T> {
        private final Consumer<? super T> success;

        OnSuccess(Consumer<? super T> success) {
            this.success = Objects.requireNonNull(success);
        }

        @Override
        public void run() {
            PromiseImpl.this.result(this);
        }

        @Override
        public void accept(T v, Throwable f) {
            if (f == null) {
                try {
                    this.success.accept(v);
                }
                catch (Throwable e) {
                    PromiseImpl.uncaughtException(e);
                }
            }
        }
    }

    private final class OnFailure<F>
    implements Runnable,
    Result<T> {
        private final Consumer<? super F> failure;
        private final Class<? extends F> failureType;

        OnFailure(Consumer<? super F> failure, Class<? extends F> failureType) {
            this.failure = Objects.requireNonNull(failure);
            this.failureType = Objects.requireNonNull(failureType);
        }

        @Override
        public void run() {
            PromiseImpl.this.result(this);
        }

        @Override
        public void accept(T v, Throwable f) {
            if (this.failureType.isInstance(f)) {
                try {
                    this.failure.accept(f);
                }
                catch (Throwable e) {
                    PromiseImpl.uncaughtException(e);
                }
            }
        }
    }

    private final class ToCompletionStage
    implements Runnable,
    Result<T> {
        private final CompletableFuture<T> completableFuture;

        ToCompletionStage(CompletableFuture<T> completableFuture) {
            this.completableFuture = Objects.requireNonNull(completableFuture);
        }

        @Override
        public void run() {
            PromiseImpl.this.result(this);
        }

        @Override
        public void accept(T v, Throwable f) {
            if (f == null) {
                this.completableFuture.complete(v);
            } else {
                this.completableFuture.completeExceptionally(f);
            }
        }
    }

    static interface Result<R> {
        public void accept(R var1, Throwable var2);
    }
}

