/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.http.auth.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.auth.Authentication;
import org.openhab.core.auth.AuthenticationException;
import org.openhab.core.auth.AuthenticationProvider;
import org.openhab.core.auth.Credentials;
import org.openhab.core.auth.User;
import org.openhab.core.auth.UserRegistry;
import org.openhab.core.auth.UsernamePasswordCredentials;
import org.openhab.core.i18n.LocaleProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractAuthPageServlet
extends HttpServlet {
    private static final long serialVersionUID = 5340598701104679840L;
    private static final String MESSAGES_BUNDLE_NAME = "messages";
    private final Logger logger = LoggerFactory.getLogger(AbstractAuthPageServlet.class);
    protected UserRegistry userRegistry;
    protected AuthenticationProvider authProvider;
    protected LocaleProvider localeProvider;
    protected @Nullable Instant lastAuthenticationFailure;
    protected int authenticationFailureCount = 0;
    protected Map<String, Instant> csrfTokens = new HashMap<String, Instant>();
    protected String pageTemplate;

    protected AbstractAuthPageServlet(BundleContext bundleContext, @Reference UserRegistry userRegistry, @Reference AuthenticationProvider authProvider, @Reference LocaleProvider localeProvider) {
        this.userRegistry = userRegistry;
        this.authProvider = authProvider;
        this.localeProvider = localeProvider;
        this.pageTemplate = "";
        URL resource = bundleContext.getBundle().getResource("pages/authorize.html");
        if (resource != null) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream stream = resource.openStream();){
                    this.pageTemplate = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Cannot load page template", e);
            }
        }
    }

    protected String getPageTemplate() {
        String template = this.pageTemplate;
        String[][] stringArrayArray = new String[][]{{"{usernamePlaceholder}", "auth.placeholder.username"}, {"{passwordPlaceholder}", "auth.placeholder.password"}, {"{newPasswordPlaceholder}", "auth.placeholder.newpassword"}, {"{repeatPasswordPlaceholder}", "auth.placeholder.repeatpassword"}, {"{tokenNamePlaceholder}", "auth.placeholder.tokenname"}, {"{tokenScopePlaceholder}", "auth.placeholder.tokenscope"}, {"{returnButtonLabel}", "auth.button.return"}};
        int n = stringArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] replace = stringArrayArray[n2];
            template = template.replace(replace[0], this.getLocalizedMessage(replace[1]));
            ++n2;
        }
        return template;
    }

    protected abstract String getPageBody(Map<String, String[]> var1, String var2, boolean var3);

    protected abstract String getFormFields(Map<String, String[]> var1);

    protected String addCsrfToken() {
        String csrfToken = UUID.randomUUID().toString().replace("-", "");
        this.csrfTokens.put(csrfToken, Instant.now());
        this.csrfTokens.entrySet().removeIf(e -> ((Instant)e.getValue()).isBefore(Instant.now().minus(Duration.ofMinutes(10L))));
        return csrfToken;
    }

    protected void removeCsrfToken(String csrfToken) {
        this.csrfTokens.remove(csrfToken);
    }

    protected User login(String username, String password) throws AuthenticationException {
        if (this.lastAuthenticationFailure != null && this.lastAuthenticationFailure.isAfter(Instant.now().minus(Duration.ofSeconds(this.authenticationFailureCount)))) {
            throw new AuthenticationException("Too many consecutive login attempts");
        }
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        Authentication auth = this.authProvider.authenticate((Credentials)credentials);
        this.logger.debug("Login successful: {}", (Object)auth.getUsername());
        this.lastAuthenticationFailure = null;
        this.authenticationFailureCount = 0;
        User user = (User)this.userRegistry.get((Object)auth.getUsername());
        if (user == null) {
            throw new AuthenticationException("User not found");
        }
        return user;
    }

    protected void processFailedLogin(HttpServletResponse resp, String remoteAddr, Map<String, String[]> params, @Nullable String message) throws IOException {
        this.lastAuthenticationFailure = Instant.now();
        ++this.authenticationFailureCount;
        resp.setContentType("text/html;charset=UTF-8");
        this.logger.warn("Authentication failed from {}: {}", (Object)remoteAddr, (Object)message);
        resp.getWriter().append(this.getPageBody(params, this.getLocalizedMessage("auth.login.fail"), false));
        resp.getWriter().close();
    }

    protected String getLocalizedMessage(String messageKey) {
        ResourceBundle rb = ResourceBundle.getBundle(MESSAGES_BUNDLE_NAME, this.localeProvider.getLocale(), ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
        return rb.getString(messageKey);
    }
}

