/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.registry;

import org.jupnp.registry.RegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryMaintainer
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(RegistryMaintainer.class);
    private final RegistryImpl registry;
    private final int sleepIntervalMillis;
    private volatile boolean stopped = false;

    public RegistryMaintainer(RegistryImpl registry, int sleepIntervalMillis) {
        this.registry = registry;
        this.sleepIntervalMillis = sleepIntervalMillis;
    }

    public void stop() {
        this.logger.trace("Setting stopped status on thread");
        this.stopped = true;
    }

    @Override
    public void run() {
        this.stopped = false;
        this.logger.trace("Running registry maintenance loop every milliseconds: {}", (Object)this.sleepIntervalMillis);
        while (!this.stopped) {
            try {
                this.registry.maintain();
                Thread.sleep(this.sleepIntervalMillis);
            }
            catch (InterruptedException e) {
                this.stopped = true;
            }
        }
        this.logger.trace("Stopped status on thread received, ending maintenance loop");
    }
}

