"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchRelevancePlugin = void 0;
var _operators = require("rxjs/operators");
var _configSchema = require("@osd/config-schema");
var _routes = require("./routes");
var _metrics_service = require("./metrics/metrics_service");
var _common = require("../common");
var _ml_route_service = require("./routes/ml_route_service");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class SearchRelevancePlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "config$", void 0);
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "metricsService", void 0);
    this.config$ = this.initializerContext.config.create();
    this.logger = this.initializerContext.logger.get();
    this.metricsService = new _metrics_service.MetricsService(this.logger.get('metrics-service'));
  }
  async setup(core, {
    dataSource
  }) {
    const dataSourceEnabled = !!dataSource;
    this.logger.debug('SearchRelevance: Setup');
    core.uiSettings.register({
      [_common.SEARCH_RELEVANCE_EXPERIMENTAL_WORKBENCH_UI_EXPERIENCE_ENABLED]: {
        name: 'Experimental Search Relevance Workbench',
        value: true,
        description: 'Whether to opt-in the experimental search relevance workbench feature',
        schema: _configSchema.schema.boolean(),
        category: ['search relevance']
      }
    });
    const config = await this.config$.pipe((0, _operators.first)()).toPromise();
    const metricsService = this.metricsService.setup(config.metrics.metricInterval, config.metrics.windowSize);
    const router = core.http.createRouter();
    let opensearchSearchRelevanceClient = undefined;
    opensearchSearchRelevanceClient = core.opensearch.legacy.createClient('opensearch_search_relevance');

    // @ts-ignore
    core.http.registerRouteHandlerContext('searchRelevance', (context, request) => {
      return {
        logger: this.logger,
        relevancyWorkbenchClient: opensearchSearchRelevanceClient,
        metricsService
      };
    });

    // Register server side APIs
    (0, _routes.defineRoutes)(router, core.opensearch, dataSourceEnabled);
    (0, _routes.registerSearchRelevanceRoutes)(router);
    (0, _ml_route_service.registerMLRoutes)(router, dataSourceEnabled);
    return {};
  }
  start(core) {
    this.logger.debug('SearchRelevance: Started');
    return {};
  }
  stop() {}
}
exports.SearchRelevancePlugin = SearchRelevancePlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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