/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.dialog.util;

import com.projectlibre1.dialog.util.LookupField;
import com.projectlibre1.field.Field;
import com.projectlibre1.field.FieldContext;
import com.projectlibre1.field.FieldParseException;
import com.projectlibre1.field.ObjectRef;
import com.projectlibre1.util.Alert;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FieldChangeListener
implements ItemListener,
ChangeListener {
    private FieldContext context = null;
    private Field field;
    private ObjectRef objectRef = null;

    public FieldChangeListener(Field field, ObjectRef objectRef) {
        this.field = field;
        this.objectRef = objectRef;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        Boolean bl = itemEvent.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        try {
            this.field.setValue(this.objectRef, object, (Object)bl, this.context);
        }
        catch (FieldParseException fieldParseException) {
            Alert.error(fieldParseException.getMessage());
            ((JComponent)object).requestFocus();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof LookupField) {
            LookupField lookupField = (LookupField)changeEvent.getSource();
            try {
                this.field.setText(this.objectRef, lookupField.getValue(), this.context);
            }
            catch (FieldParseException fieldParseException) {
                fieldParseException.printStackTrace();
            }
        }
    }
}

