/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.views;

import com.projectlibre1.configuration.Dictionary;
import com.projectlibre1.graphic.configuration.BarStyles;
import com.projectlibre1.grouping.core.model.NodeModel;
import com.projectlibre1.help.HelpUtil;
import com.projectlibre1.menu.MenuManager;
import com.projectlibre1.pm.graphic.frames.DocumentFrame;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCache;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projectlibre1.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projectlibre1.pm.graphic.pert.Pert;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheet;
import com.projectlibre1.pm.graphic.views.BaseView;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.undo.UndoController;
import com.projectlibre1.workspace.WorkspaceSetting;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class PertView
extends JScrollPane
implements BaseView {
    private static final long serialVersionUID = 1493530627188782732L;
    protected Pert pert;
    protected NodeModel model;
    protected Project project;
    DocumentFrame documentFrame;
    protected NodeModelCache cache;

    public PertView(DocumentFrame documentFrame, MenuManager menuManager) {
        HelpUtil.addDocHelp(this, "Network_Diagram");
        this.documentFrame = documentFrame;
        this.project = documentFrame.getProject();
    }

    public void init(ReferenceNodeModelCache referenceNodeModelCache, NodeModel nodeModel) {
        this.pert = new Pert(this.project, "Network");
        this.cache = NodeModelCacheFactory.getInstance().createAntiAssignmentFilteredCache(referenceNodeModelCache, this.getViewName(), null);
        this.pert.setCache(this.cache);
        this.pert.setBarStyles((BarStyles)Dictionary.get("BarStylesCategory", "pert"));
        JViewport jViewport = this.createViewport();
        jViewport.setView(this.pert);
        this.setViewport(jViewport);
        if (this.project.isReadOnly()) {
            this.pert.setEnabled(false);
        }
        referenceNodeModelCache.update();
    }

    @Override
    public void cleanUp() {
        this.pert.cleanUp();
        this.pert = null;
        this.model = null;
        this.project = null;
        this.documentFrame = null;
    }

    @Override
    public UndoController getUndoController() {
        return this.project.getUndoController();
    }

    @Override
    public void zoomIn() {
        this.pert.zoomIn();
    }

    @Override
    public void zoomOut() {
        this.pert.zoomOut();
    }

    @Override
    public boolean canZoomIn() {
        return this.pert.canZoomIn();
    }

    @Override
    public boolean canZoomOut() {
        return this.pert.canZoomOut();
    }

    @Override
    public int getScale() {
        return this.pert.getZoom();
    }

    @Override
    public SpreadSheet getSpreadSheet() {
        return null;
    }

    @Override
    public boolean hasNormalMinWidth() {
        return true;
    }

    @Override
    public String getViewName() {
        return "Network";
    }

    @Override
    public boolean showsTasks() {
        return true;
    }

    @Override
    public boolean showsResources() {
        return false;
    }

    @Override
    public void onActivate(boolean bl) {
    }

    @Override
    public boolean isPrintable() {
        return true;
    }

    @Override
    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.pert.restoreWorkspace(workspace.network, n);
    }

    @Override
    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.network = this.pert.createWorkspace(n);
        return workspace;
    }

    @Override
    public boolean canScrollToTask() {
        return false;
    }

    @Override
    public void scrollToTask() {
    }

    @Override
    public NodeModelCache getCache() {
        return this.cache;
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = 3364215160357571230L;
        WorkspaceSetting network;

        public WorkspaceSetting getNetwork() {
            return this.network;
        }

        public void setNetwork(WorkspaceSetting workspaceSetting) {
            this.network = workspaceSetting;
        }
    }
}

