package rancidcontrib;
##
## rancid 3.14
## Copyright (c) 1997-2022 by Henry Kilmer and John Heasley
## All rights reserved.
##
## This code is derived from software contributed to and maintained by
## Henry Kilmer, John Heasley, Andrew Partan,
## Pete Whiting, Austin Schutz, and Andrew Fort.
##
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions
## are met:
## 1. Redistributions of source code must retain the above copyright
##    notice, this list of conditions and the following disclaimer.
## 2. Redistributions in binary form must reproduce the above copyright
##    notice, this list of conditions and the following disclaimer in the
##    documentation and/or other materials provided with the distribution.
## 3. Neither the name of RANCID nor the names of its
##    contributors may be used to endorse or promote products derived from
##    this software without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY Henry Kilmer, John Heasley AND CONTRIBUTORS
## ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
## TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
## PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COMPANY OR CONTRIBUTORS
## BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
## CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
## SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
## INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
## CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
## ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
## POSSIBILITY OF SUCH DAMAGE.
##
## It is the request of the authors, but not a condition of license, that
## parties packaging or redistributing RANCID NOT distribute altered versions
## of the etc/rancid.types.base file nor alter how this file is processed nor
## when in relation to etc/rancid.types.conf.  The goal of this is to help
## suppress our support costs.  If it becomes a problem, this could become a
## condition of license.
# 
#  The expect login scripts were based on Erik Sherk's gwtn, by permission.
# 
#  The original looking glass software was written by Ed Kern, provided by
#  permission and modified beyond recognition.
#
#  RANCID - Really Awesome New Cisco confIg Differ
#
#  rancid.pm - base/basic rancid procedures
#

use 5.010;
use strict 'vars';
use warnings;
require(Exporter);
our @ISA = qw(Exporter);

use rancid 3.14;

# load-time initialization
sub import {
    0;
}

# post-open(collection file) initialization
sub init {
    0;
}

# This routine parses "show system reboot"
# Includes impending reboot for JunOS.
# Add to the device type configuration (see rancid.types.conf(5)):
#	<devtype>;module;rancidcontrib
#	<devtype>;command;rancidcontrib::JunosShowSystemReboot;show system reboot
# github.com/shigechika
sub JunosShowSystemReboot {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In ShowSystemReboot: $_" if ($debug);

    s/^[a-z]+@//;
    ProcessHistory("","","","# $_");
    while (<$INPUT>) {
	tr/\015//d;
	last if (/^$prompt/);
	next if (/^system (shutdown message from|going down )/i);
	next if (/^\{(master|backup|linecard|primary|secondary)(:(node)?\d+)?\}/);

	/Unrecognized command/ && return(1);
	/command is not valid/ && return(1);
	/^\s+\^/ && return(1);
	/syntax error/ && return(1);
	/^JUNOS / && <$INPUT> && next;
	/No such file or directory$/ && next;

	ProcessHistory("","","","# $_");
    }
    return(0);
}

1;
