/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.StringParsers$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArraySeq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Statics;

public final class Duration$
implements Serializable {
    public static final Duration$ MODULE$;
    private static final List<Tuple2<TimeUnit, String>> timeUnitLabels;
    private static final Map<TimeUnit, String> timeUnitName;
    private static final Map<String, TimeUnit> timeUnit;
    private static final FiniteDuration Zero;
    private static final Duration.Infinite Undefined;
    private static final Duration.Infinite Inf;
    private static final Duration.Infinite MinusInf;

    /*
     * WARNING - void declaration
     */
    static {
        Nil$ nil$;
        MODULE$ = new Duration$();
        String $minus$greater$extension_y = "d day";
        TimeUnit $minus$greater$extension_$this = TimeUnit.DAYS;
        Tuple2<TimeUnit, String> tuple2 = new Tuple2<TimeUnit, String>($minus$greater$extension_$this, $minus$greater$extension_y);
        $minus$greater$extension_y = "h hr hour";
        $minus$greater$extension_$this = TimeUnit.HOURS;
        Tuple2<TimeUnit, String> tuple22 = new Tuple2<TimeUnit, String>($minus$greater$extension_$this, $minus$greater$extension_y);
        $minus$greater$extension_y = "m min minute";
        $minus$greater$extension_$this = TimeUnit.MINUTES;
        Tuple2<TimeUnit, String> tuple23 = new Tuple2<TimeUnit, String>($minus$greater$extension_$this, $minus$greater$extension_y);
        $minus$greater$extension_y = "s sec second";
        $minus$greater$extension_$this = TimeUnit.SECONDS;
        Tuple2<TimeUnit, String> tuple24 = new Tuple2<TimeUnit, String>($minus$greater$extension_$this, $minus$greater$extension_y);
        $minus$greater$extension_y = "ms milli millisecond";
        $minus$greater$extension_$this = TimeUnit.MILLISECONDS;
        Tuple2<TimeUnit, String> tuple25 = new Tuple2<TimeUnit, String>($minus$greater$extension_$this, $minus$greater$extension_y);
        $minus$greater$extension_y = "\u00b5s micro microsecond";
        $minus$greater$extension_$this = TimeUnit.MICROSECONDS;
        Tuple2<TimeUnit, String> tuple26 = new Tuple2<TimeUnit, String>($minus$greater$extension_$this, $minus$greater$extension_y);
        $minus$greater$extension_y = "ns nano nanosecond";
        $minus$greater$extension_$this = TimeUnit.NANOSECONDS;
        timeUnitLabels = new $colon$colon<Nothing$>((Nothing$)((Object)tuple2), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)tuple22), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)tuple23), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)tuple24), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)tuple25), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)tuple26), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<TimeUnit, String>($minus$greater$extension_$this, $minus$greater$extension_y)), Nil$.MODULE$)))))));
        timeUnitName = timeUnitLabels.toMap($less$colon$less$.MODULE$.refl()).view().mapValues((Function1<String, String> & Serializable)s -> {
            String string;
            return MODULE$.words(string).last();
        }).toMap($less$colon$less$.MODULE$.refl());
        $colon$colon<Nothing$> flatMap_h = null;
        $colon$colon<Nothing$> flatMap_t = null;
        for (List flatMap_rest = timeUnitLabels; flatMap_rest != Nil$.MODULE$; flatMap_rest = (List)flatMap_rest.tail()) {
            Iterator flatMap_it = Duration$.$anonfun$timeUnit$1((Tuple2)flatMap_rest.head()).iterator();
            while (flatMap_it.hasNext()) {
                $colon$colon<Nothing$> flatMap_nx = new $colon$colon<Nothing$>((Nothing$)flatMap_it.next(), Nil$.MODULE$);
                if (flatMap_t == null) {
                    flatMap_h = flatMap_nx;
                } else {
                    flatMap_t.next_$eq(flatMap_nx);
                }
                flatMap_t = flatMap_nx;
            }
        }
        if (flatMap_h == null) {
            nil$ = Nil$.MODULE$;
        } else {
            void var1;
            Statics.releaseFence();
            nil$ = var1;
        }
        timeUnit = nil$.toMap($less$colon$less$.MODULE$.refl());
        Zero = new FiniteDuration(0L, TimeUnit.DAYS);
        Undefined = new Duration.Infinite(){

            public final String toString() {
                return "Duration.Undefined";
            }

            public final boolean equals(Object other) {
                return false;
            }

            public final Duration $times(double factor) {
                return this;
            }

            public final int compare(Duration other) {
                if (other == this) {
                    return 0;
                }
                return 1;
            }

            public final Duration unary_$minus() {
                return this;
            }
        };
        Inf = new Duration.Infinite(){

            public final String toString() {
                return "Duration.Inf";
            }

            /*
             * WARNING - void declaration
             */
            public final int compare(Duration other) {
                void var1_1;
                if (other == Duration$.MODULE$.Undefined()) {
                    return -1;
                }
                if (var1_1 == this) {
                    return 0;
                }
                return 1;
            }

            public final Duration unary_$minus() {
                return Duration$.MODULE$.MinusInf();
            }
        };
        MinusInf = new Duration.Infinite(){

            public final String toString() {
                return "Duration.MinusInf";
            }

            public final int compare(Duration other) {
                if (other == this) {
                    return 0;
                }
                return -1;
            }

            public final Duration unary_$minus() {
                return Duration$.MODULE$.Inf();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final Duration apply(double length, TimeUnit unit) {
        void var1_1;
        void var3_2;
        return this.fromNanos((double)var3_2.toNanos(1L) * var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final FiniteDuration apply(long length, TimeUnit unit) {
        void var3_2;
        void var1_1;
        return new FiniteDuration((long)var1_1, (TimeUnit)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public final Duration apply(String s) {
        void var1_1;
        String string;
        int n;
        String takeWhile$extension_$this;
        StringOps$ stringOps$;
        String s1;
        block24: {
            block25: {
                block26: {
                    int filterNot$extension_filter$extension_len = s.length();
                    StringBuilder filterNot$extension_filter$extension_sb = new StringBuilder(filterNot$extension_filter$extension_len);
                    for (int filterNot$extension_filter$extension_i = 0; filterNot$extension_filter$extension_i < filterNot$extension_filter$extension_len; ++filterNot$extension_filter$extension_i) {
                        char filterNot$extension_filter$extension_x = s.charAt(filterNot$extension_filter$extension_i);
                        if (!(!Duration$.$anonfun$apply$1(filterNot$extension_filter$extension_x))) continue;
                        filterNot$extension_filter$extension_sb.append(filterNot$extension_filter$extension_x);
                    }
                    s1 = filterNot$extension_filter$extension_len == filterNot$extension_filter$extension_sb.length() ? s : filterNot$extension_filter$extension_sb.toString();
                    switch (s1 == null ? 0 : s1.hashCode()) {
                        case -1772306297: {
                            if ("Duration.Inf".equals(s1)) {
                                break;
                            }
                            break block25;
                        }
                        case -1283193487: {
                            if (!"MinusInf".equals(s1)) break block25;
                            break block26;
                        }
                        case 73665: {
                            if ("Inf".equals(s1)) {
                                break;
                            }
                            break block25;
                        }
                        case 1354678: {
                            if ("+Inf".equals(s1)) {
                                break;
                            }
                            break block25;
                        }
                        case 1414260: {
                            if (!"-Inf".equals(s1)) break block25;
                            break block26;
                        }
                        case 784790902: {
                            if ("Duration.Undefined".equals(s1)) {
                                return this.Undefined();
                            }
                            break block25;
                        }
                        case 927723627: {
                            if (!"Duration.MinusInf".equals(s1)) break block25;
                            break block26;
                        }
                        case 1189350343: {
                            if ("PlusInf".equals(s1)) {
                                break;
                            }
                            break block25;
                        }
                        default: {
                            break block25;
                        }
                    }
                    return this.Inf();
                }
                return this.MinusInf();
            }
            stringOps$ = StringOps$.MODULE$;
            takeWhile$extension_$this = stringOps$.reverse$extension(s1);
            int takeWhile$extension_indexWhere$extension_len = takeWhile$extension_$this.length();
            for (int takeWhile$extension_indexWhere$extension_i = 0; takeWhile$extension_indexWhere$extension_i < takeWhile$extension_indexWhere$extension_len; ++takeWhile$extension_indexWhere$extension_i) {
                if (!(!Duration$.$anonfun$apply$2(takeWhile$extension_$this.charAt(takeWhile$extension_indexWhere$extension_i)))) continue;
                n = takeWhile$extension_indexWhere$extension_i;
                break block24;
            }
            n = -1;
        }
        int n2 = n;
        switch (n) {
            case -1: {
                string = takeWhile$extension_$this;
                break;
            }
            default: {
                string = takeWhile$extension_$this.substring(0, n2);
            }
        }
        String unitName = stringOps$.reverse$extension(string);
        Option option = this.timeUnit().get(unitName);
        if (option instanceof Some) {
            void var3_4;
            void var2_3;
            Option option2;
            TimeUnit unit = (TimeUnit)((Object)((Some)option).value());
            String valueStr = StringOps$.MODULE$.dropRight$extension(s1, unitName.length());
            Option<Object> option3 = StringParsers$.MODULE$.parseLong(valueStr);
            if (option3 == null) {
                throw null;
            }
            Object map_this = option3;
            if (option3.isEmpty()) {
                option2 = None$.MODULE$;
            } else {
                map_this = ((Option)map_this).get();
                Some<FiniteDuration> some = new Some<FiniteDuration>(Duration$.$anonfun$apply$3(unit, BoxesRunTime.unboxToLong(map_this)));
                option2 = some;
            }
            Option getOrElse_this = option2;
            return option2.isEmpty() ? Duration$.$anonfun$apply$4((String)var2_3, (TimeUnit)var1_1) : var3_4.get();
        }
        throw new NumberFormatException(new StringBuilder(13).append("format error ").append((String)var1_1).toString());
    }

    /*
     * WARNING - void declaration
     */
    private List<String> words(String s) {
        void var1_1;
        ArraySeq.ofRef<String> ofRef2 = Predef$.MODULE$.wrapRefArray(var1_1.trim().split("\\s+"));
        if (ofRef2 == null) {
            throw null;
        }
        return IterableOnceOps.toList$(ofRef2);
    }

    /*
     * WARNING - void declaration
     */
    private List<String> expandLabels(String labels) {
        void var1_1;
        void var2_2;
        Nil$ nil$;
        List flatMap_rest;
        List rest;
        if (!((labels = this.words((String)labels)) instanceof $colon$colon)) {
            throw new MatchError(rest);
        }
        labels = ($colon$colon)labels;
        String hd = (String)(($colon$colon)labels).head();
        rest = (($colon$colon)labels).next$access$1();
        if (rest == null) {
            throw null;
        }
        $colon$colon<Nothing$> flatMap_h = null;
        $colon$colon<Nothing$> flatMap_t = null;
        while (flatMap_rest != Nil$.MODULE$) {
            Iterator flatMap_it = Duration$.$anonfun$expandLabels$1((String)flatMap_rest.head()).iterator();
            while (flatMap_it.hasNext()) {
                $colon$colon<Nothing$> flatMap_nx = new $colon$colon<Nothing$>((Nothing$)flatMap_it.next(), Nil$.MODULE$);
                if (flatMap_t == null) {
                    flatMap_h = flatMap_nx;
                } else {
                    flatMap_t.next_$eq(flatMap_nx);
                }
                flatMap_t = flatMap_nx;
            }
            flatMap_rest = (List)flatMap_rest.tail();
        }
        if (flatMap_h == null) {
            nil$ = Nil$.MODULE$;
        } else {
            void var3_3;
            Statics.releaseFence();
            nil$ = var3_3;
        }
        Nil$ $colon$colon_this = nil$;
        return new $colon$colon<void>(var2_2, (List<void>)var1_1);
    }

    public final Map<TimeUnit, String> timeUnitName() {
        return timeUnitName;
    }

    public final Map<String, TimeUnit> timeUnit() {
        return timeUnit;
    }

    /*
     * WARNING - void declaration
     */
    public final Duration fromNanos(double nanos) {
        void var1_1;
        if (Double.isInfinite(nanos)) {
            if (nanos > 0.0) {
                return this.Inf();
            }
            return this.MinusInf();
        }
        if (Double.isNaN(nanos)) {
            return this.Undefined();
        }
        if (nanos > 9.223372036854776E18 || nanos < -9.223372036854776E18) {
            throw new IllegalArgumentException(new StringBuilder(46).append("trying to construct too large duration with ").append(nanos).append("ns").toString());
        }
        return this.fromNanos(Math.round((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final FiniteDuration fromNanos(long nanos) {
        void var3_9;
        void var1_1;
        void apply_unit2;
        if (nanos % 86400000000000L == 0L) {
            TimeUnit apply_unit2 = TimeUnit.DAYS;
            long apply_length = nanos / 86400000000000L;
            return new FiniteDuration(apply_length, apply_unit2);
        }
        if (apply_unit2 % 3600000000000L == 0L) {
            TimeUnit apply_unit2 = TimeUnit.HOURS;
            void apply_length = apply_unit2 / 3600000000000L;
            return new FiniteDuration((long)apply_length, apply_unit2);
        }
        if (apply_unit2 % 60000000000L == 0L) {
            TimeUnit apply_unit3 = TimeUnit.MINUTES;
            void apply_length = apply_unit2 / 60000000000L;
            return new FiniteDuration((long)apply_length, apply_unit3);
        }
        if (apply_unit2 % 1000000000L == 0L) {
            TimeUnit apply_unit4 = TimeUnit.SECONDS;
            void apply_length = apply_unit2 / 1000000000L;
            return new FiniteDuration((long)apply_length, apply_unit4);
        }
        if (apply_unit2 % 1000000L == 0L) {
            TimeUnit apply_unit5 = TimeUnit.MILLISECONDS;
            void apply_length = apply_unit2 / 1000000L;
            return new FiniteDuration((long)apply_length, apply_unit5);
        }
        if (apply_unit2 % 1000L == 0L) {
            void var1_7;
            TimeUnit apply_unit6 = TimeUnit.MICROSECONDS;
            void apply_length = apply_unit2 / 1000L;
            return new FiniteDuration((long)apply_length, (TimeUnit)var1_7);
        }
        TimeUnit apply_unit7 = TimeUnit.NANOSECONDS;
        return new FiniteDuration((long)var1_1, (TimeUnit)var3_9);
    }

    public final FiniteDuration Zero() {
        return Zero;
    }

    public final Duration.Infinite Undefined() {
        return Undefined;
    }

    public final Duration.Infinite Inf() {
        return Inf;
    }

    public final Duration.Infinite MinusInf() {
        return MinusInf;
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(char x$1) {
        char c;
        return Character.isWhitespace(c);
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(char x$2) {
        char c;
        return Character.isLetter(c);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ FiniteDuration $anonfun$apply$3(TimeUnit unit$1, long x$3) {
        TimeUnit timeUnit;
        void var1_1;
        return MODULE$.apply((long)var1_1, timeUnit);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Duration $anonfun$apply$4(String valueStr$1, TimeUnit unit$1) {
        void var1_1;
        String string;
        return MODULE$.apply(Double.parseDouble(string), (TimeUnit)var1_1);
    }

    public static final /* synthetic */ List $anonfun$expandLabels$1(String s) {
        String string;
        return new $colon$colon<Nothing$>((Nothing$)((Object)s), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(1).append(string).append("s").toString()), Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$timeUnit$2(TimeUnit unit$2, String x$5) {
        TimeUnit timeUnit;
        void var1_1;
        return new Tuple2<void, TimeUnit>(var1_1, timeUnit);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ List $anonfun$timeUnit$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            void var2_3;
            $colon$colon<Nothing$> map_h;
            TimeUnit unit = (TimeUnit)((Object)x0$1._1());
            List names = (String)x0$1._2();
            List list = MODULE$.expandLabels((String)((Object)names));
            if (list == null) {
                throw null;
            }
            List map_this = list;
            if (list == Nil$.MODULE$) {
                return Nil$.MODULE$;
            }
            String string = (String)map_this.head();
            $colon$colon<Nothing$> map_t = map_h = new $colon$colon<Nothing$>((Nothing$)((Object)Duration$.$anonfun$timeUnit$2(unit, string)), Nil$.MODULE$);
            for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                string = (String)map_rest.head();
                $colon$colon<Nothing$> map_nx = new $colon$colon<Nothing$>((Nothing$)((Object)Duration$.$anonfun$timeUnit$2(unit, string)), Nil$.MODULE$);
                map_t.next_$eq(map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            return var2_3;
        }
        throw new MatchError((Object)null);
    }

    private Duration$() {
    }
}

