/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.cache.shaded.dirs;

import xsbt.boot.internal.shaded.coursier.cache.shaded.dirs.GetWinDirs;
import xsbt.boot.internal.shaded.coursier.cache.shaded.dirs.UnsupportedOperatingSystemException;
import xsbt.boot.internal.shaded.coursier.cache.shaded.dirs.Util;

public final class ProjectDirectories {
    public final String projectPath;
    public final String cacheDir;
    public final String configDir;
    public final String dataDir;
    public final String dataLocalDir;
    public final String preferenceDir;
    public final String runtimeDir;

    private ProjectDirectories(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Util.requireNonNull(string);
        this.projectPath = string;
        this.cacheDir = string2;
        this.configDir = string3;
        this.dataDir = string4;
        this.dataLocalDir = string5;
        this.preferenceDir = string6;
        this.runtimeDir = string7;
    }

    public static ProjectDirectories fromPath(String string, GetWinDirs object) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = null;
        switch (Util.operatingSystem) {
            case 'b': 
            case 'l': 
            case 's': {
                object = System.getProperty("user.home");
                string5 = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_CACHE_HOME"), string, (String)object + "/.cache/", string);
                string4 = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_CONFIG_HOME"), string, (String)object + "/.config/", string);
                string2 = string3 = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_DATA_HOME"), string, (String)object + "/.local/share/", string);
                object = string4;
                string6 = Util.linuxRuntimeDir(string);
                break;
            }
            case 'm': {
                object = System.getProperty("user.home");
                string5 = (String)object + "/Library/Caches/" + string;
                string4 = (String)object + "/Library/Application Support/" + string;
                string2 = string3 = (String)object + "/Library/Application Support/" + string;
                object = (String)object + "/Library/Preferences/" + string;
                break;
            }
            case 'w': {
                object = object.getWinDirs("3EB685DB-65F9-4CF6-A03A-E3EF65729F3D", "F1B32785-6FBA-4FCF-9D55-7B8E7F157091");
                string5 = object[0] + '\\' + string;
                object = object[1] + '\\' + string;
                string3 = string5 + "\\data";
                string2 = (String)object + "\\data";
                string4 = string5 + "\\config";
                string5 = (String)object + "\\cache";
                object = string4;
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Project directories are not supported on " + Util.operatingSystemName);
            }
        }
        return new ProjectDirectories(string, string5, string4, string3, string2, (String)object, string6);
    }

    public static ProjectDirectories from(String string, String string2, String string3, GetWinDirs getWinDirs) {
        if (Util.isNullOrEmpty(string2) && Util.isNullOrEmpty(string3)) {
            throw new UnsupportedOperationException("organization and application arguments cannot both be null/empty");
        }
        switch (Util.operatingSystem) {
            case 'b': 
            case 'l': 
            case 's': {
                string = Util.trimLowercaseReplaceWhitespace(string3, "", true);
                break;
            }
            case 'm': {
                string = Util.macOSApplicationPath(string, string2, string3);
                break;
            }
            case 'w': {
                string = Util.windowsApplicationPath(string, string2, string3);
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Base directories are not supported on " + Util.operatingSystemName);
            }
        }
        return ProjectDirectories.fromPath(string, getWinDirs);
    }

    public final String toString() {
        return "ProjectDirectories (" + Util.operatingSystemName + "):\n  projectPath   = '" + this.projectPath + "'\n  cacheDir      = '" + this.cacheDir + "'\n  configDir     = '" + this.configDir + "'\n  dataDir       = '" + this.dataDir + "'\n  dataLocalDir  = '" + this.dataLocalDir + "'\n  preferenceDir = '" + this.preferenceDir + "'\n  runtimeDir    = '" + this.runtimeDir + "'\n";
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (ProjectDirectories)object;
        if (!this.projectPath.equals(((ProjectDirectories)object).projectPath)) {
            return false;
        }
        if (this.cacheDir != null ? !this.cacheDir.equals(((ProjectDirectories)object).cacheDir) : ((ProjectDirectories)object).cacheDir != null) {
            return false;
        }
        if (this.configDir != null ? !this.configDir.equals(((ProjectDirectories)object).configDir) : ((ProjectDirectories)object).configDir != null) {
            return false;
        }
        if (this.dataDir != null ? !this.dataDir.equals(((ProjectDirectories)object).dataDir) : ((ProjectDirectories)object).dataDir != null) {
            return false;
        }
        if (this.dataLocalDir != null ? !this.dataLocalDir.equals(((ProjectDirectories)object).dataLocalDir) : ((ProjectDirectories)object).dataLocalDir != null) {
            return false;
        }
        if (this.preferenceDir != null ? !this.preferenceDir.equals(((ProjectDirectories)object).preferenceDir) : ((ProjectDirectories)object).preferenceDir != null) {
            return false;
        }
        return !(this.runtimeDir != null ? !this.runtimeDir.equals(((ProjectDirectories)object).runtimeDir) : ((ProjectDirectories)object).runtimeDir != null);
    }

    public final int hashCode() {
        int n = this.projectPath.hashCode();
        n = n * 31 + (this.cacheDir != null ? this.cacheDir.hashCode() : 0);
        n = n * 31 + (this.configDir != null ? this.configDir.hashCode() : 0);
        n = n * 31 + (this.dataDir != null ? this.dataDir.hashCode() : 0);
        n = n * 31 + (this.dataLocalDir != null ? this.dataLocalDir.hashCode() : 0);
        n = n * 31 + (this.preferenceDir != null ? this.preferenceDir.hashCode() : 0);
        n = n * 31 + (this.runtimeDir != null ? this.runtimeDir.hashCode() : 0);
        return n;
    }
}

