/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.immutable.Vector0$;
import scala.collection.immutable.Vector1;
import scala.collection.immutable.Vector2;
import scala.collection.immutable.Vector3;
import scala.collection.immutable.Vector4;
import scala.collection.immutable.Vector5;
import scala.collection.immutable.Vector6;
import scala.collection.immutable.VectorInline$;
import scala.collection.immutable.VectorStatics$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ReusableBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class VectorBuilder<A>
implements ReusableBuilder<A, Vector<A>> {
    private Object[][][][][][] a6;
    private Object[][][][][] a5;
    private Object[][][][] a4;
    private Object[][][] a3;
    private Object[][] a2;
    private Object[] a1;
    private int len1;
    private int lenRest;
    private int offset;
    private boolean prefixIsRightAligned;
    private int depth;

    public VectorBuilder() {
        Growable.$init$(this);
        Builder.$init$(this);
        this.a1 = new Object[32];
        this.len1 = 0;
        this.lenRest = 0;
        this.offset = 0;
        this.prefixIsRightAligned = false;
        this.depth = 1;
    }

    @Override
    public final Growable $plus$eq(Object elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public final Growable $plus$eq(Object elem1, Object elem2, Seq elems) {
        return Growable.$plus$eq$(this, elem1, elem2, elems);
    }

    @Override
    public final Growable $plus$plus$eq(IterableOnce elems) {
        return Growable.$plus$plus$eq$(this, elems);
    }

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public int sizeHint$default$2() {
        return Builder.sizeHint$default$2$(this);
    }

    @Override
    public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<A, NewTo> mapResult(Function1<Vector<A>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    private final void setLen(int i) {
        this.len1 = i & 0x1F;
        this.lenRest = i - this.len1;
    }

    @Override
    public int knownSize() {
        return this.len1 + this.lenRest - this.offset;
    }

    public int size() {
        return this.knownSize();
    }

    public boolean isEmpty() {
        return this.knownSize() == 0;
    }

    public boolean nonEmpty() {
        return this.knownSize() != 0;
    }

    @Override
    public void clear() {
        this.a6 = null;
        this.a5 = null;
        this.a4 = null;
        this.a3 = null;
        this.a2 = null;
        this.a1 = new Object[32];
        this.len1 = 0;
        this.lenRest = 0;
        this.offset = 0;
        this.prefixIsRightAligned = false;
        this.depth = 1;
    }

    public void initSparse(int size, A elem) {
        this.setLen(size);
        Arrays.fill(this.a1, elem);
        if (size > 32) {
            this.a2 = new Object[32][];
            Arrays.fill((Object[])this.a2, this.a1);
            if (size > 1024) {
                this.a3 = new Object[32][][];
                Arrays.fill((Object[])this.a3, this.a2);
                if (size > 32768) {
                    this.a4 = new Object[32][][][];
                    Arrays.fill((Object[])this.a4, this.a3);
                    if (size > 0x100000) {
                        this.a5 = new Object[32][][][][];
                        Arrays.fill((Object[])this.a5, this.a4);
                        if (size > 0x2000000) {
                            this.a6 = new Object[64][][][][][];
                            Arrays.fill((Object[])this.a6, this.a5);
                            this.depth = 6;
                            return;
                        }
                        this.depth = 5;
                        return;
                    }
                    this.depth = 4;
                    return;
                }
                this.depth = 3;
                return;
            }
            this.depth = 2;
            return;
        }
        this.depth = 1;
    }

    public void initFrom(Object[] prefix1) {
        this.depth = 1;
        this.setLen(prefix1.length);
        this.a1 = VectorInline$.MODULE$.copyOrUse(prefix1, 0, 32);
        if (this.len1 == 0 && this.lenRest > 0) {
            this.len1 = 32;
            this.lenRest -= 32;
            return;
        }
    }

    public VectorBuilder<A> initFrom(Vector<?> v) {
        int n = v.vectorSliceCount();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                Vector1 v1 = (Vector1)v;
                this.depth = 1;
                this.setLen(v1.prefix1().length);
                this.a1 = VectorInline$.MODULE$.copyOrUse(v1.prefix1(), 0, 32);
                break;
            }
            case 3: {
                Vector2 v2 = (Vector2)v;
                Object[][] d2 = v2.data2();
                this.a1 = VectorInline$.MODULE$.copyOrUse(v2.suffix1(), 0, 32);
                this.depth = 2;
                this.offset = 32 - v2.len1();
                this.setLen(v2.length0() + this.offset);
                this.a2 = new Object[32][];
                this.a2[0] = v2.prefix1();
                System.arraycopy(d2, 0, this.a2, 1, d2.length);
                this.a2[d2.length + 1] = this.a1;
                break;
            }
            case 5: {
                Vector3 v3 = (Vector3)v;
                Object[][][] d3 = v3.data3();
                Object[][] s2 = v3.suffix2();
                this.a1 = VectorInline$.MODULE$.copyOrUse(v3.suffix1(), 0, 32);
                this.depth = 3;
                this.offset = 1024 - v3.len12();
                this.setLen(v3.length0() + this.offset);
                this.a3 = new Object[32][][];
                this.a3[0] = VectorStatics$.MODULE$.copyPrepend(v3.prefix1(), (T[])v3.prefix2());
                System.arraycopy(d3, 0, this.a3, 1, d3.length);
                this.a2 = (Object[][])Arrays.copyOf(s2, 32);
                this.a3[d3.length + 1] = this.a2;
                this.a2[s2.length] = this.a1;
                break;
            }
            case 7: {
                Vector4 v4 = (Vector4)v;
                Object[][][][] d4 = v4.data4();
                Object[][][] s3 = v4.suffix3();
                Object[][] s2 = v4.suffix2();
                this.a1 = VectorInline$.MODULE$.copyOrUse(v4.suffix1(), 0, 32);
                this.depth = 4;
                this.offset = 32768 - v4.len123();
                this.setLen(v4.length0() + this.offset);
                this.a4 = new Object[32][][][];
                this.a4[0] = VectorStatics$.MODULE$.copyPrepend(VectorStatics$.MODULE$.copyPrepend(v4.prefix1(), (T[])v4.prefix2()), (T[])v4.prefix3());
                System.arraycopy(d4, 0, this.a4, 1, d4.length);
                this.a3 = (Object[][][])Arrays.copyOf(s3, 32);
                this.a2 = (Object[][])Arrays.copyOf(s2, 32);
                this.a4[d4.length + 1] = this.a3;
                this.a3[s3.length] = this.a2;
                this.a2[s2.length] = this.a1;
                break;
            }
            case 9: {
                Vector5 v5 = (Vector5)v;
                Object[][][][][] d5 = v5.data5();
                Object[][][][] s4 = v5.suffix4();
                Object[][][] s3 = v5.suffix3();
                Object[][] s2 = v5.suffix2();
                this.a1 = VectorInline$.MODULE$.copyOrUse(v5.suffix1(), 0, 32);
                this.depth = 5;
                this.offset = 0x100000 - v5.len1234();
                this.setLen(v5.length0() + this.offset);
                this.a5 = new Object[32][][][][];
                this.a5[0] = VectorStatics$.MODULE$.copyPrepend(VectorStatics$.MODULE$.copyPrepend(VectorStatics$.MODULE$.copyPrepend(v5.prefix1(), (T[])v5.prefix2()), (T[])v5.prefix3()), (T[])v5.prefix4());
                System.arraycopy(d5, 0, this.a5, 1, d5.length);
                this.a4 = (Object[][][][])Arrays.copyOf(s4, 32);
                this.a3 = (Object[][][])Arrays.copyOf(s3, 32);
                this.a2 = (Object[][])Arrays.copyOf(s2, 32);
                this.a5[d5.length + 1] = this.a4;
                this.a4[s4.length] = this.a3;
                this.a3[s3.length] = this.a2;
                this.a2[s2.length] = this.a1;
                break;
            }
            case 11: {
                Vector6 v6 = (Vector6)v;
                Object[][][][][][] d6 = v6.data6();
                Object[][][][][] s5 = v6.suffix5();
                Object[][][][] s4 = v6.suffix4();
                Object[][][] s3 = v6.suffix3();
                Object[][] s2 = v6.suffix2();
                this.a1 = VectorInline$.MODULE$.copyOrUse(v6.suffix1(), 0, 32);
                this.depth = 6;
                this.offset = 0x2000000 - v6.len12345();
                this.setLen(v6.length0() + this.offset);
                this.a6 = new Object[64][][][][][];
                this.a6[0] = VectorStatics$.MODULE$.copyPrepend(VectorStatics$.MODULE$.copyPrepend(VectorStatics$.MODULE$.copyPrepend(VectorStatics$.MODULE$.copyPrepend(v6.prefix1(), (T[])v6.prefix2()), (T[])v6.prefix3()), (T[])v6.prefix4()), (T[])v6.prefix5());
                System.arraycopy(d6, 0, this.a6, 1, d6.length);
                this.a5 = (Object[][][][][])Arrays.copyOf(s5, 32);
                this.a4 = (Object[][][][])Arrays.copyOf(s4, 32);
                this.a3 = (Object[][][])Arrays.copyOf(s3, 32);
                this.a2 = (Object[][])Arrays.copyOf(s2, 32);
                this.a6[d6.length + 1] = this.a5;
                this.a5[s5.length] = this.a4;
                this.a4[s4.length] = this.a3;
                this.a3[s3.length] = this.a2;
                this.a2[s2.length] = this.a1;
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
        if (this.len1 == 0 && this.lenRest > 0) {
            this.len1 = 32;
            this.lenRest -= 32;
        }
        return this;
    }

    public VectorBuilder<A> alignTo(int before, Vector<A> bigVector) {
        Tuple2<Integer, Integer> tuple2;
        if (this.len1 != 0 || this.lenRest != 0) {
            throw new UnsupportedOperationException("A non-empty VectorBuilder cannot be aligned retrospectively. Please call .reset() or use a new VectorBuilder.");
        }
        Vector<A> vector = bigVector;
        if (((Object)Vector0$.MODULE$).equals(vector)) {
            tuple2 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(0), BoxesRunTime.boxToInteger(1));
        } else if (vector instanceof Vector1) {
            Vector1 vector1;
            Vector1 v1 = vector1 = (Vector1)vector;
            tuple2 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(0), BoxesRunTime.boxToInteger(1));
        } else if (vector instanceof Vector2) {
            Vector2 vector2;
            Vector2 v2 = vector2 = (Vector2)vector;
            tuple2 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(v2.len1()), BoxesRunTime.boxToInteger(32));
        } else if (vector instanceof Vector3) {
            Vector3 vector3;
            Vector3 v3 = vector3 = (Vector3)vector;
            tuple2 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(v3.len12()), BoxesRunTime.boxToInteger(1024));
        } else if (vector instanceof Vector4) {
            Vector4 vector4;
            Vector4 v4 = vector4 = (Vector4)vector;
            tuple2 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(v4.len123()), BoxesRunTime.boxToInteger(32768));
        } else if (vector instanceof Vector5) {
            Vector5 vector5;
            Vector5 v5 = vector5 = (Vector5)vector;
            tuple2 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(v5.len1234()), BoxesRunTime.boxToInteger(0x100000));
        } else if (vector instanceof Vector6) {
            Vector6 vector6;
            Vector6 v6 = vector6 = (Vector6)vector;
            tuple2 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(v6.len12345()), BoxesRunTime.boxToInteger(0x2000000));
        } else {
            throw new MatchError(vector);
        }
        Tuple2<Integer, Integer> tuple22 = tuple2;
        int prefixLength = BoxesRunTime.unboxToInt(tuple22._1());
        int maxPrefixLength = BoxesRunTime.unboxToInt(tuple22._2());
        if (maxPrefixLength == 1) {
            return this;
        }
        int overallPrefixLength = (before + prefixLength) % maxPrefixLength;
        this.offset = (maxPrefixLength - overallPrefixLength) % maxPrefixLength;
        this.advanceN(this.offset & 0xFFFFFFE0);
        this.len1 = this.offset & 0x1F;
        this.prefixIsRightAligned = true;
        return this;
    }

    private void leftAlignPrefix() {
        Object[] a = null;
        Object[] aParent = null;
        if (this.depth >= 6) {
            a = this.a6;
            int i = this.offset >>> 25;
            if (i > 0) {
                System.arraycopy(a, i, a, 0, 64 - i);
            }
            this.shrinkOffsetIfToLarge$1(0x2000000);
            if (this.lenRest >>> 25 == 0) {
                this.depth = 5;
            }
            aParent = a;
            a = (Object[])a[0];
        }
        if (this.depth >= 5) {
            if (a == null) {
                a = this.a5;
            }
            int i = this.offset >>> 20 & 0x1F;
            if (this.depth == 5) {
                if (i > 0) {
                    System.arraycopy(a, i, a, 0, 32 - i);
                }
                this.a5 = (Object[][][][][])a;
                this.shrinkOffsetIfToLarge$1(0x100000);
                if (this.lenRest >>> 20 == 0) {
                    this.depth = 4;
                }
            } else {
                if (i > 0) {
                    a = Arrays.copyOfRange(a, i, 32);
                }
                aParent[0] = a;
            }
            aParent = a;
            a = (Object[])a[0];
        }
        if (this.depth >= 4) {
            if (a == null) {
                a = this.a4;
            }
            int i = this.offset >>> 15 & 0x1F;
            if (this.depth == 4) {
                if (i > 0) {
                    System.arraycopy(a, i, a, 0, 32 - i);
                }
                this.a4 = (Object[][][][])a;
                this.shrinkOffsetIfToLarge$1(32768);
                if (this.lenRest >>> 15 == 0) {
                    this.depth = 3;
                }
            } else {
                if (i > 0) {
                    a = Arrays.copyOfRange(a, i, 32);
                }
                aParent[0] = a;
            }
            aParent = a;
            a = (Object[])a[0];
        }
        if (this.depth >= 3) {
            if (a == null) {
                a = this.a3;
            }
            int i = this.offset >>> 10 & 0x1F;
            if (this.depth == 3) {
                if (i > 0) {
                    System.arraycopy(a, i, a, 0, 32 - i);
                }
                this.a3 = (Object[][][])a;
                this.shrinkOffsetIfToLarge$1(1024);
                if (this.lenRest >>> 10 == 0) {
                    this.depth = 2;
                }
            } else {
                if (i > 0) {
                    a = Arrays.copyOfRange(a, i, 32);
                }
                aParent[0] = a;
            }
            aParent = a;
            a = (Object[])a[0];
        }
        if (this.depth >= 2) {
            if (a == null) {
                a = this.a2;
            }
            int i = this.offset >>> 5 & 0x1F;
            if (this.depth == 2) {
                if (i > 0) {
                    System.arraycopy(a, i, a, 0, 32 - i);
                }
                this.a2 = (Object[][])a;
                this.shrinkOffsetIfToLarge$1(32);
                if (this.lenRest >>> 5 == 0) {
                    this.depth = 1;
                }
            } else {
                if (i > 0) {
                    a = Arrays.copyOfRange(a, i, 32);
                }
                aParent[0] = a;
            }
            aParent = a;
            a = (Object[])a[0];
        }
        if (this.depth >= 1) {
            if (a == null) {
                a = this.a1;
            }
            int i = this.offset & 0x1F;
            if (this.depth == 1) {
                if (i > 0) {
                    System.arraycopy(a, i, a, 0, 32 - i);
                }
                this.a1 = a;
                this.len1 -= this.offset;
                this.offset = 0;
            } else {
                if (i > 0) {
                    a = Arrays.copyOfRange(a, i, 32);
                }
                aParent[0] = a;
            }
        }
        this.prefixIsRightAligned = false;
    }

    @Override
    public VectorBuilder<A> addOne(A elem) {
        if (this.len1 == 32) {
            this.advance();
        }
        this.a1[this.len1] = elem;
        ++this.len1;
        return this;
    }

    private void addArr1(Object[] data) {
        int dl = data.length;
        if (dl > 0) {
            if (this.len1 == 32) {
                this.advance();
            }
            int copy1 = Math.min(32 - this.len1, dl);
            int copy2 = dl - copy1;
            System.arraycopy(data, 0, this.a1, this.len1, copy1);
            this.len1 += copy1;
            if (copy2 > 0) {
                this.advance();
                System.arraycopy(data, copy1, this.a1, 0, copy2);
                this.len1 += copy2;
                return;
            }
            return;
        }
    }

    private void addArrN(Object[] slice, int dim) {
        Object object = Predef$.MODULE$.refArrayOps(slice);
        if (ArrayOps$.MODULE$.isEmpty$extension(object)) {
            return;
        }
        if (this.len1 == 32) {
            this.advance();
        }
        int sl = slice.length;
        int n = dim;
        switch (n) {
            case 2: {
                int copy1 = Math.min(1024 - this.lenRest >>> 5 & 0x1F, sl);
                int copy2 = sl - copy1;
                int destPos = this.lenRest >>> 5 & 0x1F;
                System.arraycopy(slice, 0, this.a2, destPos, copy1);
                this.advanceN(32 * copy1);
                if (copy2 > 0) {
                    System.arraycopy(slice, copy1, this.a2, 0, copy2);
                    this.advanceN(32 * copy2);
                    return;
                }
                return;
            }
            case 3: {
                if (this.lenRest % 1024 != 0) {
                    Object object2 = Predef$.MODULE$.refArrayOps(slice);
                    ArrayOps$.MODULE$.foreach$extension(object2, e -> this.addArrN((Object[])e, 2));
                    return;
                }
                int copy1 = Math.min(32768 - this.lenRest >>> 10 & 0x1F, sl);
                int copy2 = sl - copy1;
                int destPos = this.lenRest >>> 10 & 0x1F;
                System.arraycopy(slice, 0, this.a3, destPos, copy1);
                this.advanceN(1024 * copy1);
                if (copy2 > 0) {
                    System.arraycopy(slice, copy1, this.a3, 0, copy2);
                    this.advanceN(1024 * copy2);
                    return;
                }
                return;
            }
            case 4: {
                if (this.lenRest % 32768 != 0) {
                    Object object3 = Predef$.MODULE$.refArrayOps(slice);
                    ArrayOps$.MODULE$.foreach$extension(object3, e -> this.addArrN((Object[])e, 3));
                    return;
                }
                int copy1 = Math.min(0x100000 - this.lenRest >>> 15 & 0x1F, sl);
                int copy2 = sl - copy1;
                int destPos = this.lenRest >>> 15 & 0x1F;
                System.arraycopy(slice, 0, this.a4, destPos, copy1);
                this.advanceN(32768 * copy1);
                if (copy2 > 0) {
                    System.arraycopy(slice, copy1, this.a4, 0, copy2);
                    this.advanceN(32768 * copy2);
                    return;
                }
                return;
            }
            case 5: {
                if (this.lenRest % 0x100000 != 0) {
                    Object object4 = Predef$.MODULE$.refArrayOps(slice);
                    ArrayOps$.MODULE$.foreach$extension(object4, e -> this.addArrN((Object[])e, 4));
                    return;
                }
                int copy1 = Math.min(0x2000000 - this.lenRest >>> 20 & 0x1F, sl);
                int copy2 = sl - copy1;
                int destPos = this.lenRest >>> 20 & 0x1F;
                System.arraycopy(slice, 0, this.a5, destPos, copy1);
                this.advanceN(0x100000 * copy1);
                if (copy2 > 0) {
                    System.arraycopy(slice, copy1, this.a5, 0, copy2);
                    this.advanceN(0x100000 * copy2);
                    return;
                }
                return;
            }
            case 6: {
                if (this.lenRest % 0x2000000 != 0) {
                    Object object5 = Predef$.MODULE$.refArrayOps(slice);
                    ArrayOps$.MODULE$.foreach$extension(object5, e -> this.addArrN((Object[])e, 5));
                    return;
                }
                int destPos = this.lenRest >>> 25;
                int copy1 = sl;
                if (destPos + copy1 > 64) {
                    throw new IllegalArgumentException("exceeding 2^31 elements");
                }
                System.arraycopy(slice, 0, this.a6, destPos, copy1);
                this.advanceN(0x2000000 * copy1);
                return;
            }
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n));
    }

    private VectorBuilder<A> addVector(Vector<A> xs) {
        int sliceCount = xs.vectorSliceCount();
        for (int sliceIdx = 0; sliceIdx < sliceCount; ++sliceIdx) {
            Object[] slice = xs.vectorSlice(sliceIdx);
            int n = VectorInline$.MODULE$.vectorSliceDim(sliceCount, sliceIdx);
            if (1 == n) {
                this.addArr1(slice);
                continue;
            }
            int n2 = n;
            if (this.len1 == 32 || this.len1 == 0) {
                this.addArrN(slice, n2);
                continue;
            }
            int n3 = n;
            VectorStatics$.MODULE$.foreachRec(n3 - 2, slice, data -> this.addArr1((Object[])data));
        }
        return this;
    }

    @Override
    public VectorBuilder<A> addAll(IterableOnce<A> xs) {
        IterableOnce<A> iterableOnce = xs;
        if (iterableOnce instanceof Vector) {
            Vector vector;
            Vector v = vector = (Vector)iterableOnce;
            if (this.len1 == 0 && this.lenRest == 0 && !this.prefixIsRightAligned) {
                return this.initFrom(v);
            }
            return this.addVector(v);
        }
        return (VectorBuilder)Growable.addAll$(this, xs);
    }

    private void advance() {
        int idx = this.lenRest + 32;
        int xor = idx ^ this.lenRest;
        this.lenRest = idx;
        this.len1 = 0;
        this.advance1(idx, xor);
    }

    private void advanceN(int n) {
        if (n > 0) {
            int idx = this.lenRest + n;
            int xor = idx ^ this.lenRest;
            this.lenRest = idx;
            this.len1 = 0;
            this.advance1(idx, xor);
            return;
        }
    }

    private void advance1(int idx, int xor) {
        if (xor <= 0) {
            throw new IllegalArgumentException("advance1(" + idx + ", " + xor + "): a1=" + this.a1 + ", a2=" + this.a2 + ", a3=" + this.a3 + ", a4=" + this.a4 + ", a5=" + this.a5 + ", a6=" + this.a6 + ", depth=" + this.depth);
        }
        if (xor < 1024) {
            if (this.depth <= 1) {
                this.a2 = new Object[32][];
                this.a2[0] = this.a1;
                this.depth = 2;
            }
            this.a1 = new Object[32];
            this.a2[idx >>> 5 & 0x1F] = this.a1;
            return;
        }
        if (xor < 32768) {
            if (this.depth <= 2) {
                this.a3 = new Object[32][][];
                this.a3[0] = this.a2;
                this.depth = 3;
            }
            this.a1 = new Object[32];
            this.a2 = new Object[32][];
            this.a2[idx >>> 5 & 0x1F] = this.a1;
            this.a3[idx >>> 10 & 0x1F] = this.a2;
            return;
        }
        if (xor < 0x100000) {
            if (this.depth <= 3) {
                this.a4 = new Object[32][][][];
                this.a4[0] = this.a3;
                this.depth = 4;
            }
            this.a1 = new Object[32];
            this.a2 = new Object[32][];
            this.a3 = new Object[32][][];
            this.a2[idx >>> 5 & 0x1F] = this.a1;
            this.a3[idx >>> 10 & 0x1F] = this.a2;
            this.a4[idx >>> 15 & 0x1F] = this.a3;
            return;
        }
        if (xor < 0x2000000) {
            if (this.depth <= 4) {
                this.a5 = new Object[32][][][][];
                this.a5[0] = this.a4;
                this.depth = 5;
            }
            this.a1 = new Object[32];
            this.a2 = new Object[32][];
            this.a3 = new Object[32][][];
            this.a4 = new Object[32][][][];
            this.a2[idx >>> 5 & 0x1F] = this.a1;
            this.a3[idx >>> 10 & 0x1F] = this.a2;
            this.a4[idx >>> 15 & 0x1F] = this.a3;
            this.a5[idx >>> 20 & 0x1F] = this.a4;
            return;
        }
        if (this.depth <= 5) {
            this.a6 = new Object[64][][][][][];
            this.a6[0] = this.a5;
            this.depth = 6;
        }
        this.a1 = new Object[32];
        this.a2 = new Object[32][];
        this.a3 = new Object[32][][];
        this.a4 = new Object[32][][][];
        this.a5 = new Object[32][][][][];
        this.a2[idx >>> 5 & 0x1F] = this.a1;
        this.a3[idx >>> 10 & 0x1F] = this.a2;
        this.a4[idx >>> 15 & 0x1F] = this.a3;
        this.a5[idx >>> 20 & 0x1F] = this.a4;
        this.a6[idx >>> 25] = this.a5;
    }

    @Override
    public Vector<A> result() {
        int len;
        int realLen;
        if (this.prefixIsRightAligned) {
            this.leftAlignPrefix();
        }
        if ((realLen = (len = this.len1 + this.lenRest) - this.offset) == 0) {
            return Vector$.MODULE$.empty();
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("Vector cannot have negative size " + len);
        }
        if (len <= 32) {
            return new Vector1(VectorInline$.MODULE$.copyIfDifferentSize(this.a1, realLen));
        }
        if (len <= 1024) {
            int i1 = len - 1 & 0x1F;
            int i2 = len - 1 >>> 5;
            Object[][] data = (Object[][])Arrays.copyOfRange(this.a2, 1, i2);
            Object[] prefix1 = this.a2[0];
            Object[] suffix1 = VectorInline$.MODULE$.copyIfDifferentSize(this.a2[i2], i1 + 1);
            return new Vector2(prefix1, 32 - this.offset, data, suffix1, realLen);
        }
        if (len <= 32768) {
            int i1 = len - 1 & 0x1F;
            int i2 = len - 1 >>> 5 & 0x1F;
            int i3 = len - 1 >>> 10;
            Object[][][] data = (Object[][][])Arrays.copyOfRange(this.a3, 1, i3);
            Object[][] prefix2 = (Object[][])VectorInline$.MODULE$.copyTail((T[])this.a3[0]);
            Object[] prefix1 = this.a3[0][0];
            Object[][] suffix2 = (Object[][])Arrays.copyOf(this.a3[i3], i2);
            Object[] suffix1 = VectorInline$.MODULE$.copyIfDifferentSize(this.a3[i3][i2], i1 + 1);
            int len1 = prefix1.length;
            int len12 = len1 + prefix2.length * 32;
            return new Vector3(prefix1, len1, prefix2, len12, data, suffix2, suffix1, realLen);
        }
        if (len <= 0x100000) {
            int i1 = len - 1 & 0x1F;
            int i2 = len - 1 >>> 5 & 0x1F;
            int i3 = len - 1 >>> 10 & 0x1F;
            int i4 = len - 1 >>> 15;
            Object[][][][] data = (Object[][][][])Arrays.copyOfRange(this.a4, 1, i4);
            Object[][][] prefix3 = (Object[][][])VectorInline$.MODULE$.copyTail((T[])this.a4[0]);
            Object[][] prefix2 = (Object[][])VectorInline$.MODULE$.copyTail((T[])this.a4[0][0]);
            Object[] prefix1 = this.a4[0][0][0];
            Object[][][] suffix3 = (Object[][][])Arrays.copyOf(this.a4[i4], i3);
            Object[][] suffix2 = (Object[][])Arrays.copyOf(this.a4[i4][i3], i2);
            Object[] suffix1 = VectorInline$.MODULE$.copyIfDifferentSize(this.a4[i4][i3][i2], i1 + 1);
            int len1 = prefix1.length;
            int len12 = len1 + prefix2.length * 32;
            int len123 = len12 + prefix3.length * 1024;
            return new Vector4(prefix1, len1, prefix2, len12, prefix3, len123, data, suffix3, suffix2, suffix1, realLen);
        }
        if (len <= 0x2000000) {
            int i1 = len - 1 & 0x1F;
            int i2 = len - 1 >>> 5 & 0x1F;
            int i3 = len - 1 >>> 10 & 0x1F;
            int i4 = len - 1 >>> 15 & 0x1F;
            int i5 = len - 1 >>> 20;
            Object[][][][][] data = (Object[][][][][])Arrays.copyOfRange(this.a5, 1, i5);
            Object[][][][] prefix4 = (Object[][][][])VectorInline$.MODULE$.copyTail((T[])this.a5[0]);
            Object[][][] prefix3 = (Object[][][])VectorInline$.MODULE$.copyTail((T[])this.a5[0][0]);
            Object[][] prefix2 = (Object[][])VectorInline$.MODULE$.copyTail((T[])this.a5[0][0][0]);
            Object[] prefix1 = this.a5[0][0][0][0];
            Object[][][][] suffix4 = (Object[][][][])Arrays.copyOf(this.a5[i5], i4);
            Object[][][] suffix3 = (Object[][][])Arrays.copyOf(this.a5[i5][i4], i3);
            Object[][] suffix2 = (Object[][])Arrays.copyOf(this.a5[i5][i4][i3], i2);
            Object[] suffix1 = VectorInline$.MODULE$.copyIfDifferentSize(this.a5[i5][i4][i3][i2], i1 + 1);
            int len1 = prefix1.length;
            int len12 = len1 + prefix2.length * 32;
            int len123 = len12 + prefix3.length * 1024;
            int len1234 = len123 + prefix4.length * 32768;
            return new Vector5(prefix1, len1, prefix2, len12, prefix3, len123, prefix4, len1234, data, suffix4, suffix3, suffix2, suffix1, realLen);
        }
        int i1 = len - 1 & 0x1F;
        int i2 = len - 1 >>> 5 & 0x1F;
        int i3 = len - 1 >>> 10 & 0x1F;
        int i4 = len - 1 >>> 15 & 0x1F;
        int i5 = len - 1 >>> 20 & 0x1F;
        int i6 = len - 1 >>> 25;
        Object[][][][][][] data = (Object[][][][][][])Arrays.copyOfRange(this.a6, 1, i6);
        Object[][][][][] prefix5 = (Object[][][][][])VectorInline$.MODULE$.copyTail((T[])this.a6[0]);
        Object[][][][] prefix4 = (Object[][][][])VectorInline$.MODULE$.copyTail((T[])this.a6[0][0]);
        Object[][][] prefix3 = (Object[][][])VectorInline$.MODULE$.copyTail((T[])this.a6[0][0][0]);
        Object[][] prefix2 = (Object[][])VectorInline$.MODULE$.copyTail((T[])this.a6[0][0][0][0]);
        Object[] prefix1 = this.a6[0][0][0][0][0];
        Object[][][][][] suffix5 = (Object[][][][][])Arrays.copyOf(this.a6[i6], i5);
        Object[][][][] suffix4 = (Object[][][][])Arrays.copyOf(this.a6[i6][i5], i4);
        Object[][][] suffix3 = (Object[][][])Arrays.copyOf(this.a6[i6][i5][i4], i3);
        Object[][] suffix2 = (Object[][])Arrays.copyOf(this.a6[i6][i5][i4][i3], i2);
        Object[] suffix1 = VectorInline$.MODULE$.copyIfDifferentSize(this.a6[i6][i5][i4][i3][i2], i1 + 1);
        int len1 = prefix1.length;
        int len12 = len1 + prefix2.length * 32;
        int len123 = len12 + prefix3.length * 1024;
        int len1234 = len123 + prefix4.length * 32768;
        int len12345 = len1234 + prefix5.length * 0x100000;
        return new Vector6(prefix1, len1, prefix2, len12, prefix3, len123, prefix4, len1234, prefix5, len12345, data, suffix5, suffix4, suffix3, suffix2, suffix1, realLen);
    }

    public String toString() {
        return "VectorBuilder(len1=" + this.len1 + ", lenRest=" + this.lenRest + ", offset=" + this.offset + ", depth=" + this.depth + ")";
    }

    public Object[] getData() {
        return (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((T[])new Object[][]{this.a1, this.a2, this.a3, this.a4, this.a5, this.a6}), ClassTag$.MODULE$.apply(Object.class).wrap());
    }

    private final void shrinkOffsetIfToLarge$1(int width) {
        int newOffset = this.offset % width;
        this.lenRest -= this.offset - newOffset;
        this.offset = newOffset;
    }
}

