/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.modules.search.Bundle;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.netbeans.spi.search.SearchScopeDefinitionProvider;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public class OpenFilesSearchScopeProvider
extends SearchScopeDefinitionProvider {
    @Override
    public List<SearchScopeDefinition> createSearchScopeDefinitions() {
        ArrayList<SearchScopeDefinition> arrayList = new ArrayList<SearchScopeDefinition>(1);
        arrayList.add(new OpenFilesScope());
        return arrayList;
    }

    private static class OpenFilesScope
    extends SearchScopeDefinition {
        private static final String ICON_PATH = "org/netbeans/modules/search/res/multi_selection.png";
        private static final Icon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/search/res/multi_selection.png", (boolean)false);

        private OpenFilesScope() {
        }

        @Override
        public String getTypeId() {
            return "openFiles";
        }

        @Override
        public String getDisplayName() {
            return Bundle.LBL_OpenFileScope(this.getCurrentlyOpenedFiles().size());
        }

        @Override
        public boolean isApplicable() {
            Collection<FileObject> collection = this.getCurrentlyOpenedFiles();
            return collection != null && !collection.isEmpty();
        }

        @Override
        public SearchInfo getSearchInfo() {
            Collection<FileObject> collection = this.getCurrentlyOpenedFiles();
            return SearchInfoUtils.createSearchInfoForRoots(collection.toArray(new FileObject[0]));
        }

        @Override
        public int getPriority() {
            return 450;
        }

        @Override
        public void clean() {
        }

        @Override
        public Icon getIcon() {
            return ICON;
        }

        private Collection<FileObject> getCurrentlyOpenedFiles() {
            LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
            for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
                FileObject fileObject;
                DataObject dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class);
                if (!topComponent.isOpened() || dataObject == null || !this.isFromEditorWindow(dataObject, topComponent) || (fileObject = dataObject.getPrimaryFile()) == null) continue;
                linkedHashSet.add(fileObject);
            }
            return linkedHashSet;
        }

        protected boolean isFromEditorWindow(DataObject dataObject, TopComponent topComponent) {
            EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
            if (editorCookie != null) {
                return (Boolean)Mutex.EVENT.readAccess(() -> topComponent instanceof CloneableTopComponent || NbDocument.findRecentEditorPane((EditorCookie)editorCookie) != null);
            }
            return false;
        }
    }
}

