/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked;

import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethod;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethodImplementation$1;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethodImplementation$2;
import com.android.tools.smali.dexlib2.dexbacked.util.DebugInfo;
import com.android.tools.smali.dexlib2.dexbacked.util.DebugInfo$DebugInfoImpl;
import com.android.tools.smali.dexlib2.dexbacked.util.DebugInfo$EmptyDebugInfo;
import com.android.tools.smali.dexlib2.iface.MethodImplementation;
import java.util.Collections;
import java.util.List;

public class DexBackedMethodImplementation
implements MethodImplementation {
    public final DexBackedDexFile dexFile;
    public final DexBackedMethod method;
    public final int codeOffset;

    public DexBackedMethodImplementation(DexBackedDexFile dexBackedDexFile, DexBackedMethod dexBackedMethod, int n) {
        this.dexFile = dexBackedDexFile;
        this.method = dexBackedMethod;
        this.codeOffset = n;
    }

    @Override
    public int getRegisterCount() {
        return this.dexFile.dataBuffer.readUshort(this.codeOffset);
    }

    public int getInstructionsSize() {
        return this.dexFile.dataBuffer.readSmallUint(this.codeOffset + 12);
    }

    public int getInstructionsStartOffset() {
        return this.codeOffset + 16;
    }

    @Override
    public final Iterable getInstructions() {
        int n = this.getInstructionsStartOffset();
        int n2 = this.getInstructionsSize() * 2 + n;
        return new DexBackedMethodImplementation$1(this, n, n2);
    }

    public int getTriesSize() {
        return this.dexFile.dataBuffer.readUshort(this.codeOffset + 6);
    }

    @Override
    public final List getTryBlocks() {
        int n = this.getTriesSize();
        if (n > 0) {
            int n2 = this.getInstructionsStartOffset();
            n2 = this.getInstructionsSize() * 2 + n2 + 3 & 0xFFFFFFFC;
            int n3 = n * 8 + n2;
            return new DexBackedMethodImplementation$2(this, n2, n3, n);
        }
        return Collections.emptyList();
    }

    public int getDebugOffset() {
        return this.dexFile.dataBuffer.readInt(this.codeOffset + 8);
    }

    @Override
    public final Iterable getDebugItems() {
        return this.getDebugInfo();
    }

    public final DebugInfo getDebugInfo() {
        int n = ((DexBackedMethodImplementation)object).getDebugOffset();
        if (n != -1 && n != 0) {
            Object object;
            if (n < 0) {
                object = ((DexBackedMethodImplementation)object).method;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(object);
                stringBuilder.append(": Invalid debug offset");
                System.err.println(stringBuilder.toString());
                return DebugInfo$EmptyDebugInfo.INSTANCE;
            }
            DexBackedDexFile dexBackedDexFile = ((DexBackedMethodImplementation)object).dexFile;
            if (((DexBackedMethodImplementation)object).dexFile.getBaseDataOffset() + n >= dexBackedDexFile.dexBuffer.buf.length) {
                object = ((DexBackedMethodImplementation)object).method;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(object);
                stringBuilder.append(": Invalid debug offset");
                System.err.println(stringBuilder.toString());
                return DebugInfo$EmptyDebugInfo.INSTANCE;
            }
            if (n == 0) {
                object = DebugInfo$EmptyDebugInfo.INSTANCE;
            } else {
                DebugInfo$DebugInfoImpl debugInfo$DebugInfoImpl;
                DebugInfo$DebugInfoImpl debugInfo$DebugInfoImpl2 = debugInfo$DebugInfoImpl;
                debugInfo$DebugInfoImpl = new DebugInfo$DebugInfoImpl(dexBackedDexFile, n, (DexBackedMethodImplementation)object);
                object = debugInfo$DebugInfoImpl2;
            }
            return object;
        }
        return DebugInfo$EmptyDebugInfo.INSTANCE;
    }
}

