/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.CoreUserSettings;
import ca.sqlpower.architect.UserSettings;
import ca.sqlpower.architect.enterprise.ArchitectClientSideSession;
import ca.sqlpower.architect.layout.ArchitectLayout;
import ca.sqlpower.architect.layout.FruchtermanReingoldForceLayout;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectStatusBar;
import ca.sqlpower.architect.swingui.ArchitectSwingProject;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContext;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionImpl;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.DefaultColumnUserSettings;
import ca.sqlpower.architect.swingui.ExceptionHandler;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.Navigator;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.action.AboutAction;
import ca.sqlpower.architect.swingui.action.AlignTableAction;
import ca.sqlpower.architect.swingui.action.AutoLayoutAction;
import ca.sqlpower.architect.swingui.action.CheckForUpdateAction;
import ca.sqlpower.architect.swingui.action.CloseProjectAction;
import ca.sqlpower.architect.swingui.action.CompareDMAction;
import ca.sqlpower.architect.swingui.action.CopySelectedAction;
import ca.sqlpower.architect.swingui.action.CreateRelationshipAction;
import ca.sqlpower.architect.swingui.action.CreateTableAction;
import ca.sqlpower.architect.swingui.action.CutSelectedAction;
import ca.sqlpower.architect.swingui.action.DataMoverAction;
import ca.sqlpower.architect.swingui.action.DataSourcePropertiesAction;
import ca.sqlpower.architect.swingui.action.DatabaseConnectionManagerAction;
import ca.sqlpower.architect.swingui.action.DeleteSelectedAction;
import ca.sqlpower.architect.swingui.action.EditColumnAction;
import ca.sqlpower.architect.swingui.action.EditCriticSettingsAction;
import ca.sqlpower.architect.swingui.action.EditLabelAction;
import ca.sqlpower.architect.swingui.action.EditRelationshipAction;
import ca.sqlpower.architect.swingui.action.EditSelectedAction;
import ca.sqlpower.architect.swingui.action.EditSelectedIndexAction;
import ca.sqlpower.architect.swingui.action.EditTableAction;
import ca.sqlpower.architect.swingui.action.ExportCSVAction;
import ca.sqlpower.architect.swingui.action.ExportDDLAction;
import ca.sqlpower.architect.swingui.action.ExportHTMLReportAction;
import ca.sqlpower.architect.swingui.action.ExportPlaypenToPDFAction;
import ca.sqlpower.architect.swingui.action.FocusToChildOrParentTableAction;
import ca.sqlpower.architect.swingui.action.InsertColumnAction;
import ca.sqlpower.architect.swingui.action.InsertIndexAction;
import ca.sqlpower.architect.swingui.action.InvadersAction;
import ca.sqlpower.architect.swingui.action.KettleJobAction;
import ca.sqlpower.architect.swingui.action.OpenProjectAction;
import ca.sqlpower.architect.swingui.action.PasteSelectedAction;
import ca.sqlpower.architect.swingui.action.PreferencesAction;
import ca.sqlpower.architect.swingui.action.PrintAction;
import ca.sqlpower.architect.swingui.action.ProfileAction;
import ca.sqlpower.architect.swingui.action.ProjectSettingsAction;
import ca.sqlpower.architect.swingui.action.RedoAction;
import ca.sqlpower.architect.swingui.action.RemoveSourceDBAction;
import ca.sqlpower.architect.swingui.action.ReverseRelationshipAction;
import ca.sqlpower.architect.swingui.action.SQLQueryAction;
import ca.sqlpower.architect.swingui.action.SearchReplaceAction;
import ca.sqlpower.architect.swingui.action.SelectAllAction;
import ca.sqlpower.architect.swingui.action.UndoAction;
import ca.sqlpower.architect.swingui.action.VisualMappingReportAction;
import ca.sqlpower.architect.swingui.action.ZoomAction;
import ca.sqlpower.architect.swingui.action.ZoomResetAction;
import ca.sqlpower.architect.swingui.action.ZoomToFitAction;
import ca.sqlpower.architect.swingui.action.enterprise.RefreshProjectAction;
import ca.sqlpower.architect.swingui.enterprise.ArchitectServerProjectsManagerPanel;
import ca.sqlpower.architect.swingui.enterprise.ProjectSecurityPanel;
import ca.sqlpower.architect.swingui.enterprise.RevisionListPanel;
import ca.sqlpower.architect.swingui.enterprise.SecurityPanel;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.architect.swingui.olap.action.ImportSchemaAction;
import ca.sqlpower.architect.swingui.olap.action.OLAPEditAction;
import ca.sqlpower.architect.swingui.olap.action.OLAPSchemaManagerAction;
import ca.sqlpower.enterprise.client.ConnectionTestAction;
import ca.sqlpower.enterprise.client.ProjectLocation;
import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.RecentMenu;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.StackedTabComponent;
import ca.sqlpower.swingui.SwingUIUserPrompterFactory;
import ca.sqlpower.swingui.action.OpenUrlAction;
import ca.sqlpower.swingui.enterprise.client.SPServerInfoManagerPanel;
import ca.sqlpower.swingui.event.SessionLifecycleEvent;
import ca.sqlpower.swingui.event.SessionLifecycleListener;
import ca.sqlpower.util.BrowserUtil;
import ca.sqlpower.util.UserPrompterFactory;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ArchitectFrame
extends JFrame {
    private static final String CYCLE_TAB_ACTION = "ca.sqlpower.architect.swingui.CYCLE_TAB_ACTION";
    private static Logger logger = Logger.getLogger(ArchitectFrame.class);
    private static final ImageIcon GROUP_ICON = new ImageIcon(ArchitectFrame.class.getResource("enterprise/icons/group.png"));
    public static final double ZOOM_STEP = 0.25;
    private ArchitectSwingSessionContext context;
    private ArchitectSwingSession currentSession = null;
    private List<ArchitectSwingSession> sessions = new ArrayList<ArchitectSwingSession>();
    private JToolBar projectBar = null;
    private JToolBar ppBar = null;
    private JMenuBar menuBar = null;
    private JSplitPane splitPane = null;
    private StackedTabComponent stackedTabPane = new StackedTabComponent();
    private BiMap<ArchitectSwingSession, StackedTabComponent.StackedTab> sessionTabs = HashBiMap.create();
    private Navigator navigatorDialog;
    private int oldWidth;
    private int oldHeight;
    private int prefWidth;
    private int prefHeight;
    private final UserPrompterFactory nonModalUserPrompterFactory;
    private final DropTargetListener tabDropTargetListener = new TabDropTargetListener();
    private JMenu connectionsMenu;
    private ArchitectLayout autoLayout;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private AboutAction aboutAction;
    private Action newProjectAction;
    private Action newWindowAction;
    private OpenProjectAction openProjectAction;
    private Action saveProjectAction;
    private Action saveProjectAsAction;
    private Action saveAllProjectsAction;
    private CloseProjectAction closeProjectAction;
    private PreferencesAction prefAction;
    private ProjectSettingsAction projectSettingsAction;
    private PrintAction printAction;
    private ExportPlaypenToPDFAction exportPlaypenToPDFAction;
    private ProfileAction profileAction;
    private ZoomAction zoomInAction;
    private ZoomAction zoomOutAction;
    private ZoomResetAction zoomNormalAction;
    private ZoomToFitAction zoomToFitAction;
    private AutoLayoutAction autoLayoutAction;
    private EditSelectedAction editSelectedAction;
    private EditColumnAction editColumnAction;
    private InsertColumnAction insertColumnAction;
    private InsertIndexAction insertIndexAction;
    private EditTableAction editTableAction;
    private EditSelectedIndexAction editIndexAction;
    private DeleteSelectedAction deleteSelectedAction;
    private CreateTableAction createTableAction;
    private CreateRelationshipAction createIdentifyingRelationshipAction;
    private CreateRelationshipAction createNonIdentifyingRelationshipAction;
    private EditRelationshipAction editRelationshipAction;
    private SearchReplaceAction searchReplaceAction;
    private SelectAllAction selectAllAction;
    private ReverseRelationshipAction reverseRelationshipAction;
    private AlignTableAction alignTableHorizontalAction;
    private AlignTableAction alignTableVerticalAction;
    private FocusToChildOrParentTableAction focusToChildAction;
    private FocusToChildOrParentTableAction focusToParentAction;
    private Action exportDDLAction;
    private Action compareDMAction;
    private Action dataMoverAction;
    private Action sqlQueryAction;
    private CopySelectedAction copyAction;
    private CutSelectedAction cutAction;
    private PasteSelectedAction pasteAction;
    private final ArchitectStatusBar statusBar = new ArchitectStatusBar();
    private RefreshProjectAction refreshProjectAction;
    private List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private final EditCriticSettingsAction showCriticsManagerAction = new EditCriticSettingsAction(this);
    private Action exitAction = new AbstractAction(Messages.getString("ArchitectFrame.exitActionName")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArchitectFrame.this.context.closeAll();
        }
    };
    private final Action enterpriseLinkAction = new AbstractAction("Get Enterprise..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                BrowserUtil.launch((String)"http://www.sqlpower.ca/page/architect-e");
            }
            catch (IOException ex) {
                ASUtils.showExceptionDialog(ArchitectFrame.this.currentSession, "Unable to open link: http://www.sqlpower.ca/page/architect-e", ex);
            }
        }
    };
    private final Action openServerManagerAction = new AbstractAction("Configure Server Connections..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            final JDialog d = SPSUtils.makeOwnedDialog((Component)ArchitectFrame.this, (String)"Server Connections");
            AbstractAction closeAction = new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d.dispose();
                }
            };
            final SPServerInfoManagerPanel sim = new SPServerInfoManagerPanel(ArchitectFrame.this.context.getServerManager(), (Component)ArchitectFrame.this, (Action)closeAction);
            sim.setLoginAction((Action)new AbstractAction("Login"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SPServerInfo si = sim.getSelectedServer();
                    if (si != null) {
                        final JDialog dialog = SPSUtils.makeOwnedDialog((Component)ArchitectFrame.this, (String)"Projects");
                        AbstractAction closeAction = new AbstractAction("Close"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                dialog.dispose();
                            }
                        };
                        ArchitectServerProjectsManagerPanel spm = new ArchitectServerProjectsManagerPanel(si, ArchitectFrame.this.currentSession, ArchitectFrame.this.context, closeAction);
                        if (spm.isConnected()) {
                            dialog.setDefaultCloseOperation(2);
                            dialog.setContentPane(spm.getPanel());
                            SPSUtils.makeJDialogCancellable((Window)dialog, null);
                            dialog.pack();
                            dialog.setLocationRelativeTo(ArchitectFrame.this);
                            dialog.setVisible(true);
                        }
                    } else {
                        JOptionPane.showMessageDialog(ArchitectFrame.this, "Please select a server", "", 1);
                    }
                }
            });
            sim.setTestAction(new ConnectionTestAction("Test Server"){

                public void actionPerformed(ActionEvent e) {
                    String msg = "Unable to connect to server";
                    try {
                        ArchitectClientSideSession.getCookieStore().clear();
                        List<ProjectLocation> l = ArchitectClientSideSession.getWorkspaceNames(this.findPanel((JButton)e.getSource()).getServerInfo(), (UserPrompterFactory)new SwingUIUserPrompterFactory((JFrame)ArchitectFrame.this));
                        if (l != null) {
                            msg = "Successfully connected to server";
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(ArchitectFrame.this, msg);
                }
            });
            d.setDefaultCloseOperation(2);
            d.setContentPane(sim.getPanel());
            SPSUtils.makeJDialogCancellable((Window)d, null);
            d.pack();
            d.setLocationRelativeTo(ArchitectFrame.this);
            d.setVisible(true);
        }
    };
    private Action openProjectManagerAction = new AbstractAction("Projects..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            final JDialog d = SPSUtils.makeOwnedDialog((Component)ArchitectFrame.this, (String)"Projects");
            AbstractAction closeAction = new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d.dispose();
                }
            };
            ArchitectServerProjectsManagerPanel spm = new ArchitectServerProjectsManagerPanel(ArchitectFrame.this.currentSession, ArchitectFrame.this.context, closeAction);
            d.setDefaultCloseOperation(2);
            d.setContentPane(spm.getPanel());
            SPSUtils.makeJDialogCancellable((Window)d, null);
            d.pack();
            d.setLocationRelativeTo(ArchitectFrame.this);
            d.setVisible(true);
        }
    };
    private Action openSecurityManagerPanelAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            final JDialog d = SPSUtils.makeOwnedDialog((Component)ArchitectFrame.this, (String)"Security Manager");
            AbstractAction closeAction = new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d.dispose();
                }
            };
            ((ArchitectClientSideSession)((ArchitectSwingSessionImpl)ArchitectFrame.this.currentSession).getDelegateSession()).getSystemSession().getUpdater().setUserPrompterFactory(ArchitectFrame.this.nonModalUserPrompterFactory);
            SecurityPanel spm = new SecurityPanel(((ArchitectClientSideSession)((ArchitectSwingSessionImpl)ArchitectFrame.this.currentSession).getDelegateSession()).getProjectLocation().getServiceInfo(), closeAction, d, ArchitectFrame.this.currentSession);
            d.setDefaultCloseOperation(2);
            d.setContentPane(spm.getPanel());
            SPSUtils.makeJDialogCancellable((Window)d, null);
            d.pack();
            d.setLocationRelativeTo(ArchitectFrame.this);
            d.setVisible(true);
        }
    };
    private Action openProjectSecurityPanelAction = new AbstractAction("Project Security Settings..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            final JDialog d = SPSUtils.makeOwnedDialog((Component)ArchitectFrame.this, (String)"Project Security Settings");
            AbstractAction closeAction = new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d.dispose();
                }
            };
            ((ArchitectClientSideSession)((ArchitectSwingSessionImpl)ArchitectFrame.this.currentSession).getDelegateSession()).getSystemSession().getUpdater().setUserPrompterFactory(ArchitectFrame.this.nonModalUserPrompterFactory);
            ProjectSecurityPanel spm = new ProjectSecurityPanel(((ArchitectClientSideSession)((ArchitectSwingSessionImpl)ArchitectFrame.this.currentSession).getDelegateSession()).getSystemWorkspace(), (SPObject)ArchitectFrame.this.currentSession.getWorkspace(), ArchitectSwingProject.class, ((ArchitectClientSideSession)((ArchitectSwingSessionImpl)ArchitectFrame.this.currentSession).getDelegateSession()).getProjectLocation().getServiceInfo().getUsername(), d, closeAction);
            d.setDefaultCloseOperation(2);
            d.setContentPane(spm.getPanel());
            SPSUtils.makeJDialogCancellable((Window)d, null);
            d.pack();
            d.setLocationRelativeTo(ArchitectFrame.this);
            d.setVisible(true);
        }
    };
    private Action openRevisionListAction = new AbstractAction("Revisions..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            final JDialog d = SPSUtils.makeOwnedDialog((Component)ArchitectFrame.this, (String)"Revision List");
            AbstractAction closeAction = new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d.dispose();
                }
            };
            RevisionListPanel p = new RevisionListPanel(ArchitectFrame.this.currentSession, ArchitectFrame.this, closeAction);
            d.setDefaultCloseOperation(2);
            d.setContentPane(p.getPanel());
            SPSUtils.makeJDialogCancellable((Window)d, null);
            d.pack();
            d.setLocationRelativeTo(ArchitectFrame.this);
            d.setVisible(true);
        }
    };
    private JMenu securityMenu;
    private ChangeListener tabChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ArchitectFrame.this.currentSession != ArchitectFrame.this.sessionTabs.inverse().get((Object)ArchitectFrame.this.stackedTabPane.getSelectedTab())) {
                ArchitectFrame.this.setCurrentSession((ArchitectSwingSession)ArchitectFrame.this.sessionTabs.inverse().get((Object)ArchitectFrame.this.stackedTabPane.getSelectedTab()));
            }
        }
    };
    private List<PlayPen.CancelableListener> cancelableListeners = new ArrayList<PlayPen.CancelableListener>();
    private ArrayList<FocusListener> focusListeners = new ArrayList();
    private JButton newProjectButton;
    private JMenuItem newProjectMenu;
    private JMenuItem newWindowMenu;
    private AbstractAction cycleTabAction;
    private JMenuItem enterpriseLinkButton;
    private JButton saveProjectButton;
    private JMenuItem saveProjectMenu;
    private JMenuItem saveProjectAsMenu;
    private JMenuItem saveAllProjectsMenu;
    private EditLabelAction editLabelAction;
    private JMenu enterpriseMenu;
    private CheckForUpdateAction checkForUpdateAction;

    public ArchitectFrame(ArchitectSwingSessionContext context, Rectangle bounds) {
        this.context = context;
        this.setTitle("SQL Power Architect");
        this.setIconImage(ASUtils.getFrameIconImage());
        this.setDefaultCloseOperation(0);
        this.stackedTabPane.addChangeListener(this.tabChangeListener);
        this.stackedTabPane.setDropTarget(new DropTarget((Component)this.stackedTabPane, this.tabDropTargetListener));
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent((Component)this.stackedTabPane);
        Preferences prefs = context.getPrefs();
        this.splitPane.setDividerLocation(prefs.getInt("SwingUserSettings.DIVIDER_LOCATION", 200));
        this.splitPane.setOneTouchExpandable(true);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        if (bounds == null) {
            bounds = new Rectangle();
            bounds.x = prefs.getInt("SwingUserSettings.MAIN_FRAME_X", 40);
            bounds.y = prefs.getInt("SwingUserSettings.MAIN_FRAME_Y", 40);
        }
        bounds.width = prefs.getInt("SwingUserSettings.MAIN_FRAME_WIDTH", (int)((double)dim.width * 0.8));
        bounds.height = prefs.getInt("SwingUserSettings.MAIN_FRAME_HEIGHT", (int)((double)dim.height * 0.8));
        this.prefWidth = bounds.width;
        this.prefHeight = bounds.height;
        this.oldWidth = this.prefWidth;
        this.oldHeight = this.prefHeight;
        this.setBounds(bounds);
        this.setPreferredSize(new Dimension(bounds.width, bounds.height));
        this.addWindowListener(new ArchitectFrameWindowListener());
        context.getUserSettings().getSwingSettings().setBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", prefs.getBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", true));
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ArchitectFrame.this.oldWidth = ArchitectFrame.this.prefWidth;
                ArchitectFrame.this.oldHeight = ArchitectFrame.this.prefHeight;
                ArchitectFrame.this.prefWidth = ArchitectFrame.this.getWidth();
                ArchitectFrame.this.prefHeight = ArchitectFrame.this.getHeight();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (e.getNewState() == 6) {
                    ArchitectFrame.this.prefWidth = ArchitectFrame.this.oldWidth;
                    ArchitectFrame.this.prefHeight = ArchitectFrame.this.oldHeight;
                }
            }
        });
        this.nonModalUserPrompterFactory = new SwingUIUserPrompterFactory.NonModalSwingUIUserPrompterFactory((JFrame)this);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                ArchitectClientSideSession.getCookieStore().clear();
            }
        });
    }

    public void init(ArchitectSwingSession session) {
        this.init(session, true);
    }

    public void init(ArchitectSwingSession session, boolean showGUI) {
        if (!this.context.equals(session.getContext())) {
            throw new IllegalArgumentException("Session must be in the same context as this frame");
        }
        this.currentSession = session;
        UserSettings sprefs = this.context.getUserSettings().getSwingSettings();
        DefaultColumnUserSettings.setColumnDefaults();
        int accelMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.aboutAction = new AboutAction(this);
        this.newProjectAction = new AbstractAction(Messages.getString("ArchitectFrame.newProjectActionName"), SPSUtils.createIcon((String)"new_project", (String)Messages.getString("ArchitectFrame.newProjectActionIconDescription"), (int)sprefs.getInt("SwingUserSettings.ICON_SIZE", 16))){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArchitectSwingSession newSession = ArchitectFrame.this.context.createSession();
                    ArchitectFrame.this.addSession(newSession);
                    ArchitectFrame.this.setCurrentSession(newSession);
                }
                catch (Exception ex) {
                    ASUtils.showExceptionDialog(ArchitectFrame.this.currentSession, Messages.getString("ArchitectFrame.projectCreationFailed"), ex);
                    logger.error((Object)"Got exception while creating new project", (Throwable)ex);
                }
            }
        };
        this.newProjectAction.putValue("ShortDescription", Messages.getString("ArchitectFrame.newProjectActionDescription"));
        this.newProjectAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, accelMask));
        this.newWindowAction = new AbstractAction("New Window", SPSUtils.createIcon((String)"new_window", (String)"New Window", (int)sprefs.getInt("SwingUserSettings.ICON_SIZE", 16))){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArchitectSwingSession newSession = ArchitectFrame.this.context.createSession();
                    Rectangle bounds = new Rectangle(ArchitectFrame.this.getBounds());
                    bounds.translate(20, 20);
                    ArchitectFrame newFrame = new ArchitectFrame(ArchitectFrame.this.context, bounds);
                    newFrame.init(newSession);
                    if ((e.getModifiers() & 8) != 0) {
                        JMenuBar mb = newFrame.menuBar;
                        for (int i = 0; i < mb.getMenuCount(); ++i) {
                            if (!"TOOLS_MENU".equals(mb.getMenu(i).getName())) continue;
                            mb.getMenu(i).add(new InvadersAction(newFrame));
                        }
                    }
                }
                catch (Exception ex) {
                    ASUtils.showExceptionDialog(ArchitectFrame.this.currentSession, Messages.getString("ArchitectFrame.projectCreationFailed"), ex);
                    logger.error((Object)"Got exception while creating new project", (Throwable)ex);
                }
            }
        };
        this.newWindowAction.putValue("ShortDescription", "New Window");
        this.newWindowAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, accelMask + 1));
        this.openProjectAction = new OpenProjectAction(this);
        this.saveProjectAction = new AbstractAction(Messages.getString("ArchitectFrame.saveProjectActionName"), SPSUtils.createIcon((String)"disk", (String)Messages.getString("ArchitectFrame.saveProjectActionIconDescription"), (int)sprefs.getInt("SwingUserSettings.ICON_SIZE", 16))){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArchitectFrame.this.currentSession.saveOrSaveAs(false, true);
                ArchitectFrame.this.stackedTabPane.setTitleAt(ArchitectFrame.this.stackedTabPane.getSelectedIndex(), ArchitectFrame.this.currentSession.getName());
                ArchitectFrame.this.setTitle(Messages.getString("ArchitectSwingSessionImpl.mainFrameTitle", ArchitectFrame.this.currentSession.getName()));
            }
        };
        this.saveProjectAction.putValue("ShortDescription", Messages.getString("ArchitectFrame.saveProjectActionDescription"));
        this.saveProjectAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, accelMask));
        this.saveProjectAsAction = new AbstractAction(Messages.getString("ArchitectFrame.saveProjectAsActionName"), SPSUtils.createIcon((String)"disk", (String)Messages.getString("ArchitectFrame.saveProjectAsActionIconDescription"), (int)sprefs.getInt("SwingUserSettings.ICON_SIZE", 16))){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArchitectFrame.this.currentSession.saveOrSaveAs(true, true);
                ArchitectFrame.this.stackedTabPane.setTitleAt(ArchitectFrame.this.stackedTabPane.getSelectedIndex(), ArchitectFrame.this.currentSession.getName());
                ArchitectFrame.this.setTitle(Messages.getString("ArchitectSwingSessionImpl.mainFrameTitle", ArchitectFrame.this.currentSession.getName()));
            }
        };
        this.saveProjectAsAction.putValue("ShortDescription", Messages.getString("ArchitectFrame.saveProjectAsActionDescription"));
        this.saveAllProjectsAction = new AbstractAction("Save All Projects", SPSUtils.createIcon((String)"save_all", (String)"Save All Projects", (int)sprefs.getInt("SwingUserSettings.ICON_SIZE", 16))){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ArchitectSwingSession session : ArchitectFrame.this.sessions) {
                    session.saveOrSaveAs(false, true);
                    ArchitectFrame.this.stackedTabPane.setTitleAt(ArchitectFrame.this.stackedTabPane.indexOfTab((StackedTabComponent.StackedTab)ArchitectFrame.this.sessionTabs.get((Object)session)), session.getName());
                }
                ArchitectFrame.this.setTitle(Messages.getString("ArchitectSwingSessionImpl.mainFrameTitle", ArchitectFrame.this.currentSession.getName()));
            }
        };
        this.saveAllProjectsAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, accelMask + 1));
        this.closeProjectAction = new CloseProjectAction(this);
        this.cycleTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ArchitectFrame.this.stackedTabPane.getSelectedIndex();
                int max = ArchitectFrame.this.stackedTabPane.getTabCount();
                index = (e.getModifiers() & 1) == 0 ? ++index : --index;
                index = (index + max) % max;
                ArchitectFrame.this.stackedTabPane.setSelectedIndex(index);
            }
        };
        this.cycleTabAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 2));
        this.prefAction = new PreferencesAction(this);
        this.projectSettingsAction = new ProjectSettingsAction(this);
        this.printAction = new PrintAction(this);
        this.printAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, accelMask));
        this.exportPlaypenToPDFAction = new ExportPlaypenToPDFAction(this);
        this.zoomInAction = new ZoomAction(this, 0.25);
        this.zoomOutAction = new ZoomAction(this, -0.25);
        this.zoomNormalAction = new ZoomResetAction(this);
        this.zoomToFitAction = new ZoomToFitAction(this);
        this.zoomToFitAction.putValue("ShortDescription", Messages.getString("ArchitectFrame.zoomToFitActionDescription"));
        this.undoAction = new UndoAction(this.currentSession, this, this.currentSession.getUndoManager());
        this.redoAction = new RedoAction(this.currentSession, this, this.currentSession.getUndoManager());
        this.autoLayoutAction = new AutoLayoutAction(this, Messages.getString("ArchitectFrame.autoLayoutActionName"), Messages.getString("ArchitectFrame.autoLayoutActionDescription"), "auto_layout");
        this.autoLayout = new FruchtermanReingoldForceLayout();
        this.autoLayoutAction.setLayout(this.autoLayout);
        this.exportDDLAction = new ExportDDLAction(this);
        this.compareDMAction = new CompareDMAction(this);
        this.dataMoverAction = new DataMoverAction(this);
        this.sqlQueryAction = new SQLQueryAction(this);
        this.deleteSelectedAction = new DeleteSelectedAction(this);
        this.createIdentifyingRelationshipAction = new CreateRelationshipAction(this, true);
        this.createNonIdentifyingRelationshipAction = new CreateRelationshipAction(this, false);
        this.editRelationshipAction = new EditRelationshipAction(this);
        this.createTableAction = new CreateTableAction(this);
        this.editColumnAction = new EditColumnAction(this);
        this.editSelectedAction = new EditSelectedAction(this);
        this.insertColumnAction = new InsertColumnAction(this);
        this.insertIndexAction = new InsertIndexAction(this);
        this.editLabelAction = new EditLabelAction(this);
        this.editTableAction = new EditTableAction(this);
        this.editIndexAction = new EditSelectedIndexAction(this);
        this.searchReplaceAction = new SearchReplaceAction(this);
        this.searchReplaceAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, accelMask));
        this.selectAllAction = new SelectAllAction(this);
        this.selectAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, accelMask));
        this.profileAction = new ProfileAction(this);
        this.reverseRelationshipAction = new ReverseRelationshipAction(this);
        this.alignTableHorizontalAction = new AlignTableAction(this, Messages.getString("ArchitectFrame.alignTablesHorizontallyActionName"), Messages.getString("ArchitectFrame.alignTablesHorizontallyActionDescription"), true);
        this.alignTableVerticalAction = new AlignTableAction(this, Messages.getString("ArchitectFrame.alignTablesVerticallyActionName"), Messages.getString("ArchitectFrame.alignTablesVerticallyActionDescription"), false);
        this.focusToParentAction = new FocusToChildOrParentTableAction(this, Messages.getString("ArchitectFrame.setFocusToParentTableActionName"), Messages.getString("ArchitectFrame.setFocusToParentTableActionDescription"), true);
        this.focusToChildAction = new FocusToChildOrParentTableAction(this, Messages.getString("ArchitectFrame.setFocusToChildTableActionName"), Messages.getString("ArchitectFrame.setFocusToChildTableActionDescription"), false);
        this.copyAction = new CopySelectedAction(this);
        this.cutAction = new CutSelectedAction(this);
        this.pasteAction = new PasteSelectedAction(this);
        this.refreshProjectAction = new RefreshProjectAction(this);
        this.addSession(session);
        this.menuBar = this.createNewMenuBar();
        this.setJMenuBar(this.menuBar);
        this.projectBar = new JToolBar(0);
        this.ppBar = new JToolBar(1);
        this.newProjectButton = this.projectBar.add(this.newProjectAction);
        this.projectBar.add(this.openProjectAction);
        this.saveProjectButton = this.projectBar.add(this.saveProjectAction);
        this.projectBar.addSeparator();
        this.projectBar.add(this.refreshProjectAction);
        this.projectBar.addSeparator();
        this.projectBar.add(this.printAction);
        this.projectBar.addSeparator();
        this.projectBar.add(this.undoAction);
        this.projectBar.add(this.redoAction);
        this.projectBar.addSeparator();
        this.projectBar.add(this.exportDDLAction);
        this.projectBar.add(this.compareDMAction);
        this.projectBar.addSeparator();
        this.projectBar.add(this.autoLayoutAction);
        this.projectBar.add(this.profileAction);
        this.projectBar.setToolTipText(Messages.getString("ArchitectFrame.projectToolbarToolTip"));
        this.projectBar.setName(Messages.getString("ArchitectFrame.projectToolbarName"));
        this.projectBar.setFocusable(false);
        for (Component c : this.projectBar.getComponents()) {
            c.setFocusable(false);
        }
        JButton tempButton = null;
        this.ppBar.setToolTipText(Messages.getString("ArchitectFrame.playPenToolbarToolTip"));
        this.ppBar.setName(Messages.getString("ArchitectFrame.playPenToolbarName"));
        this.ppBar.add(this.zoomInAction);
        this.ppBar.add(this.zoomOutAction);
        this.ppBar.add(this.zoomNormalAction);
        this.ppBar.add(this.zoomToFitAction);
        this.ppBar.addSeparator();
        tempButton = this.ppBar.add(this.deleteSelectedAction);
        tempButton.setActionCommand("PlayPen");
        this.ppBar.addSeparator();
        tempButton = this.ppBar.add(this.createTableAction);
        tempButton.setActionCommand("PlayPen");
        this.ppBar.addSeparator();
        tempButton = this.ppBar.add(this.insertIndexAction);
        tempButton.setActionCommand("PlayPen");
        this.ppBar.addSeparator();
        tempButton = this.ppBar.add(this.insertColumnAction);
        tempButton.setActionCommand("PlayPen");
        tempButton = this.ppBar.add(this.editSelectedAction);
        tempButton.setActionCommand("PlayPen");
        this.ppBar.addSeparator();
        this.ppBar.add(this.createNonIdentifyingRelationshipAction);
        this.ppBar.add(this.createIdentifyingRelationshipAction);
        tempButton = this.ppBar.add(this.editRelationshipAction);
        tempButton.setActionCommand("PlayPen");
        this.ppBar.setFocusable(false);
        for (Component c : this.ppBar.getComponents()) {
            c.setFocusable(false);
        }
        Container projectBarPane = this.getContentPane();
        projectBarPane.setLayout(new BorderLayout());
        projectBarPane.add((Component)this.projectBar, "North");
        JPanel cp = new JPanel(new BorderLayout());
        cp.add((Component)this.ppBar, "East");
        projectBarPane.add((Component)cp, "Center");
        this.splitPane.setRightComponent(session.getProjectPanel());
        cp.add((Component)this.splitPane, "Center");
        logger.debug((Object)"Added splitpane to content pane");
        projectBarPane.add((Component)this.statusBar.getStatusBar(), "South");
        this.stackedTabPane.setSelectedIndex(0);
        this.context.registerFrame(this);
        this.setTitle(Messages.getString("ArchitectSwingSessionImpl.mainFrameTitle", session.getName()));
        this.setVisible(showGUI);
    }

    public JMenuBar createNewMenuBar() {
        this.checkForUpdateAction = new CheckForUpdateAction(this);
        ExportCSVAction exportCSVAction = new ExportCSVAction(this);
        VisualMappingReportAction mappingReportAction = new VisualMappingReportAction(this);
        KettleJobAction kettleETL = new KettleJobAction(this);
        ExportHTMLReportAction exportHTMLReportAction = new ExportHTMLReportAction(this);
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Messages.getString("ArchitectFrame.fileMenu"));
        fileMenu.setMnemonic('f');
        this.newProjectMenu = fileMenu.add(this.newProjectAction);
        this.newWindowMenu = fileMenu.add(this.newWindowAction);
        fileMenu.add(this.openProjectAction);
        fileMenu.add((JMenuItem)new RecentMenu(this.getClass()){

            public void loadFile(String fileName) throws IOException {
                File f = new File(fileName);
                try {
                    OpenProjectAction.getFileLoader().open(ArchitectFrame.this.context.createSession(), f, ArchitectFrame.this.currentSession, false);
                }
                catch (SQLObjectException ex) {
                    SPSUtils.showExceptionDialogNoReport((Component)ArchitectFrame.this, (String)Messages.getString("ArchitectSwingSessionImpl.openProjectFileFailed"), (Throwable)ex);
                }
            }
        });
        fileMenu.add(this.closeProjectAction);
        fileMenu.addSeparator();
        this.saveProjectMenu = fileMenu.add(this.saveProjectAction);
        this.saveProjectAsMenu = fileMenu.add(this.saveProjectAsAction);
        this.saveAllProjectsMenu = fileMenu.add(this.saveAllProjectsAction);
        fileMenu.add(this.printAction);
        fileMenu.add(this.exportPlaypenToPDFAction);
        fileMenu.add(exportHTMLReportAction);
        fileMenu.addSeparator();
        if (!this.context.isMacOSX()) {
            fileMenu.add(this.prefAction);
        }
        fileMenu.add(this.projectSettingsAction);
        if (!this.context.isMacOSX()) {
            fileMenu.addSeparator();
            fileMenu.add(this.exitAction);
        }
        this.menuBar.add(fileMenu);
        JMenu editMenu = new JMenu(Messages.getString("ArchitectFrame.editMenu"));
        editMenu.setMnemonic('e');
        editMenu.add(this.cutAction);
        editMenu.add(this.copyAction);
        editMenu.add(this.pasteAction);
        editMenu.addSeparator();
        editMenu.add(this.undoAction);
        editMenu.add(this.redoAction);
        editMenu.addSeparator();
        editMenu.add(this.selectAllAction);
        editMenu.addSeparator();
        editMenu.add(this.searchReplaceAction);
        this.menuBar.add(editMenu);
        this.connectionsMenu = new JMenu(Messages.getString("ArchitectFrame.connectionsMenu"));
        this.connectionsMenu.setMnemonic('c');
        this.menuBar.add(this.connectionsMenu);
        this.connectionsMenu.removeAll();
        final JMenu dbcsMenu = this.currentSession.createDataSourcesMenu();
        final JMenuItem propertiesMenu = new JMenuItem(new DataSourcePropertiesAction(this));
        final JMenuItem removeDBCSMenu = new JMenuItem(new RemoveSourceDBAction(this));
        this.connectionsMenu.add(dbcsMenu);
        this.connectionsMenu.add(propertiesMenu);
        this.connectionsMenu.add(removeDBCSMenu);
        this.connectionsMenu.addSeparator();
        this.connectionsMenu.add(new DatabaseConnectionManagerAction(this));
        this.connectionsMenu.addMenuListener(new MenuListener(){
            private JMenu dbcs;
            {
                this.dbcs = dbcsMenu;
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                ArchitectFrame.this.connectionsMenu.remove(this.dbcs);
                this.dbcs = ArchitectFrame.this.currentSession.createDataSourcesMenu();
                ArchitectFrame.this.connectionsMenu.add((Component)this.dbcs, 0);
                DBTree tree = ArchitectFrame.this.currentSession.getDBTree();
                TreePath tp = ArchitectFrame.this.currentSession.getDBTree().getSelectionPath();
                if (tp != null) {
                    boolean dbcsSelected = !tree.isTargetDatabaseNode(tp) && !tree.isTargetDatabaseChild(tp);
                    propertiesMenu.setEnabled(dbcsSelected);
                    removeDBCSMenu.setEnabled(dbcsSelected && tp.getLastPathComponent() instanceof SQLDatabase);
                } else {
                    propertiesMenu.setEnabled(false);
                    removeDBCSMenu.setEnabled(false);
                }
            }
        });
        JMenu etlMenu = new JMenu(Messages.getString("ArchitectFrame.etlMenu"));
        etlMenu.setMnemonic('l');
        etlMenu.add(exportCSVAction);
        etlMenu.add(mappingReportAction);
        etlMenu.add(kettleETL);
        this.menuBar.add(etlMenu);
        final JMenu olapMenu = new JMenu(Messages.getString("ArchitectFrame.olapMenu"));
        olapMenu.setMnemonic('o');
        final JMenu olapEditMenu = this.buildOLAPEditMenu();
        olapMenu.add(olapEditMenu);
        olapMenu.add(new ImportSchemaAction(this));
        olapMenu.addSeparator();
        olapMenu.add(new OLAPSchemaManagerAction(this));
        olapMenu.addMenuListener(new MenuListener(){
            private JMenu editMenu;
            {
                this.editMenu = olapEditMenu;
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                olapMenu.remove(this.editMenu);
                this.editMenu = ArchitectFrame.this.buildOLAPEditMenu();
                olapMenu.add((Component)this.editMenu, 0);
            }
        });
        this.menuBar.add(olapMenu);
        this.enterpriseMenu = new JMenu("Enterprise");
        this.enterpriseLinkButton = new JMenuItem(this.enterpriseLinkAction);
        this.enterpriseLinkButton.setText("Get Enterprise...");
        this.enterpriseMenu.add(this.enterpriseLinkButton);
        this.enterpriseMenu.add(this.openServerManagerAction);
        this.openServerManagerAction.setEnabled(false);
        this.enterpriseMenu.add(this.openProjectManagerAction);
        this.openProjectManagerAction.setEnabled(false);
        this.openRevisionListAction.setEnabled(this.currentSession.isEnterpriseSession());
        this.enterpriseMenu.add(this.openRevisionListAction);
        this.securityMenu = new JMenu("Security");
        this.securityMenu.setEnabled(this.currentSession.isEnterpriseSession());
        JMenuItem securityManagerMenuItem = new JMenuItem(this.openSecurityManagerPanelAction);
        securityManagerMenuItem.setText("Users & Groups...");
        securityManagerMenuItem.setIcon(GROUP_ICON);
        this.securityMenu.add(securityManagerMenuItem);
        this.securityMenu.add(this.openProjectSecurityPanelAction);
        this.enterpriseMenu.add(this.securityMenu);
        this.enterpriseMenu.add(this.refreshProjectAction);
        this.menuBar.add(this.enterpriseMenu);
        JMenu toolsMenu = new JMenu(Messages.getString("ArchitectFrame.toolsMenu"));
        toolsMenu.setName("TOOLS_MENU");
        toolsMenu.setMnemonic('t');
        toolsMenu.add(this.exportDDLAction);
        toolsMenu.add(this.compareDMAction);
        toolsMenu.add(this.sqlQueryAction);
        toolsMenu.add(this.dataMoverAction);
        this.menuBar.add(toolsMenu);
        JMenu profileMenu = new JMenu(Messages.getString("ArchitectFrame.profileMenu"));
        profileMenu.setMnemonic('p');
        profileMenu.add(this.profileAction);
        this.menuBar.add(profileMenu);
        JMenu windowMenu = new JMenu(Messages.getString("ArchitectFrame.windowMenu"));
        final JCheckBoxMenuItem navigatorMenuItem = new JCheckBoxMenuItem(Messages.getString("ArchitectFrame.navigatorMenu"));
        navigatorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (navigatorMenuItem.isSelected()) {
                    Point location = ArchitectFrame.this.getLocation();
                    location.translate(ArchitectFrame.this.splitPane.getWidth() - 25, 75);
                    ArchitectFrame.this.navigatorDialog = new Navigator(ArchitectFrame.this, location);
                    ArchitectFrame.this.navigatorDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            navigatorMenuItem.setSelected(false);
                            ArchitectFrame.this.navigatorDialog.dispose();
                        }
                    });
                } else {
                    ArchitectFrame.this.navigatorDialog.dispose();
                }
            }
        });
        windowMenu.add(navigatorMenuItem);
        windowMenu.add(new DatabaseConnectionManagerAction(this));
        windowMenu.add(new AbstractAction(Messages.getString("ArchitectFrame.profileManager")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArchitectFrame.this.currentSession.getProfileDialog().setVisible(true);
            }
        });
        windowMenu.add(new JMenuItem(this.getShowCriticsManagerAction()));
        this.menuBar.add(windowMenu);
        JMenu helpMenu = new JMenu(Messages.getString("ArchitectFrame.helpMenu"));
        helpMenu.setMnemonic('h');
        if (!this.context.isMacOSX()) {
            helpMenu.add(this.aboutAction);
            helpMenu.addSeparator();
        }
        helpMenu.add((Action)new OpenUrlAction("http://www.sqlpower.ca/page/architect-start", Messages.getString("ArchitectFrame.gettingStartedAction")));
        helpMenu.add((Action)new OpenUrlAction("http://www.sqlpower.ca/page/architect-demos", Messages.getString("ArchitectFrame.tutorialsAction")));
        helpMenu.add((Action)new OpenUrlAction("http://www.sqlpower.ca/page/architect-faq", Messages.getString("ArchitectFrame.faqAction")));
        helpMenu.add(SPSUtils.forumAction);
        helpMenu.addSeparator();
        helpMenu.add((Action)new OpenUrlAction("http://www.sqlpower.ca/page/architect-e", Messages.getString("ArchitectFrame.upgradeAction")));
        helpMenu.add((Action)new OpenUrlAction("http://www.sqlpower.ca/page/architect_support", Messages.getString("ArchitectFrame.premiumSupportAction")));
        helpMenu.add((Action)new OpenUrlAction("http://www.sqlpower.ca/page/architect-userguide", Messages.getString("ArchitectFrame.userGuideAction")));
        helpMenu.addSeparator();
        helpMenu.add(this.checkForUpdateAction);
        this.menuBar.add(helpMenu);
        this.menuBar.getInputMap().put(KeyStroke.getKeyStroke(9, 2), CYCLE_TAB_ACTION);
        this.menuBar.getInputMap().put(KeyStroke.getKeyStroke(9, 3), CYCLE_TAB_ACTION);
        this.menuBar.getActionMap().put(CYCLE_TAB_ACTION, this.cycleTabAction);
        return this.menuBar;
    }

    public void setCurrentSession(ArchitectSwingSession newSession) {
        if (newSession == this.currentSession) {
            return;
        }
        if (!this.sessions.contains(newSession)) {
            throw new IllegalArgumentException("Session must already be a part of this frame");
        }
        this.undoAction.setUndoManager(newSession.getUndoManager());
        this.redoAction.setUndoManager(newSession.getUndoManager());
        ArchitectSwingSession oldSession = this.currentSession;
        this.currentSession = newSession;
        this.buildOLAPEditMenu();
        this.toggleEnterpriseMenu();
        for (SelectionListener selectionListener : this.selectionListeners) {
            oldSession.getPlayPen().removeSelectionListener(selectionListener);
            for (PlayPenComponent s : oldSession.getPlayPen().getSelectedItems()) {
                selectionListener.itemDeselected(new SelectionEvent(s, 2, 32));
            }
            for (PlayPenComponent s : newSession.getPlayPen().getSelectedItems()) {
                selectionListener.itemSelected(new SelectionEvent(s, 1, 32));
            }
            newSession.getPlayPen().addSelectionListener(selectionListener);
        }
        for (PlayPen.CancelableListener cancelableListener : this.cancelableListeners) {
            cancelableListener.cancel();
            oldSession.getPlayPen().removeCancelableListener(cancelableListener);
            newSession.getPlayPen().addCancelableListener(cancelableListener);
        }
        for (FocusListener focusListener : this.focusListeners) {
            oldSession.getPlayPen().removeFocusListener(focusListener);
            newSession.getPlayPen().addFocusListener(focusListener);
        }
        this.setTitle(Messages.getString("ArchitectSwingSessionImpl.mainFrameTitle", newSession.getName()));
        this.stackedTabPane.setSelectedIndex(this.stackedTabPane.indexOfTab((StackedTabComponent.StackedTab)this.sessionTabs.get((Object)newSession)));
        this.stackedTabPane.setTitleAt(this.stackedTabPane.getSelectedIndex(), newSession.getName());
        int div = this.splitPane.getDividerLocation();
        this.splitPane.setRightComponent(newSession.getProjectPanel());
        this.splitPane.setDividerLocation(div);
        this.firePropertyChange("currentSession", oldSession, newSession);
    }

    private void toggleEnterpriseMenu() {
        this.openRevisionListAction.setEnabled(this.currentSession.isEnterpriseSession());
        this.securityMenu.setEnabled(this.currentSession.isEnterpriseSession());
    }

    public void addPlayPenFocusListener(FocusListener l) {
        this.focusListeners.add(l);
        this.currentSession.getPlayPen().addFocusListener(l);
    }

    public void removePlayPenFocusListener(FocusListener l) {
        this.focusListeners.remove(l);
        this.currentSession.getPlayPen().removeFocusListener(l);
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListeners.add(l);
        this.currentSession.getPlayPen().addSelectionListener(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.selectionListeners.remove(l);
        this.currentSession.getPlayPen().removeSelectionListener(l);
    }

    public void addCancelableListener(PlayPen.CancelableListener l) {
        this.cancelableListeners.add(l);
        this.currentSession.getPlayPen().addCancelableListener(l);
    }

    public void removeCancelableListener(PlayPen.CancelableListener l) {
        this.cancelableListeners.remove(l);
        this.currentSession.getPlayPen().removeCancelableListener(l);
    }

    public JMenu getEnterpriseMenu() {
        return this.enterpriseMenu;
    }

    private JMenu buildOLAPEditMenu() {
        JMenu menu = new JMenu(Messages.getString("ArchitectFrame.editSchemaMenu"));
        menu.add(new JMenuItem(new OLAPEditAction(this.currentSession, null)));
        menu.addSeparator();
        for (OLAPSession olapSession : this.currentSession.getOLAPRootObject().getChildren()) {
            menu.add(new JMenuItem(new OLAPEditAction(this.currentSession, olapSession)));
        }
        return menu;
    }

    public void addSession(ArchitectSwingSession session) {
        if (!this.context.equals(session.getContext())) {
            throw new IllegalArgumentException("Session must be in the same context as this frame");
        }
        session.initGUI(this);
        session.addSessionLifecycleListener(new SessionLifecycleListener<ArchitectSession>(){

            public void sessionClosing(SessionLifecycleEvent<ArchitectSession> e) {
                ArchitectFrame.this.removeSession((ArchitectSwingSession)e.getSource());
            }

            public void sessionOpening(SessionLifecycleEvent<ArchitectSession> e) {
            }
        });
        this.sessions.add(session);
        final StackedTabComponent.StackedTab tab = this.stackedTabPane.addTab(session.getName(), (Component)new JScrollPane(SPSUtils.getBrandedTreePanel((JTree)session.getDBTree())), true);
        tab.getTabComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (tab.isCloseable() && tab.closeButtonContains(e.getX(), e.getY())) {
                    ((ArchitectSwingSession)ArchitectFrame.this.sessionTabs.inverse().get((Object)tab)).close();
                }
            }
        });
        this.sessionTabs.put((Object)session, (Object)tab);
    }

    public void removeSession(ArchitectSwingSession session) {
        int i = this.sessions.indexOf(session);
        this.sessions.remove(session);
        if (this.sessions.size() == 0) {
            try {
                this.saveSettings();
            }
            catch (SQLObjectException e) {
                logger.error((Object)"Exception while saving settings", (Throwable)e);
            }
            this.dispose();
        } else {
            if (session.equals(this.currentSession)) {
                this.setCurrentSession(this.sessions.get(Math.min(i, this.sessions.size() - 1)));
            }
            this.stackedTabPane.removeTabAt(this.stackedTabPane.indexOfTab((StackedTabComponent.StackedTab)this.sessionTabs.get((Object)session)));
            this.sessionTabs.remove((Object)session);
        }
    }

    public boolean createRelationshipIsActive() {
        if (this.createIdentifyingRelationshipAction.isActive()) {
            return true;
        }
        return this.createNonIdentifyingRelationshipAction.isActive();
    }

    public void saveSettings() throws SQLObjectException {
        CoreUserSettings us = this.context.getUserSettings();
        Preferences prefs = this.context.getPrefs();
        prefs.putInt("SwingUserSettings.DIVIDER_LOCATION", this.splitPane.getDividerLocation());
        prefs.putInt("SwingUserSettings.MAIN_FRAME_X", this.getLocation().x);
        prefs.putInt("SwingUserSettings.MAIN_FRAME_Y", this.getLocation().y);
        prefs.putInt("SwingUserSettings.MAIN_FRAME_WIDTH", this.prefWidth);
        prefs.putInt("SwingUserSettings.MAIN_FRAME_HEIGHT", this.prefHeight);
        prefs.putBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", us.getSwingSettings().getBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", true));
        us.write();
        prefs.put("PL.INI.PATH", this.context.getPlDotIniPath());
        prefs.put("DefaultColumnUserSettings.DEFAULT_COLUMN_NAME", SQLColumn.getDefaultName());
        prefs.putInt("DefaultColumnUserSettings.DEFAULT_COLUMN_TYPE", SQLColumn.getDefaultType());
        prefs.putInt("DefaultColumnUserSettings.DEFAULT_COLUMN_PREC", SQLColumn.getDefaultPrec());
        prefs.putInt("DefaultColumnUserSettings.DEFAULT_COLUMN_SCALE", SQLColumn.getDefaultScale());
        prefs.putBoolean("DefaultColumnUserSettings.DEFAULT_COLUMN_INPK", SQLColumn.isDefaultInPK());
        prefs.putBoolean("DefaultColumnUserSettings.DEFAULT_COLUMN_NULLABLE", SQLColumn.isDefaultNullable());
        prefs.putBoolean("DefaultColumnUserSettings.DEFAULT_COLUMN_AUTOINC", SQLColumn.isDefaultAutoInc());
        prefs.put("DefaultColumnUserSettings.DEFAULT_COLUMN_REMARKS", SQLColumn.getDefaultRemarks());
        prefs.put("DefaultColumnUserSettings.DEFAULT_COLUMN_DEFAULT_VALUE", SQLColumn.getDefaultForDefaultValue());
    }

    public void setEnableSaveOption(boolean isEnable) {
        this.saveProjectAction.setEnabled(isEnable);
        this.saveProjectAsAction.setEnabled(isEnable);
    }

    public static void main(final String[] args) throws SQLObjectException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            logger.error((Object)"Unable to set native look and feel. Continuing with default.", (Throwable)e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ArchitectSwingSessionContext context = ASUtils.getContext();
                    Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(context));
                    boolean headless = false;
                    ArrayList<ArchitectSwingSession> sessions = new ArrayList<ArchitectSwingSession>();
                    if (args.length > 0) {
                        for (int i = 0; i < args.length; ++i) {
                            if (args[i].equalsIgnoreCase("-headless")) {
                                headless = true;
                                continue;
                            }
                            File openFile = new File(args[i]);
                            BufferedInputStream in = new BufferedInputStream(new FileInputStream(openFile));
                            ArchitectSwingSession session = context.createSession(in);
                            session.getRecentMenu().putRecentFileName(openFile.getAbsolutePath());
                            session.getProjectLoader().setFile(openFile);
                            sessions.add(session);
                        }
                    } else {
                        sessions.add(context.createSession());
                    }
                    if (!headless) {
                        final ArchitectFrame frame = new ArchitectFrame(context, null);
                        frame.init((ArchitectSwingSession)sessions.get(0));
                        for (int i = 1; i < sessions.size(); ++i) {
                            frame.addSession((ArchitectSwingSession)sessions.get(i));
                            frame.setCurrentSession((ArchitectSwingSession)sessions.get(i));
                        }
                        frame.setCurrentSession((ArchitectSwingSession)sessions.get(0));
                        if (context.getUserSettings().getUpdateCheckSettings().getBoolean("UpdateCheckSettings.AUTO_UPDATE_CHECK", true)) {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    frame.checkForUpdateAction.checkForUpdate(false);
                                }
                            }).start();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ASUtils.showExceptionDialog(null, Messages.getString("ArchitectFrame.architectLaunchFailureMessage"), e);
                }
            }
        });
    }

    public AutoLayoutAction getAutoLayoutAction() {
        return this.autoLayoutAction;
    }

    public JToolBar getPlayPenToolBar() {
        return this.ppBar;
    }

    public Action getNewProjectAction() {
        return this.newProjectAction;
    }

    public void setNewProjectAction(Action newProjectAction) {
        Object accelKey = this.newProjectAction.getValue("AcceleratorKey");
        this.newProjectAction.putValue("AcceleratorKey", null);
        newProjectAction.putValue("AcceleratorKey", accelKey);
        this.newProjectAction = newProjectAction;
        this.newProjectButton.setAction(newProjectAction);
        this.newProjectMenu.setAction(newProjectAction);
    }

    public void setNewWindowAction(Action newWindowAction) {
        Object accelKey = this.newWindowAction.getValue("AcceleratorKey");
        this.newWindowAction.putValue("AcceleratorKey", null);
        newWindowAction.putValue("AcceleratorKey", accelKey);
        this.newWindowAction = newWindowAction;
        this.newWindowMenu.setAction(newWindowAction);
    }

    public ZoomToFitAction getZoomToFitAction() {
        return this.zoomToFitAction;
    }

    public ZoomAction getZoomInAction() {
        return this.zoomInAction;
    }

    public ZoomAction getZoomOutAction() {
        return this.zoomOutAction;
    }

    public ZoomResetAction getZoomResetAction() {
        return this.zoomNormalAction;
    }

    public AboutAction getAboutAction() {
        return this.aboutAction;
    }

    public Action getExitAction() {
        return this.exitAction;
    }

    public PreferencesAction getPrefAction() {
        return this.prefAction;
    }

    public EditSelectedAction getEditSelectedAction() {
        return this.editSelectedAction;
    }

    public EditColumnAction getEditColumnAction() {
        return this.editColumnAction;
    }

    public InsertIndexAction getInsertIndexAction() {
        return this.insertIndexAction;
    }

    public void setPrefAction(PreferencesAction prefAction) {
        this.prefAction = prefAction;
    }

    public EditTableAction getEditTableAction() {
        return this.editTableAction;
    }

    public void setEditTableAction(EditTableAction editTableAction) {
        this.editTableAction = editTableAction;
    }

    public InsertColumnAction getInsertColumnAction() {
        return this.insertColumnAction;
    }

    public EditSelectedIndexAction getEditIndexAction() {
        return this.editIndexAction;
    }

    public EditRelationshipAction getEditRelationshipAction() {
        return this.editRelationshipAction;
    }

    public DeleteSelectedAction getDeleteSelectedAction() {
        return this.deleteSelectedAction;
    }

    public CreateTableAction getCreateTableAction() {
        return this.createTableAction;
    }

    public CreateRelationshipAction getCreateIdentifyingRelationshipAction() {
        return this.createIdentifyingRelationshipAction;
    }

    public CreateRelationshipAction getCreateNonIdentifyingRelationshipAction() {
        return this.createNonIdentifyingRelationshipAction;
    }

    public ReverseRelationshipAction getReverseRelationshipAction() {
        return this.reverseRelationshipAction;
    }

    public ProfileAction getProfileAction() {
        return this.profileAction;
    }

    public JMenuItem getEnterpriseLinkButton() {
        return this.enterpriseLinkButton;
    }

    public OpenProjectAction getOpenProjectAction() {
        return this.openProjectAction;
    }

    public Action getOpenServerManagerAction() {
        return this.openServerManagerAction;
    }

    public void setOpenProjectManagerAction(Action openProjectManagerAction) {
        this.openProjectManagerAction = openProjectManagerAction;
    }

    public Action getOpenProjectManagerAction() {
        return this.openProjectManagerAction;
    }

    public AlignTableAction getAlignTableHorizontalAction() {
        return this.alignTableHorizontalAction;
    }

    public AlignTableAction getAlignTableVerticalAction() {
        return this.alignTableVerticalAction;
    }

    public FocusToChildOrParentTableAction getFocusToParentAction() {
        return this.focusToParentAction;
    }

    public FocusToChildOrParentTableAction getFocusToChildAction() {
        return this.focusToChildAction;
    }

    public JMenuItem getMenuByAction(Class<? extends Action> menuAction) {
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            JMenu innerMenu = this.menuBar.getMenu(i);
            for (int j = 0; j < innerMenu.getItemCount(); ++j) {
                JMenuItem item = innerMenu.getItem(j);
                if (item == null || item.getAction() == null || !menuAction.isAssignableFrom(item.getAction().getClass())) continue;
                return item;
            }
        }
        return null;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public JToolBar getProjectBar() {
        return this.projectBar;
    }

    public ArchitectSwingSession getCurrentSession() {
        return this.currentSession;
    }

    public EditCriticSettingsAction getShowCriticsManagerAction() {
        return this.showCriticsManagerAction;
    }

    public ArchitectStatusBar getStatusBar() {
        return this.statusBar;
    }

    public EditLabelAction getEditLabelAction() {
        return this.editLabelAction;
    }

    private class TabDropTargetListener
    implements DropTargetListener {
        private TabDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            Point mouseLocation = dtde.getLocation();
            int index = ArchitectFrame.this.stackedTabPane.indexAtLocation(mouseLocation.x, mouseLocation.y);
            if (index != -1) {
                dtde.acceptDrag(3 & dtde.getDropAction());
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Point mouseLocation = dtde.getLocation();
            int index = ArchitectFrame.this.stackedTabPane.indexAtLocation(mouseLocation.x, mouseLocation.y);
            StackedTabComponent.StackedTab tab = (StackedTabComponent.StackedTab)ArchitectFrame.this.stackedTabPane.getTabs().get(index);
            PlayPen playPen = ((ArchitectSwingSession)ArchitectFrame.this.sessionTabs.inverse().get((Object)tab)).getPlayPen();
            try {
                if (playPen.addTransferable(dtde.getTransferable(), new Point(playPen.getLocation().x + 100, playPen.getLocation().y + 100), SQLTable.TransferStyles.COPY)) {
                    dtde.acceptDrop(1);
                    dtde.dropComplete(true);
                }
            }
            catch (SQLObjectException e) {
                logger.error((Object)e);
                dtde.rejectDrop();
            }
            catch (UnsupportedFlavorException e) {
                logger.error((Object)e);
                dtde.rejectDrop();
            }
            catch (IOException e) {
                logger.error((Object)e);
                dtde.rejectDrop();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    class ArchitectFrameWindowListener
    extends WindowAdapter {
        ArchitectFrameWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ArrayList localSessions = new ArrayList(ArchitectFrame.this.sessions);
            for (ArchitectSwingSession session : localSessions) {
                session.close();
            }
        }
    }
}

