/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.fileloader;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jd.gui.api.API;
import org.jd.gui.service.fileloader.AbstractTypeFileLoaderProvider;
import org.jd.gui.util.io.TextReader;

public class JavaFileLoaderProvider
extends AbstractTypeFileLoaderProvider {
    protected static final String[] EXTENSIONS = new String[]{"java"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getDescription() {
        return "Java files (*.java)";
    }

    @Override
    public boolean accept(API api, File file) {
        return file.exists() && file.isFile() && file.canRead() && file.getName().toLowerCase().endsWith(".java");
    }

    @Override
    public boolean load(API api, File file) {
        String text = TextReader.getText(file);
        Pattern pattern = Pattern.compile("(?s)(.*\\s)?package\\s+(\\S+)\\s*;.*");
        Matcher matcher = pattern.matcher(text);
        if (matcher.matches()) {
            String pathInFile = matcher.group(2).replace(".", File.separator) + File.separator + file.getName();
            return this.load(api, file, pathInFile);
        }
        return this.load(api, file, file.getName());
    }
}

