/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.util.Arrays;

public final class TlsAEADCipher
implements TlsCipher {
    public static final int AEAD_CCM = 1;
    public static final int AEAD_CHACHA20_POLY1305 = 2;
    public static final int AEAD_GCM = 3;
    private static final int NONCE_RFC5288 = 1;
    private static final int NONCE_RFC7905 = 2;
    private static final long SEQUENCE_NUMBER_PLACEHOLDER = -1L;
    private final TlsCryptoParameters cryptoParams;
    private final int keySize;
    private final int macSize;
    private final int fixed_iv_length;
    private final int record_iv_length;
    private final TlsAEADCipherImpl decryptCipher;
    private final TlsAEADCipherImpl encryptCipher;
    private final byte[] decryptNonce;
    private final byte[] encryptNonce;
    private final byte[] decryptConnectionID;
    private final byte[] encryptConnectionID;
    private final boolean decryptUseInnerPlaintext;
    private final boolean encryptUseInnerPlaintext;
    private final boolean isTLSv13;
    private final int nonceMode;

    public TlsAEADCipher(TlsCryptoParameters tlsCryptoParameters, TlsAEADCipherImpl tlsAEADCipherImpl, TlsAEADCipherImpl tlsAEADCipherImpl2, int n, int n2, int n3) throws IOException {
        SecurityParameters securityParameters = tlsCryptoParameters.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (!TlsImplUtils.isTLSv12(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        this.isTLSv13 = TlsImplUtils.isTLSv13(protocolVersion);
        this.nonceMode = TlsAEADCipher.getNonceMode(this.isTLSv13, n3);
        this.decryptConnectionID = securityParameters.getConnectionIDPeer();
        this.encryptConnectionID = securityParameters.getConnectionIDLocal();
        this.decryptUseInnerPlaintext = this.isTLSv13 || !Arrays.isNullOrEmpty(this.decryptConnectionID);
        this.encryptUseInnerPlaintext = this.isTLSv13 || !Arrays.isNullOrEmpty(this.encryptConnectionID);
        switch (this.nonceMode) {
            case 1: {
                this.fixed_iv_length = 4;
                this.record_iv_length = 8;
                break;
            }
            case 2: {
                this.fixed_iv_length = 12;
                this.record_iv_length = 0;
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        this.cryptoParams = tlsCryptoParameters;
        this.keySize = n;
        this.macSize = n2;
        this.decryptCipher = tlsAEADCipherImpl2;
        this.encryptCipher = tlsAEADCipherImpl;
        this.decryptNonce = new byte[this.fixed_iv_length];
        this.encryptNonce = new byte[this.fixed_iv_length];
        boolean bl = tlsCryptoParameters.isServer();
        if (this.isTLSv13) {
            this.rekeyCipher(securityParameters, tlsAEADCipherImpl2, this.decryptNonce, !bl);
            this.rekeyCipher(securityParameters, tlsAEADCipherImpl, this.encryptNonce, bl);
            return;
        }
        int n4 = 2 * n + 2 * this.fixed_iv_length;
        byte[] byArray = TlsImplUtils.calculateKeyBlock(tlsCryptoParameters, n4);
        int n5 = 0;
        if (bl) {
            tlsAEADCipherImpl2.setKey(byArray, n5, n);
            tlsAEADCipherImpl.setKey(byArray, n5 += n, n);
            System.arraycopy(byArray, n5 += n, this.decryptNonce, 0, this.fixed_iv_length);
            System.arraycopy(byArray, n5 += this.fixed_iv_length, this.encryptNonce, 0, this.fixed_iv_length);
            n5 += this.fixed_iv_length;
        } else {
            tlsAEADCipherImpl.setKey(byArray, n5, n);
            tlsAEADCipherImpl2.setKey(byArray, n5 += n, n);
            System.arraycopy(byArray, n5 += n, this.encryptNonce, 0, this.fixed_iv_length);
            System.arraycopy(byArray, n5 += this.fixed_iv_length, this.decryptNonce, 0, this.fixed_iv_length);
            n5 += this.fixed_iv_length;
        }
        if (n4 != n5) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public int getCiphertextDecodeLimit(int n) {
        int n2 = n + (this.decryptUseInnerPlaintext ? 1 : 0);
        return n2 + this.macSize + this.record_iv_length;
    }

    @Override
    public int getCiphertextEncodeLimit(int n) {
        int n2 = n + (this.encryptUseInnerPlaintext ? 1 : 0);
        return n2 + this.macSize + this.record_iv_length;
    }

    @Override
    public int getPlaintextDecodeLimit(int n) {
        int n2 = n - this.macSize - this.record_iv_length;
        return n2 - (this.decryptUseInnerPlaintext ? 1 : 0);
    }

    @Override
    public int getPlaintextEncodeLimit(int n) {
        int n2 = n - this.macSize - this.record_iv_length;
        return n2 - (this.encryptUseInnerPlaintext ? 1 : 0);
    }

    @Override
    public TlsEncodeResult encodePlaintext(long l, short s2, ProtocolVersion protocolVersion, int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        byte[] byArray2 = new byte[this.encryptNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.encryptNonce, 0, byArray2, 0, this.encryptNonce.length);
                TlsUtils.writeUint64(l, byArray2, this.encryptNonce.length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(l, byArray2, byArray2.length - 8);
                for (n4 = 0; n4 < this.encryptNonce.length; ++n4) {
                    int n5 = n4;
                    byArray2[n5] = (byte)(byArray2[n5] ^ this.encryptNonce[n4]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        n4 = n3 + (this.encryptUseInnerPlaintext ? 1 : 0);
        this.encryptCipher.init(byArray2, this.macSize);
        int n6 = this.encryptCipher.getOutputSize(n4);
        int n7 = this.record_iv_length + n6;
        byte[] byArray3 = new byte[n + n7];
        int n8 = n;
        if (this.record_iv_length != 0) {
            System.arraycopy(byArray2, byArray2.length - this.record_iv_length, byArray3, n8, this.record_iv_length);
            n8 += this.record_iv_length;
        }
        short s3 = s2;
        if (this.encryptUseInnerPlaintext) {
            s3 = this.isTLSv13 ? (short)23 : 25;
        }
        byte[] byArray4 = this.getAdditionalData(l, s3, protocolVersion, n7, n4, this.encryptConnectionID);
        try {
            System.arraycopy(byArray, n2, byArray3, n8, n3);
            if (this.encryptUseInnerPlaintext) {
                byArray3[n8 + n3] = (byte)s2;
            }
            n8 += this.encryptCipher.doFinal(byArray4, byArray3, n8, n4, byArray3, n8);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        if (n8 != byArray3.length) {
            throw new TlsFatalAlert(80);
        }
        return new TlsEncodeResult(byArray3, 0, byArray3.length, s3);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long l, short s2, ProtocolVersion protocolVersion, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        short s3;
        int n4;
        block10: {
            byte by;
            int n5;
            if (this.getPlaintextDecodeLimit(n2) < 0) {
                throw new TlsFatalAlert(50);
            }
            byte[] byArray2 = new byte[this.decryptNonce.length + this.record_iv_length];
            switch (this.nonceMode) {
                case 1: {
                    System.arraycopy(this.decryptNonce, 0, byArray2, 0, this.decryptNonce.length);
                    System.arraycopy(byArray, n, byArray2, byArray2.length - this.record_iv_length, this.record_iv_length);
                    break;
                }
                case 2: {
                    TlsUtils.writeUint64(l, byArray2, byArray2.length - 8);
                    for (n4 = 0; n4 < this.decryptNonce.length; ++n4) {
                        int n6 = n4;
                        byArray2[n6] = (byte)(byArray2[n6] ^ this.decryptNonce[n4]);
                    }
                    break;
                }
                default: {
                    throw new TlsFatalAlert(80);
                }
            }
            this.decryptCipher.init(byArray2, this.macSize);
            n4 = n + this.record_iv_length;
            int n7 = n2 - this.record_iv_length;
            int n8 = this.decryptCipher.getOutputSize(n7);
            byte[] byArray3 = this.getAdditionalData(l, s2, protocolVersion, n2, n8, this.decryptConnectionID);
            try {
                n5 = this.decryptCipher.doFinal(byArray3, byArray, n4, n7, byArray, n4);
            }
            catch (RuntimeException runtimeException) {
                throw new TlsFatalAlert(20, (Throwable)runtimeException);
            }
            if (n5 != n8) {
                throw new TlsFatalAlert(80);
            }
            s3 = s2;
            n3 = n8;
            if (!this.decryptUseInnerPlaintext) break block10;
            do {
                if (--n3 >= 0) continue;
                throw new TlsFatalAlert(10);
            } while (0 == (by = byArray[n4 + n3]));
            s3 = (short)(by & 0xFF);
        }
        return new TlsDecodeResult(byArray, n4, n3, s3);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        this.rekeyCipher(this.cryptoParams.getSecurityParametersConnection(), this.decryptCipher, this.decryptNonce, !this.cryptoParams.isServer());
    }

    @Override
    public void rekeyEncoder() throws IOException {
        this.rekeyCipher(this.cryptoParams.getSecurityParametersConnection(), this.encryptCipher, this.encryptNonce, this.cryptoParams.isServer());
    }

    @Override
    public boolean usesOpaqueRecordTypeDecode() {
        return this.decryptUseInnerPlaintext;
    }

    @Override
    public boolean usesOpaqueRecordTypeEncode() {
        return this.encryptUseInnerPlaintext;
    }

    private byte[] getAdditionalData(long l, short s2, ProtocolVersion protocolVersion, int n, int n2, byte[] byArray) throws IOException {
        if (!Arrays.isNullOrEmpty(byArray)) {
            int n3 = byArray.length;
            byte[] byArray2 = new byte[23 + n3];
            TlsUtils.writeUint64(-1L, byArray2, 0);
            TlsUtils.writeUint8((short)25, byArray2, 8);
            TlsUtils.writeUint8(n3, byArray2, 9);
            TlsUtils.writeUint8((short)25, byArray2, 10);
            TlsUtils.writeVersion(protocolVersion, byArray2, 11);
            TlsUtils.writeUint64(l, byArray2, 13);
            System.arraycopy(byArray, 0, byArray2, 21, n3);
            TlsUtils.writeUint16(n2, byArray2, 21 + n3);
            return byArray2;
        }
        if (this.isTLSv13) {
            byte[] byArray3 = new byte[5];
            TlsUtils.writeUint8(s2, byArray3, 0);
            TlsUtils.writeVersion(protocolVersion, byArray3, 1);
            TlsUtils.writeUint16(n, byArray3, 3);
            return byArray3;
        }
        byte[] byArray4 = new byte[13];
        TlsUtils.writeUint64(l, byArray4, 0);
        TlsUtils.writeUint8(s2, byArray4, 8);
        TlsUtils.writeVersion(protocolVersion, byArray4, 9);
        TlsUtils.writeUint16(n2, byArray4, 11);
        return byArray4;
    }

    private void rekeyCipher(SecurityParameters securityParameters, TlsAEADCipherImpl tlsAEADCipherImpl, byte[] byArray, boolean bl) throws IOException {
        TlsSecret tlsSecret;
        if (!this.isTLSv13) {
            throw new TlsFatalAlert(80);
        }
        TlsSecret tlsSecret2 = tlsSecret = bl ? securityParameters.getTrafficSecretServer() : securityParameters.getTrafficSecretClient();
        if (null == tlsSecret) {
            throw new TlsFatalAlert(80);
        }
        this.setup13Cipher(tlsAEADCipherImpl, byArray, tlsSecret, securityParameters.getPRFCryptoHashAlgorithm());
    }

    private void setup13Cipher(TlsAEADCipherImpl tlsAEADCipherImpl, byte[] byArray, TlsSecret tlsSecret, int n) throws IOException {
        byte[] byArray2 = TlsCryptoUtils.hkdfExpandLabel(tlsSecret, n, "key", TlsUtils.EMPTY_BYTES, this.keySize).extract();
        byte[] byArray3 = TlsCryptoUtils.hkdfExpandLabel(tlsSecret, n, "iv", TlsUtils.EMPTY_BYTES, this.fixed_iv_length).extract();
        tlsAEADCipherImpl.setKey(byArray2, 0, this.keySize);
        System.arraycopy(byArray3, 0, byArray, 0, this.fixed_iv_length);
    }

    private static int getNonceMode(boolean bl, int n) throws IOException {
        switch (n) {
            case 1: 
            case 3: {
                return bl ? 2 : 1;
            }
            case 2: {
                return 2;
            }
        }
        throw new TlsFatalAlert(80);
    }
}

