/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.GenericSigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsRSAVerifier
extends BcTlsVerifier {
    public BcTlsRSAVerifier(BcTlsCrypto bcTlsCrypto, RSAKeyParameters rSAKeyParameters) {
        super(bcTlsCrypto, rSAKeyParameters);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) {
        Signer signer;
        NullDigest nullDigest = new NullDigest();
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm != null) {
            if (signatureAndHashAlgorithm.getSignature() != 1) {
                throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
            }
            signer = new RSADigestSigner(nullDigest, TlsUtils.getOIDForHashAlgorithm(signatureAndHashAlgorithm.getHash()));
        } else {
            signer = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), nullDigest);
        }
        signer.init(false, this.publicKey);
        signer.update(byArray, 0, byArray.length);
        return signer.verifySignature(digitallySigned.getSignature());
    }
}

