/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0003\b\u0007\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B-\u0012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0000J\u001b\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u001eH\u0096\u0002J\u0006\u0010\u001f\u001a\u00020\u0004J\b\u0010 \u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rd\u0010\u000b\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004 \f*\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00020\u0002 \f**\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004 \f*\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00020\u0002\u0018\u00010\r0\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lorg/jitsi/nlj/EventTimeline;", "", "Lkotlin/Pair;", "", "Ljava/time/Duration;", "timelineArg", "", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/util/List;Ljava/time/Clock;)V", "timeline", "kotlin.jvm.PlatformType", "", "Ljava/util/List;", "referenceTime", "Ljava/time/Instant;", "getReferenceTime", "()Ljava/time/Instant;", "setReferenceTime", "(Ljava/time/Instant;)V", "size", "", "getSize", "()I", "addEvent", "", "desc", "clone", "iterator", "", "totalDelay", "toString", "jitsi-media-transform"})
@SuppressFBWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"})
public final class EventTimeline
implements Iterable<Pair<? extends String, ? extends Duration>>,
KMappedMarker {
    @NotNull
    private final Clock clock;
    private final List<Pair<String, Duration>> timeline;
    @Nullable
    private Instant referenceTime;

    public EventTimeline(@NotNull List<Pair<String, Duration>> timelineArg, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(timelineArg, "timelineArg");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.clock = clock;
        this.timeline = Collections.synchronizedList(timelineArg);
    }

    public /* synthetic */ EventTimeline(List list, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        if ((n & 2) != 0) {
            clock = Clock.systemUTC();
        }
        this(list, clock);
    }

    @Nullable
    public final Instant getReferenceTime() {
        return this.referenceTime;
    }

    public final void setReferenceTime(@Nullable Instant instant) {
        this.referenceTime = instant;
    }

    public final int getSize() {
        return this.timeline.size();
    }

    public final void addEvent(@NotNull String desc) {
        Intrinsics.checkNotNullParameter(desc, "desc");
        Instant now = this.clock.instant();
        if (this.referenceTime == null) {
            this.referenceTime = now;
        }
        this.timeline.add(TuplesKt.to(desc, Duration.between(this.referenceTime, now)));
    }

    @NotNull
    public final EventTimeline clone() {
        List<Pair<String, Duration>> list = this.timeline;
        Intrinsics.checkNotNullExpressionValue(list, "timeline");
        EventTimeline clone = new EventTimeline(CollectionsKt.toMutableList((Collection)list), this.clock);
        clone.referenceTime = this.referenceTime;
        return clone;
    }

    @Override
    @NotNull
    public Iterator<Pair<String, Duration>> iterator() {
        return this.timeline.iterator();
    }

    @NotNull
    public final Duration totalDelay() {
        Instant instant = this.referenceTime;
        if (instant != null) {
            Instant it = instant;
            boolean bl = false;
            List<Pair<String, Duration>> list = this.timeline;
            Intrinsics.checkNotNullExpressionValue(list, "timeline");
            return CollectionsKt.last(list).getSecond();
        }
        Duration duration = Duration.ofMillis(-1L);
        Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(...)");
        return duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String toString() {
        StringBuffer $this$toString_u24lambda_u244;
        block6: {
            Comparable<Instant> comparable;
            block5: {
                StringBuffer stringBuffer;
                $this$toString_u24lambda_u244 = new StringBuffer();
                boolean bl = false;
                comparable = this.referenceTime;
                if (comparable == null) break block5;
                Instant it = comparable;
                boolean bl2 = false;
                $this$toString_u24lambda_u244.append("Reference time: " + this.referenceTime + "; ");
                List<Pair<String, Duration>> list = this.timeline;
                Intrinsics.checkNotNullExpressionValue(list, "timeline");
                List<Pair<String, Duration>> list2 = list;
                synchronized (list2) {
                    boolean bl3 = false;
                    List<Pair<String, Duration>> list3 = this.timeline;
                    Intrinsics.checkNotNullExpressionValue(list3, "timeline");
                    StringBuffer stringBuffer2 = $this$toString_u24lambda_u244.append(CollectionsKt.joinToString$default(list3, "; ", null, null, 0, null, null, 62, null));
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl19 : MonitorExitStatement: MONITOREXIT : var5_5
                    stringBuffer = stringBuffer2;
                }
                comparable = stringBuffer;
                if (stringBuffer != null) break block6;
            }
            StringBuffer $this$toString_u24lambda_u244_u24lambda_u243 = $this$toString_u24lambda_u244;
            boolean bl = false;
            comparable = $this$toString_u24lambda_u244_u24lambda_u243.append("[No timeline]");
        }
        String string = $this$toString_u24lambda_u244.toString();
        Intrinsics.checkNotNullExpressionValue(string, "with(...)");
        return string;
    }

    public EventTimeline() {
        this(null, null, 3, null);
    }
}

