/*
 * Decompiled with CFR 0.152.
 */
package org.kamranzafar.commons.cloner;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.kamranzafar.commons.cloner.CloningException;
import org.kamranzafar.commons.cloner.CloningStrategy;

public class SerializableCloningStrategy<T>
implements CloningStrategy<T> {
    @Override
    public T shallowClone(T object) {
        throw new CloningException("shallowClone is not supported");
    }

    @Override
    public T deepClone(T object) {
        if (!(object instanceof Serializable)) {
            throw new CloningException("Object is not serializable. Only Serializable objects are supported.");
        }
        return this.clone(object);
    }

    protected T clone(T original) {
        Object clone;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(5120);
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(original);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            clone = in.readObject();
            in.close();
            bos.close();
        }
        catch (Exception e) {
            throw new CloningException(e.getMessage(), e);
        }
        return (T)clone;
    }
}

