/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j;

import com.sun.jna.Platform;
import org.pcap4j.util.PropertiesLoader;

public final class Pcap4jPropertiesLoader {
    private static final String KEY_PREFIX = Pcap4jPropertiesLoader.class.getPackage().getName();
    public static final String PCAP4J_PROPERTIES_PATH_KEY = KEY_PREFIX + ".properties";
    public static final String AF_INET_KEY = KEY_PREFIX + ".af.inet";
    public static final String AF_INET6_KEY = KEY_PREFIX + ".af.inet6";
    public static final String AF_PACKET_KEY = KEY_PREFIX + ".af.packet";
    public static final String AF_LINK_KEY = KEY_PREFIX + ".af.link";
    public static final String DLT_RAW_KEY = KEY_PREFIX + ".dlt.raw";
    private static final int AF_INET_DEFAULT = 2;
    private static final int AF_PACKET_DEFAULT = 17;
    private static final int AF_LINK_DEFAULT = 18;
    private static final int DLT_RAW_DEFAULT = 12;
    private static final int DLT_RAW_OPENBSD = 14;
    private static final int AF_INET6_DEFAULT = 23;
    private static final int AF_INET6_LINUX = 10;
    private static final int AF_INET6_FREEBSD = 28;
    private static final int AF_INET6_MAC = 30;
    private static final Pcap4jPropertiesLoader INSTANCE = new Pcap4jPropertiesLoader();
    private PropertiesLoader loader = new PropertiesLoader(System.getProperty(PCAP4J_PROPERTIES_PATH_KEY, KEY_PREFIX.replace('.', '/') + "/pcap4j.properties"), true, true);

    private Pcap4jPropertiesLoader() {
    }

    public static Pcap4jPropertiesLoader getInstance() {
        return INSTANCE;
    }

    public Integer getAfInet() {
        return this.loader.getInteger(AF_INET_KEY, 2);
    }

    public Integer getAfInet6() {
        return this.loader.getInteger(AF_INET6_KEY, this.getDefaultAfInet6());
    }

    public Integer getAfPacket() {
        return this.loader.getInteger(AF_PACKET_KEY, 17);
    }

    public Integer getAfLink() {
        return this.loader.getInteger(AF_LINK_KEY, 18);
    }

    public Integer getDltRaw() {
        return this.loader.getInteger(DLT_RAW_KEY, this.getDefaultDltRaw());
    }

    private int getDefaultAfInet6() {
        switch (Platform.getOSType()) {
            case 0: {
                return 30;
            }
            case 4: 
            case 10: {
                return 28;
            }
            case 1: 
            case 8: {
                return 10;
            }
        }
        return 23;
    }

    private int getDefaultDltRaw() {
        switch (Platform.getOSType()) {
            case 5: {
                return 14;
            }
        }
        return 12;
    }
}

