"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addTitleTextLayer = addTitleTextLayer;
exports.checkSingleMetric = checkSingleMetric;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function addTitleTextLayer(json) {
  var _layeredSpec$layer;
  if (!json.title) return json;
  const titleTextLayer = {
    mark: {
      type: 'text',
      align: 'center',
      dy: 50,
      fontSize: 16,
      fontWeight: 'bold'
    },
    encoding: {
      text: {
        value: json.title
      }
    }
  };
  let layeredSpec = {
    ...json
  };
  if (!json.layer) {
    const {
      mark,
      encoding,
      ...rest
    } = json;
    layeredSpec = {
      ...rest,
      layer: [{
        mark: {
          type: 'text',
          fontSize: 80,
          fontWeight: 'bold'
        },
        encoding
      }]
    };
  }
  (_layeredSpec$layer = layeredSpec.layer) === null || _layeredSpec$layer === void 0 || _layeredSpec$layer.push(titleTextLayer);
  return layeredSpec;
}

// the sample data format is like : "[{\"flight_count\":2033,\"dayOfWeek\":0}]"
// will check if the string only contains one single key-value pair

function checkSingleMetric(sampleData) {
  const regex = /^"\[\{\\?"[^"]+\\?":[^,}]+\}\]"$/;
  return regex.test(sampleData);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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