"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSqlRoute = registerSqlRoute;
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerSqlRoute(server, service, _dataSourceEnabled) {
  server.post({
    path: '/api/sql/sqlquery',
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLQuery(context, request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: '/api/sql/pplquery',
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLQuery(context, request);
    return response.ok({
      body: retVal
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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