/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPickPath;

public class POcclusionDetection {
    public void detectOccusions(PNode pNode, PBounds pBounds) {
        this.detectOcclusions(pNode, new PPickPath(null, pBounds));
    }

    public void detectOcclusions(PNode pNode, PPickPath pPickPath) {
        if (pNode.fullIntersects(pPickPath.getPickBounds())) {
            pPickPath.pushTransform(pNode.getTransformReference(false));
            int n = pNode.getChildrenCount();
            for (int i = n - 1; i >= 0; --i) {
                PNode pNode2 = pNode.getChild(i);
                if (pNode.getOccluded()) {
                    pNode2.setOccluded(true);
                    continue;
                }
                this.detectOcclusions(pNode2, pPickPath);
            }
            if (!pNode.getOccluded() && pNode.intersects(pPickPath.getPickBounds()) && pNode.isOpaque(pPickPath.getPickBounds())) {
                PNode pNode3 = pNode.getParent();
                while (pNode3 != null && !pNode3.getOccluded()) {
                    pNode3.setOccluded(true);
                }
            }
            pPickPath.popTransform(pNode.getTransformReference(false));
        }
    }
}

