/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeNetworkInterfacesRequestMarshaller
implements Marshaller<Request<DescribeNetworkInterfacesRequest>, DescribeNetworkInterfacesRequest> {
    public Request<DescribeNetworkInterfacesRequest> marshall(DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) {
        if (describeNetworkInterfacesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeNetworkInterfacesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeNetworkInterfaces");
        request.addParameter("Version", "2015-04-15");
        if (describeNetworkInterfacesRequest.isDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)describeNetworkInterfacesRequest.isDryRun()));
        }
        List<String> networkInterfaceIdsList = describeNetworkInterfacesRequest.getNetworkInterfaceIds();
        int networkInterfaceIdsListIndex = 1;
        for (String networkInterfaceIdsListValue : networkInterfaceIdsList) {
            if (networkInterfaceIdsListValue != null) {
                request.addParameter("NetworkInterfaceId." + networkInterfaceIdsListIndex, StringUtils.fromString((String)networkInterfaceIdsListValue));
            }
            ++networkInterfaceIdsListIndex;
        }
        List<Filter> filtersList = describeNetworkInterfacesRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

