/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import net.i2p.data.DateAndFlags;

public class SendMessageOptions
extends DateAndFlags {
    private GzipOption _gzip = GzipOption.DEFAULT;
    private static final int LS_MASK = 256;
    private static final int TAGS_SEND_MASK = 15;
    private static final int[] TAGS_SEND = new int[]{0, 2, 4, 6, 8, 12, 16, 24, 32, 40, 51, 64, 80, 100, 125, 160};
    private static final int TAGS_REQD_MASK = 240;
    private static final int[] TAGS_REQD = new int[]{0, 2, 3, 6, 9, 14, 20, 27, 35, 45, 57, 72, 92, 117, 147, 192};
    private static final int BEST_EFFORT_MASK = 512;
    private static final int GUARANTEED_MASK = 1024;
    private static final int RELIABILITY_MASK = 1536;

    public void setSendLeaseSet(boolean yes) {
        this._flags = yes ? (this._flags &= 0xFFFFFEFF) : (this._flags |= 0x100);
    }

    public boolean getSendLeaseSet() {
        return SendMessageOptions.getSendLeaseSet(this._flags);
    }

    public static boolean getSendLeaseSet(int flags) {
        return (flags & 0x100) == 0;
    }

    public void setTagsToSend(int tags) {
        if (tags < 0) {
            throw new IllegalArgumentException();
        }
        this._flags &= 0xFFFFFFF0;
        this._flags |= SendMessageOptions.valToCode(tags, TAGS_SEND);
    }

    public int getTagsToSend() {
        return SendMessageOptions.getTagsToSend(this._flags);
    }

    public static int getTagsToSend(int flags) {
        int exp = flags & 0xF;
        return SendMessageOptions.codeToVal(exp, TAGS_SEND);
    }

    public void setTagThreshold(int tags) {
        if (tags < 0) {
            throw new IllegalArgumentException();
        }
        this._flags &= 0xFFFFFF0F;
        this._flags |= SendMessageOptions.valToCode(tags, TAGS_REQD) << 4;
    }

    public int getTagThreshold() {
        return SendMessageOptions.getTagThreshold(this._flags);
    }

    public static int getTagThreshold(int flags) {
        int exp = (flags & 0xF0) >> 4;
        return SendMessageOptions.codeToVal(exp, TAGS_REQD);
    }

    private static int valToCode(int val, int[] codes) {
        if (val > 0 && val <= codes[1]) {
            return 1;
        }
        for (int i = 1; i < codes.length; ++i) {
            if (val >= codes[i]) continue;
            return i - 1;
        }
        return codes.length - 1;
    }

    private static int codeToVal(int code, int[] codes) {
        return codes[code];
    }

    public void setReliability(Reliability r) {
        this._flags &= 0xFFFFF9FF;
        switch (r) {
            case BEST_EFFORT: {
                this._flags |= 0x200;
                break;
            }
            case GUARANTEED: {
                this._flags |= 0x400;
                break;
            }
            case UNDEFINED: {
                this._flags |= 0x600;
                break;
            }
        }
    }

    public Reliability getReliability() {
        return SendMessageOptions.getReliability(this._flags);
    }

    public static Reliability getReliability(int flags) {
        switch (flags & 0x600) {
            case 512: {
                return Reliability.BEST_EFFORT;
            }
            case 1024: {
                return Reliability.GUARANTEED;
            }
            default: {
                return Reliability.UNDEFINED;
            }
            case 0: 
        }
        return Reliability.DEFAULT;
    }

    public GzipOption getGzip() {
        return this._gzip;
    }

    public void setGzip(boolean yes) {
        this._gzip = yes ? GzipOption.GZIP_ON : GzipOption.GZIP_OFF;
    }

    public static enum GzipOption {
        DEFAULT,
        GZIP_OFF,
        GZIP_ON;

    }

    public static enum Reliability {
        DEFAULT,
        BEST_EFFORT,
        GUARANTEED,
        UNDEFINED;

    }
}

