/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableBufferBoundarySupplier<T, U extends Collection<? super T>, B>
extends AbstractObservableWithUpstream<T, U> {
    final Callable<? extends ObservableSource<B>> boundarySupplier;
    final Callable<U> bufferSupplier;

    public ObservableBufferBoundarySupplier(ObservableSource<T> source, Callable<? extends ObservableSource<B>> boundarySupplier, Callable<U> bufferSupplier) {
        super(source);
        this.boundarySupplier = boundarySupplier;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t) {
        this.source.subscribe(new BufferBoundarySupplierObserver(new SerializedObserver<U>(t), this.bufferSupplier, this.boundarySupplier));
    }

    static final class BufferBoundaryObserver<T, U extends Collection<? super T>, B>
    extends DisposableObserver<B> {
        final BufferBoundarySupplierObserver<T, U, B> parent;
        boolean once;

        BufferBoundaryObserver(BufferBoundarySupplierObserver<T, U, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t) {
            if (this.once) {
                return;
            }
            this.once = true;
            this.dispose();
            this.parent.next();
        }

        @Override
        public void onError(Throwable t) {
            if (this.once) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.once = true;
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.once) {
                return;
            }
            this.once = true;
            this.parent.next();
        }
    }

    static final class BufferBoundarySupplierObserver<T, U extends Collection<? super T>, B>
    extends QueueDrainObserver<T, U, U>
    implements Observer<T>,
    Disposable {
        final Callable<U> bufferSupplier;
        final Callable<? extends ObservableSource<B>> boundarySupplier;
        Disposable upstream;
        final AtomicReference<Disposable> other = new AtomicReference();
        U buffer;

        BufferBoundarySupplierObserver(Observer<? super U> actual, Callable<U> bufferSupplier, Callable<? extends ObservableSource<B>> boundarySupplier) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.boundarySupplier = boundarySupplier;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                ObservableSource<B> boundary;
                Collection b;
                this.upstream = d;
                Observer actual = this.downstream;
                try {
                    b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.cancelled = true;
                    d.dispose();
                    EmptyDisposable.error(e, actual);
                    return;
                }
                this.buffer = b;
                try {
                    boundary = ObjectHelper.requireNonNull(this.boundarySupplier.call(), "The boundary ObservableSource supplied is null");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.cancelled = true;
                    d.dispose();
                    EmptyDisposable.error(ex, actual);
                    return;
                }
                BufferBoundaryObserver bs = new BufferBoundaryObserver(this);
                this.other.set(bs);
                actual.onSubscribe(this);
                if (!this.cancelled) {
                    boundary.subscribe(bs);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            BufferBoundarySupplierObserver bufferBoundarySupplierObserver = this;
            synchronized (bufferBoundarySupplierObserver) {
                U b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.dispose();
            this.downstream.onError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b;
            BufferBoundarySupplierObserver bufferBoundarySupplierObserver = this;
            synchronized (bufferBoundarySupplierObserver) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainLoop(this.queue, this.downstream, false, this, this);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.dispose();
                this.disposeOther();
                if (this.enter()) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeOther() {
            DisposableHelper.dispose(this.other);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next() {
            ObservableSource<B> boundary;
            Collection next;
            try {
                next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.dispose();
                this.downstream.onError(e);
                return;
            }
            try {
                boundary = ObjectHelper.requireNonNull(this.boundarySupplier.call(), "The boundary ObservableSource supplied is null");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.cancelled = true;
                this.upstream.dispose();
                this.downstream.onError(ex);
                return;
            }
            BufferBoundaryObserver bs = new BufferBoundaryObserver(this);
            if (DisposableHelper.replace(this.other, bs)) {
                U b;
                BufferBoundarySupplierObserver bufferBoundarySupplierObserver = this;
                synchronized (bufferBoundarySupplierObserver) {
                    b = this.buffer;
                    if (b == null) {
                        return;
                    }
                    this.buffer = next;
                }
                boundary.subscribe(bs);
                this.fastPathEmit(b, false, this);
            }
        }

        @Override
        public void accept(Observer<? super U> a, U v) {
            this.downstream.onNext(v);
        }
    }
}

