/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format.proguard;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingWriter;
import org.objectweb.asm.Type;

public final class ProGuardWriter
implements MappingWriter {
    private final Writer writer;
    private int dstNamespace = -1;
    private final String dstNamespaceString;

    public ProGuardWriter(Writer writer) {
        this(writer, 0);
    }

    public ProGuardWriter(Writer writer, int dstNamespace) {
        this.writer = Objects.requireNonNull(writer, "writer cannot be null");
        this.dstNamespace = dstNamespace;
        this.dstNamespaceString = null;
        if (dstNamespace < 0) {
            throw new IllegalArgumentException("Namespace must be non-negative, found " + dstNamespace);
        }
    }

    public ProGuardWriter(Writer writer, String dstNamespace) {
        this.writer = Objects.requireNonNull(writer, "writer cannot be null");
        this.dstNamespaceString = Objects.requireNonNull(dstNamespace, "namespace cannot be null");
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
        if (this.dstNamespaceString != null) {
            this.dstNamespace = dstNamespaces.indexOf(this.dstNamespaceString);
            if (this.dstNamespace == -1) {
                throw new RuntimeException("Invalid destination namespace '" + this.dstNamespaceString + "' not in [" + String.join((CharSequence)", ", dstNamespaces) + ']');
            }
        }
        if (this.dstNamespace >= dstNamespaces.size()) {
            throw new IndexOutOfBoundsException("Namespace " + this.dstNamespace + " doesn't exist in [" + String.join((CharSequence)", ", dstNamespaces) + ']');
        }
    }

    @Override
    public boolean visitClass(String srcName) throws IOException {
        this.writer.write(ProGuardWriter.toJavaClassName(srcName));
        this.writeArrow();
        return true;
    }

    @Override
    public boolean visitField(String srcName, String srcDesc) throws IOException {
        this.writeIndent();
        this.writer.write(ProGuardWriter.toJavaType(srcDesc));
        this.writer.write(32);
        this.writer.write(srcName);
        this.writeArrow();
        return true;
    }

    @Override
    public boolean visitMethod(String srcName, String srcDesc) throws IOException {
        Type type = Type.getMethodType((String)srcDesc);
        this.writeIndent();
        this.writer.write(ProGuardWriter.toJavaType(type.getReturnType().getDescriptor()));
        this.writer.write(32);
        this.writer.write(srcName);
        this.writer.write(40);
        Type[] args = type.getArgumentTypes();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                this.writer.write(44);
            }
            this.writer.write(ProGuardWriter.toJavaType(args[i].getDescriptor()));
        }
        this.writer.write(41);
        this.writeArrow();
        return true;
    }

    @Override
    public boolean visitMethodArg(int argPosition, int lvIndex, String srcName) throws IOException {
        return false;
    }

    @Override
    public boolean visitMethodVar(int lvtRowIndex, int lvIndex, int startOpIdx, String srcName) throws IOException {
        return false;
    }

    @Override
    public void visitDstName(MappedElementKind targetKind, int namespace, String name) throws IOException {
        if (this.dstNamespace != namespace) {
            return;
        }
        if (targetKind == MappedElementKind.CLASS) {
            this.writer.write(ProGuardWriter.toJavaClassName(name));
            this.writer.write(58);
        } else {
            this.writer.write(name);
        }
        this.writer.write(10);
    }

    @Override
    public void visitComment(MappedElementKind targetKind, String comment) throws IOException {
    }

    private void writeArrow() throws IOException {
        this.writer.write(" -> ");
    }

    private void writeIndent() throws IOException {
        this.writer.write("    ");
    }

    private static String toJavaClassName(String name) {
        return name.replace('/', '.');
    }

    private static String toJavaType(String descriptor) {
        StringBuilder result = new StringBuilder();
        int arrayLevel = 0;
        block13: for (int i = 0; i < descriptor.length(); ++i) {
            switch (descriptor.charAt(i)) {
                case '[': {
                    ++arrayLevel;
                    continue block13;
                }
                case 'B': {
                    result.append("byte");
                    continue block13;
                }
                case 'S': {
                    result.append("short");
                    continue block13;
                }
                case 'I': {
                    result.append("int");
                    continue block13;
                }
                case 'J': {
                    result.append("long");
                    continue block13;
                }
                case 'F': {
                    result.append("float");
                    continue block13;
                }
                case 'D': {
                    result.append("double");
                    continue block13;
                }
                case 'C': {
                    result.append("char");
                    continue block13;
                }
                case 'Z': {
                    result.append("boolean");
                    continue block13;
                }
                case 'V': {
                    result.append("void");
                    continue block13;
                }
                case 'L': {
                    while (i + 1 < descriptor.length()) {
                        char c;
                        if ((c = descriptor.charAt(++i)) == '/') {
                            result.append('.');
                            continue;
                        }
                        if (c == ';') continue block13;
                        result.append(c);
                    }
                    continue block13;
                }
                default: {
                    throw new IllegalArgumentException("Unknown character in descriptor: " + descriptor.charAt(i));
                }
            }
        }
        while (arrayLevel > 0) {
            result.append("[]");
            --arrayLevel;
        }
        return result.toString();
    }
}

