/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.impl.visitors;

import io.github.skylot.raung.common.Directive;
import io.github.skylot.raung.common.JavaOpCodes;
import io.github.skylot.raung.common.RaungAccessFlags;
import io.github.skylot.raung.common.asm.StackType;
import io.github.skylot.raung.disasm.impl.utils.RaungDisasmException;
import io.github.skylot.raung.disasm.impl.utils.RaungTypes;
import io.github.skylot.raung.disasm.impl.utils.RaungWriter;
import io.github.skylot.raung.disasm.impl.utils.TypeRefUtils;
import io.github.skylot.raung.disasm.impl.visitors.RaungAnnotationVisitor;
import io.github.skylot.raung.disasm.impl.visitors.RaungClassVisitor;
import io.github.skylot.raung.disasm.impl.visitors.data.LabelData;
import io.github.skylot.raung.disasm.impl.visitors.data.LocalVar;
import io.github.skylot.raung.disasm.impl.visitors.data.TryCatchBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

public class RaungMethodVisitor
extends MethodVisitor {
    private final RaungClassVisitor classVisitor;
    private final RaungWriter writer;
    private final RaungWriter tempWriter = new RaungWriter();
    private final List<String> insns = new ArrayList<String>();
    private final Map<Label, LabelData> labels = new IdentityHashMap<Label, LabelData>();
    private final Map<Integer, RaungWriter> insnAttachments = new HashMap<Integer, RaungWriter>();
    private int catchCount;

    public RaungMethodVisitor(RaungClassVisitor classVisitor) {
        super(classVisitor.getApi());
        this.classVisitor = classVisitor;
        this.writer = classVisitor.getWriter();
    }

    public void visitParameter(String name, int access) {
        this.writer.startLine(".param").space().addString(name).space().add(RaungAccessFlags.format((int)access, (RaungAccessFlags.Scope)RaungAccessFlags.Scope.PARAM));
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return RaungAnnotationVisitor.buildDefaultValueVisitor(this.classVisitor);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return RaungAnnotationVisitor.buildAnnotation(this.classVisitor, descriptor, visible);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return RaungAnnotationVisitor.buildTypeAnnotation(this.classVisitor, typeRef, typePath, descriptor, visible);
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        RaungWriter rw = new RaungWriter().setIndent(this.writer.getIndent());
        RaungAnnotationVisitor av = RaungAnnotationVisitor.buildInsnAnnotation(this.classVisitor, rw, typeRef, typePath, descriptor, visible);
        this.insnAttachments.put(this.insns.size() - 1, rw);
        return av;
    }

    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        return RaungAnnotationVisitor.buildParamAnnotation(this.classVisitor, parameter, descriptor, visible);
    }

    public void visitAttribute(Attribute attribute) {
        this.writer.startLine("# attribute " + attribute);
    }

    public void visitCode() {
    }

    public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        if (this.classVisitor.getArgs().isAutoFrames()) {
            return;
        }
        RaungWriter rw = this.tmpWriter();
        rw.add(Directive.STACK);
        switch (type) {
            case 3: {
                rw.add("same");
                break;
            }
            case 4: {
                rw.add("same1").space().add(this.formatStackType(stack[0]));
                break;
            }
            case 2: {
                rw.add("chop").space().add(numLocal);
                break;
            }
            case 1: {
                rw.add("append");
                rw.setIndent(this.writer.getIndent() + 2);
                for (int i = 0; i < numLocal; ++i) {
                    rw.startLine(this.formatStackType(local[i]));
                }
                rw.setIndent(this.writer.getIndent());
                rw.startLine(".end stack");
                break;
            }
            case 0: {
                int i;
                rw.add("full");
                rw.setIndent(this.writer.getIndent() + 2);
                for (i = 0; i < numStack; ++i) {
                    rw.startLine("stack ").add(i).space().add(this.formatStackType(stack[i]));
                }
                for (i = 0; i < numLocal; ++i) {
                    rw.startLine("local ").add(i).space().add(this.formatStackType(local[i]));
                }
                rw.setIndent(this.writer.getIndent());
                rw.startLine(".end stack");
                break;
            }
            default: {
                throw new RaungDisasmException("Unexpected frame type: " + type);
            }
        }
        this.insns.add(rw.getCode());
    }

    private String formatStackType(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            StackType type = StackType.getByValue((Integer)((Integer)value));
            if (type == null) {
                throw new RaungDisasmException("Unknown primitive stack type: " + value);
            }
            return type.getName();
        }
        if (value instanceof Label) {
            Label lbl = (Label)value;
            LabelData labelData = this.getLabelData(lbl);
            labelData.addUse();
            return "Uninitialized " + labelData.getName();
        }
        throw new IllegalArgumentException("Unknown stack type: " + value + ", class: " + value.getClass().getName());
    }

    public void visitInsn(int opcode) {
        this.insns.add(JavaOpCodes.getName((int)opcode));
    }

    public void visitIntInsn(int opcode, int operand) {
        this.insns.add(this.formatInsn(opcode).add(operand).getCode());
    }

    public void visitVarInsn(int opcode, int var) {
        this.insns.add(this.formatInsn(opcode).add(var).getCode());
    }

    public void visitTypeInsn(int opcode, String type) {
        this.insns.add(this.formatInsn(opcode).add(type).getCode());
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.insns.add(this.formatInsn(opcode).add(owner).space().add(name).space().add(descriptor).getCode());
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        RaungWriter rw = this.formatInsn(opcode);
        if (isInterface && opcode != 185) {
            rw.add("interface ");
        }
        rw.add(owner).space().add(name).space().add(descriptor);
        this.insns.add(rw.getCode());
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle mthHandle, Object ... args) {
        RaungWriter rw = this.tmpWriter().add("invokedynamic").space().add(name).space().add(descriptor);
        rw.setIndent(this.writer.getIndent() + 2);
        rw.startLine(RaungTypes.formatHandle(mthHandle));
        for (int i = 0; i < args.length; ++i) {
            rw.startLine(".arg").space().add(i).space().add(RaungTypes.format(args[i]));
        }
        rw.setIndent(this.writer.getIndent());
        rw.startLine(".end invokedynamic");
        this.insns.add(rw.getCode());
    }

    public void visitJumpInsn(int opcode, Label label) {
        LabelData ld = this.getLabelData(label).addUse();
        this.insns.add(this.formatInsn(opcode).add(ld.getName()).getCode());
    }

    public void visitLdcInsn(Object value) {
        boolean wide = value instanceof Long || value instanceof Double;
        String insn = wide ? "ldc2_w" : "ldc";
        this.insns.add(this.tmpWriter().add(insn).space().add(RaungTypes.format(value)).getCode());
    }

    public void visitIincInsn(int var, int increment) {
        this.insns.add(this.tmpWriter().add("iinc").space().add(var).space().add(increment).getCode());
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        String switchType = this.classVisitor.getArgs().isAutoSwitch() ? "switch" : "tableswitch";
        RaungWriter rw = this.tmpWriter().add(switchType);
        rw.setIndent(this.writer.getIndent() + 1);
        int l = 0;
        for (int i = min; i <= max; ++i) {
            LabelData label = this.getLabelData(labels[l++]).addUse();
            rw.startLine().add(i).space().add(label.getName());
        }
        rw.startLine("default ").add(this.getLabelData(dflt).addUse().getName());
        rw.setIndent(this.writer.getIndent());
        rw.startLine(".end ").add(switchType);
        this.insns.add(rw.getCode());
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        String switchType = this.classVisitor.getArgs().isAutoSwitch() ? "switch" : "lookupswitch";
        RaungWriter rw = this.tmpWriter().add(switchType);
        rw.setIndent(this.writer.getIndent() + 1);
        int len = keys.length;
        for (int i = 0; i < len; ++i) {
            LabelData label = this.getLabelData(labels[i]).addUse();
            rw.startLine().add(keys[i]).space().add(label.getName());
        }
        rw.startLine("default ").add(this.getLabelData(dflt).addUse().getName());
        rw.setIndent(this.writer.getIndent());
        rw.startLine(".end ").add(switchType);
        this.insns.add(rw.getCode());
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.insns.add(this.tmpWriter().add("multianewarray").space().add(descriptor).space().add(numDimensions).getCode());
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        LabelData startLabel = this.getLabelData(start).addUse();
        LabelData endLabel = this.getLabelData(end).addUse();
        LabelData handlerLabel = this.getLabelData(handler).addUse();
        TryCatchBlock tryCatchBlock = new TryCatchBlock(this.catchCount++, startLabel, endLabel, handlerLabel, type);
        endLabel.addCatch(tryCatchBlock);
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.writer.startLine("# try-catch annotation " + TypeRefUtils.formatPath(typeRef, typePath) + " " + descriptor + " " + visible);
        return null;
    }

    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        if (this.addDebugInfo()) {
            LocalVar var = new LocalVar(index, name, descriptor, signature);
            this.getLabelData(start).addStartVars(var);
            this.getLabelData(end).addEndVar(var);
        }
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        return null;
    }

    public void visitLineNumber(int line, Label start) {
        if (this.addDebugInfo()) {
            this.insns.add(".line " + line);
        }
    }

    public void visitLabel(Label label) {
        LabelData ld = this.getLabelData(label);
        ld.setInsnRef(this.insns.size());
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.classVisitor.getArgs().isAutoMax()) {
            return;
        }
        this.writer.startLine(".max stack").space().add(maxStack);
        this.writer.startLine(".max locals").space().add(maxLocals);
        this.writer.newLine();
    }

    public void visitEnd() {
        Map<Integer, LabelData> labelsMap = this.labels.values().stream().filter(LabelData::isUsed).collect(Collectors.toMap(LabelData::getInsnRef, ld -> ld));
        int insnsCount = this.insns.size();
        for (int i = 0; i < insnsCount; ++i) {
            LabelData labelData = labelsMap.get(i);
            if (labelData != null) {
                this.handleLabelDataBeforeInsn(labelData);
            }
            this.addInsnAttachments(i);
            this.writer.startLine(this.insns.get(i));
            if (labelData == null) continue;
            this.handleLabelDataAfterInsn(labelData, i == insnsCount - 1);
        }
        this.writer.setIndent(0);
        this.writer.startLine(".end method");
    }

    private void addInsnAttachments(int insnOffset) {
        RaungWriter rw = this.insnAttachments.get(insnOffset);
        if (rw != null) {
            this.writer.add(rw);
        }
    }

    private void handleLabelDataBeforeInsn(LabelData labelData) {
        if (labelData.getUseCount() != 0) {
            this.writer.decreaseIndent();
            this.writer.startLine().add(labelData.getName());
            this.writer.increaseIndent();
        }
        for (LocalVar startVar : labelData.getStartVars()) {
            this.writer.startLine(".local").space().add(startVar.getIndex()).space().addString(startVar.getName()).space().add(startVar.getType());
            if (startVar.getSignature() == null) continue;
            this.writer.space().add(startVar.getSignature());
        }
        if (!labelData.getCatches().isEmpty()) {
            for (TryCatchBlock catchBlock : labelData.getCatches()) {
                String type = catchBlock.getType();
                this.writer.startLine(Directive.CATCH);
                if (this.classVisitor.getArgs().isSaveCatchNumber()) {
                    this.writer.add('@').add(catchBlock.getId()).space();
                }
                this.writer.add(type == null ? "all" : type).space().add(catchBlock.getStart().getName()).space().add("..").space().add(catchBlock.getEnd().getName()).space().add("goto").space().add(catchBlock.getHandler().getName());
            }
        }
    }

    private void handleLabelDataAfterInsn(LabelData labelData, boolean lastInsn) {
        if (!lastInsn && !labelData.getEndVars().isEmpty()) {
            for (LocalVar endVar : labelData.getEndVars()) {
                this.writer.startLine(".end local ").add(endVar.getIndex()).add(" # ").addString(endVar.getName());
            }
        }
    }

    private LabelData getLabelData(Label label) {
        return this.labels.computeIfAbsent(label, l -> new LabelData(label, String.format(":L%d", this.labels.size())));
    }

    private RaungWriter tmpWriter() {
        return this.tempWriter.clear();
    }

    private RaungWriter formatInsn(int opcode) {
        return this.tmpWriter().add(JavaOpCodes.getName((int)opcode)).space();
    }

    private boolean addDebugInfo() {
        return !this.classVisitor.getArgs().isIgnoreDebugInfo();
    }
}

