/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.debuginfo;

import jadx.api.plugins.input.data.AccessFlags;
import jadx.api.plugins.input.data.ILocalVar;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.types.MethodParametersAttr;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.LocalVarsDebugInfoAttr;
import jadx.core.dex.attributes.nodes.RegDebugInfoAttr;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.Named;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.debuginfo.DebugInfoAttachVisitor;
import jadx.core.dex.visitors.ssa.SSATransform;
import jadx.core.dex.visitors.typeinference.TypeInferenceVisitor;
import jadx.core.dex.visitors.typeinference.TypeUpdateResult;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="Debug Info Apply", desc="Apply debug info to registers (type and names)", runAfter={SSATransform.class, TypeInferenceVisitor.class})
public class DebugInfoApplyVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(DebugInfoApplyVisitor.class);

    @Override
    public void visit(MethodNode mth) throws JadxException {
        try {
            if (mth.contains(AType.LOCAL_VARS_DEBUG_INFO)) {
                DebugInfoApplyVisitor.applyDebugInfo(mth);
                mth.remove(AType.LOCAL_VARS_DEBUG_INFO);
            }
            this.processMethodParametersAttribute(mth);
        }
        catch (Exception e) {
            mth.addWarnComment("Failed to apply debug info", e);
        }
    }

    private static void applyDebugInfo(MethodNode mth) {
        mth.getSVars().forEach(ssaVar -> DebugInfoApplyVisitor.searchAndApplyVarDebugInfo(mth, ssaVar));
        DebugInfoApplyVisitor.fixLinesForReturn(mth);
        DebugInfoApplyVisitor.fixNamesForPhiInsns(mth);
    }

    private static void searchAndApplyVarDebugInfo(MethodNode mth, SSAVar ssaVar) {
        if (DebugInfoApplyVisitor.applyDebugInfo(mth, ssaVar, ssaVar.getAssign())) {
            return;
        }
        for (RegisterArg useArg : ssaVar.getUseList()) {
            if (!DebugInfoApplyVisitor.applyDebugInfo(mth, ssaVar, useArg)) continue;
            return;
        }
        DebugInfoApplyVisitor.searchDebugInfoByOffset(mth, ssaVar);
    }

    private static void searchDebugInfoByOffset(MethodNode mth, SSAVar ssaVar) {
        LocalVarsDebugInfoAttr debugInfoAttr = mth.get(AType.LOCAL_VARS_DEBUG_INFO);
        if (debugInfoAttr == null) {
            return;
        }
        OptionalInt max = ssaVar.getUseList().stream().mapToInt(DebugInfoApplyVisitor::getInsnOffsetByArg).max();
        if (!max.isPresent()) {
            return;
        }
        int startOffset = DebugInfoApplyVisitor.getInsnOffsetByArg(ssaVar.getAssign());
        int endOffset = max.getAsInt();
        int regNum = ssaVar.getRegNum();
        for (ILocalVar localVar : debugInfoAttr.getLocalVars()) {
            int endAddr;
            int startAddr;
            if (localVar.getRegNum() != regNum || !DebugInfoApplyVisitor.isInside(startOffset, startAddr = localVar.getStartOffset(), endAddr = localVar.getEndOffset()) && !DebugInfoApplyVisitor.isInside(endOffset, startAddr, endAddr)) continue;
            ArgType type = DebugInfoAttachVisitor.getVarType(mth, localVar);
            DebugInfoApplyVisitor.applyDebugInfo(mth, ssaVar, type, localVar.getName());
            break;
        }
    }

    private static boolean isInside(int var, int start, int end) {
        return start <= var && var <= end;
    }

    private static int getInsnOffsetByArg(InsnArg arg) {
        InsnNode insn;
        if (arg != null && (insn = arg.getParentInsn()) != null) {
            return insn.getOffset();
        }
        return -1;
    }

    public static boolean applyDebugInfo(MethodNode mth, SSAVar ssaVar, RegisterArg arg) {
        RegDebugInfoAttr debugInfoAttr = arg.get(AType.REG_DEBUG_INFO);
        if (debugInfoAttr == null) {
            return false;
        }
        return DebugInfoApplyVisitor.applyDebugInfo(mth, ssaVar, debugInfoAttr.getRegType(), debugInfoAttr.getName());
    }

    public static boolean applyDebugInfo(MethodNode mth, SSAVar ssaVar, ArgType type, String varName) {
        TypeUpdateResult result = mth.root().getTypeUpdate().applyWithWiderIgnoreUnknown(mth, ssaVar, type);
        if (result == TypeUpdateResult.REJECT) {
            return false;
        }
        if (NameMapper.isValidAndPrintable(varName)) {
            ssaVar.setName(varName);
        }
        return true;
    }

    private static void fixLinesForReturn(MethodNode mth) {
        if (mth.isVoidReturn()) {
            return;
        }
        InsnNode origReturn = null;
        ArrayList<InsnNode> newReturns = new ArrayList<InsnNode>(mth.getPreExitBlocks().size());
        for (BlockNode exit : mth.getPreExitBlocks()) {
            InsnNode ret = BlockUtils.getLastInsn(exit);
            if (ret == null) continue;
            if (ret.contains(AFlag.ORIG_RETURN)) {
                origReturn = ret;
                continue;
            }
            newReturns.add(ret);
        }
        if (origReturn != null) {
            for (InsnNode ret : newReturns) {
                InsnArg oldArg = origReturn.getArg(0);
                InsnArg newArg = ret.getArg(0);
                if (oldArg.isRegister() && newArg.isRegister()) {
                    RegisterArg oldArgReg = (RegisterArg)oldArg;
                    RegisterArg newArgReg = (RegisterArg)newArg;
                    DebugInfoApplyVisitor.applyDebugInfo(mth, newArgReg.getSVar(), oldArgReg.getType(), oldArgReg.getName());
                }
                ret.setSourceLine(origReturn.getSourceLine());
            }
        }
    }

    private static void fixNamesForPhiInsns(MethodNode mth) {
        mth.getSVars().forEach(ssaVar -> {
            for (PhiInsn phiInsn : ssaVar.getUsedInPhi()) {
                HashSet<String> names = new HashSet<String>(1 + phiInsn.getArgsCount());
                DebugInfoApplyVisitor.addArgName(phiInsn.getResult(), names);
                phiInsn.getArguments().forEach(arg -> DebugInfoApplyVisitor.addArgName(arg, names));
                if (names.size() == 1) {
                    DebugInfoApplyVisitor.setNameForInsn(phiInsn, (String)names.iterator().next());
                    continue;
                }
                if (names.size() <= 1) continue;
                mth.addDebugComment("Different variable names in phi insn: " + names + ", use first");
                DebugInfoApplyVisitor.setNameForInsn(phiInsn, (String)names.iterator().next());
            }
        });
    }

    private static void addArgName(InsnArg arg, Set<String> names) {
        String name;
        if (arg instanceof Named && (name = ((Named)((Object)arg)).getName()) != null) {
            names.add(name);
        }
    }

    private static void setNameForInsn(PhiInsn phiInsn, String name) {
        phiInsn.getResult().setName(name);
        phiInsn.getArguments().forEach(arg -> {
            if (arg instanceof Named) {
                ((Named)((Object)arg)).setName(name);
            }
        });
    }

    private void processMethodParametersAttribute(MethodNode mth) {
        MethodParametersAttr parametersAttr = (MethodParametersAttr)mth.get(JadxAttrType.METHOD_PARAMETERS);
        if (parametersAttr == null) {
            return;
        }
        try {
            List params = parametersAttr.getList();
            if (params.size() != mth.getMethodInfo().getArgsCount()) {
                return;
            }
            int i = 0;
            for (RegisterArg mthArg : mth.getArgRegs()) {
                MethodParametersAttr.Info paramInfo;
                String name;
                if (!NameMapper.isValidAndPrintable(name = (paramInfo = (MethodParametersAttr.Info)params.get(i++)).getName())) continue;
                CodeVar codeVar = mthArg.getSVar().getCodeVar();
                codeVar.setName(name);
                if (!AccessFlags.hasFlag((int)paramInfo.getAccFlags(), (int)16)) continue;
                codeVar.setFinal(true);
            }
        }
        catch (Exception e) {
            mth.addWarnComment("Failed to process method parameters attribute: " + parametersAttr.getList(), e);
        }
    }
}

