/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.typeinference.TypeCompareEnum;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCompare {
    private static final Logger LOG = LoggerFactory.getLogger(TypeCompare.class);
    private final RootNode root;
    private final Comparator<ArgType> comparator;
    private final Comparator<ArgType> reversedComparator;

    public TypeCompare(RootNode root) {
        this.root = root;
        this.comparator = new ArgTypeComparator();
        this.reversedComparator = this.comparator.reversed();
    }

    public TypeCompareEnum compareTypes(ClassNode first, ClassNode second) {
        return this.compareObjects(first.getType(), second.getType());
    }

    public TypeCompareEnum compareTypes(ClassInfo first, ClassInfo second) {
        return this.compareObjects(first.getType(), second.getType());
    }

    public TypeCompareEnum compareObjects(ArgType first, ArgType second) {
        if (first == second || Objects.equals(first, second)) {
            return TypeCompareEnum.EQUAL;
        }
        return this.compareObjectsNoPreCheck(first, second);
    }

    public TypeCompareEnum compareTypes(ArgType first, ArgType second) {
        boolean secondArray;
        boolean secondKnown;
        if (first == second || Objects.equals(first, second)) {
            return TypeCompareEnum.EQUAL;
        }
        boolean firstKnown = first.isTypeKnown();
        if (firstKnown != (secondKnown = second.isTypeKnown())) {
            if (firstKnown) {
                return this.compareWithUnknown(first, second);
            }
            return this.compareWithUnknown(second, first).invert();
        }
        boolean firstArray = first.isArray();
        if (firstArray != (secondArray = second.isArray())) {
            if (firstArray) {
                return this.compareArrayWithOtherType(first, second);
            }
            return this.compareArrayWithOtherType(second, first).invert();
        }
        if (firstArray) {
            return this.compareTypes(first.getArrayElement(), second.getArrayElement());
        }
        if (!firstKnown) {
            int variantLen = Integer.compare(first.getPossibleTypes().length, second.getPossibleTypes().length);
            return variantLen > 0 ? TypeCompareEnum.WIDER : TypeCompareEnum.NARROW;
        }
        boolean firstPrimitive = first.isPrimitive();
        boolean secondPrimitive = second.isPrimitive();
        boolean firstObj = first.isObject();
        boolean secondObj = second.isObject();
        if (firstObj && secondObj) {
            return this.compareObjectsNoPreCheck(first, second);
        }
        if (firstObj && secondPrimitive) {
            return TypeCompareEnum.CONFLICT;
        }
        if (firstPrimitive && secondObj) {
            return TypeCompareEnum.CONFLICT;
        }
        if (firstPrimitive && secondPrimitive) {
            PrimitiveType firstPrimitiveType = first.getPrimitiveType();
            PrimitiveType secondPrimitiveType = second.getPrimitiveType();
            if (firstPrimitiveType == PrimitiveType.BOOLEAN || secondPrimitiveType == PrimitiveType.BOOLEAN) {
                return TypeCompareEnum.CONFLICT;
            }
            if (this.swapEquals(firstPrimitiveType, secondPrimitiveType, PrimitiveType.CHAR, PrimitiveType.BYTE) || this.swapEquals(firstPrimitiveType, secondPrimitiveType, PrimitiveType.CHAR, PrimitiveType.SHORT)) {
                return TypeCompareEnum.CONFLICT;
            }
            return firstPrimitiveType.compareTo(secondPrimitiveType) > 0 ? TypeCompareEnum.WIDER : TypeCompareEnum.NARROW;
        }
        LOG.warn("Type compare function not complete, can't compare {} and {}", (Object)first, (Object)second);
        return TypeCompareEnum.CONFLICT;
    }

    private boolean swapEquals(PrimitiveType first, PrimitiveType second, PrimitiveType a, PrimitiveType b) {
        return first == a && second == b || first == b && second == a;
    }

    private TypeCompareEnum compareArrayWithOtherType(ArgType array, ArgType other) {
        if (!other.isTypeKnown()) {
            if (other.contains(PrimitiveType.ARRAY)) {
                return TypeCompareEnum.NARROW;
            }
            return TypeCompareEnum.CONFLICT;
        }
        if (other.isObject()) {
            if (other.equals(ArgType.OBJECT)) {
                return TypeCompareEnum.NARROW;
            }
            return TypeCompareEnum.CONFLICT;
        }
        if (other.isPrimitive()) {
            return TypeCompareEnum.CONFLICT;
        }
        throw new JadxRuntimeException("Unprocessed type: " + other + " in array compare");
    }

    private TypeCompareEnum compareWithUnknown(ArgType known, ArgType unknown) {
        PrimitiveType[] possibleTypes;
        if (unknown == ArgType.UNKNOWN) {
            return TypeCompareEnum.NARROW;
        }
        if (unknown == ArgType.UNKNOWN_OBJECT && (known.isObject() || known.isArray())) {
            return TypeCompareEnum.NARROW;
        }
        if (known.equals(ArgType.OBJECT) && unknown.isArray()) {
            return TypeCompareEnum.WIDER;
        }
        PrimitiveType knownPrimitive = known.isPrimitive() ? known.getPrimitiveType() : (known.isArray() ? PrimitiveType.ARRAY : PrimitiveType.OBJECT);
        for (PrimitiveType possibleType : possibleTypes = unknown.getPossibleTypes()) {
            if (possibleType != knownPrimitive) continue;
            return TypeCompareEnum.NARROW;
        }
        return TypeCompareEnum.CONFLICT;
    }

    private TypeCompareEnum compareObjectsNoPreCheck(ArgType first, ArgType second) {
        boolean firstIsObjCls;
        boolean objectsEquals = first.getObject().equals(second.getObject());
        boolean firstGenericType = first.isGenericType();
        boolean secondGenericType = second.isGenericType();
        if (firstGenericType && secondGenericType && !objectsEquals) {
            return TypeCompareEnum.CONFLICT;
        }
        boolean firstGeneric = first.isGeneric();
        boolean secondGeneric = second.isGeneric();
        if (firstGenericType || secondGenericType) {
            ArgType firstWildcardType = first.getWildcardType();
            ArgType secondWildcardType = second.getWildcardType();
            if (firstWildcardType != null || secondWildcardType != null) {
                if (firstWildcardType != null && secondGenericType && first.getWildcardBound() == ArgType.WildcardBound.UNBOUND) {
                    return TypeCompareEnum.CONFLICT;
                }
                if (firstGenericType && secondWildcardType != null && second.getWildcardBound() == ArgType.WildcardBound.UNBOUND) {
                    return TypeCompareEnum.CONFLICT;
                }
            }
            if (firstGenericType) {
                return this.compareGenericTypeWithObject(first, second);
            }
            return this.compareGenericTypeWithObject(second, first).invert();
        }
        if (objectsEquals) {
            if (firstGeneric != secondGeneric) {
                return firstGeneric ? TypeCompareEnum.NARROW_BY_GENERIC : TypeCompareEnum.WIDER_BY_GENERIC;
            }
            if (first.getWildcardBound() != null && second.getWildcardBound() != null) {
                return this.compareWildcardTypes(first, second);
            }
            List<ArgType> firstGenericTypes = first.getGenericTypes();
            List<ArgType> secondGenericTypes = second.getGenericTypes();
            if (Utils.isEmpty(firstGenericTypes) || Utils.isEmpty(secondGenericTypes)) {
                ArgType firstOuterType = first.getOuterType();
                ArgType secondOuterType = second.getOuterType();
                if (firstOuterType != null && secondOuterType != null) {
                    return this.compareTypes(firstOuterType, secondOuterType);
                }
            } else {
                int len = firstGenericTypes.size();
                if (len == secondGenericTypes.size()) {
                    for (int i = 0; i < len; ++i) {
                        TypeCompareEnum res = this.compareTypes(firstGenericTypes.get(i), secondGenericTypes.get(i));
                        if (res == TypeCompareEnum.EQUAL) continue;
                        return res;
                    }
                }
            }
        }
        if ((firstIsObjCls = first.equals(ArgType.OBJECT)) || second.equals(ArgType.OBJECT)) {
            return firstIsObjCls ? TypeCompareEnum.WIDER : TypeCompareEnum.NARROW;
        }
        if (ArgType.isInstanceOf(this.root, first, second)) {
            return TypeCompareEnum.NARROW;
        }
        if (ArgType.isInstanceOf(this.root, second, first)) {
            return TypeCompareEnum.WIDER;
        }
        if (!ArgType.isClsKnown(this.root, first) || !ArgType.isClsKnown(this.root, second)) {
            return TypeCompareEnum.UNKNOWN;
        }
        return TypeCompareEnum.CONFLICT;
    }

    private TypeCompareEnum compareWildcardTypes(ArgType first, ArgType second) {
        ArgType.WildcardBound firstWildcardBound = first.getWildcardBound();
        ArgType.WildcardBound secondWildcardBound = second.getWildcardBound();
        if (firstWildcardBound == ArgType.WildcardBound.UNBOUND) {
            return TypeCompareEnum.WIDER;
        }
        if (secondWildcardBound == ArgType.WildcardBound.UNBOUND) {
            return TypeCompareEnum.NARROW;
        }
        TypeCompareEnum wildcardCompare = this.compareTypes(first.getWildcardType(), second.getWildcardType());
        if (firstWildcardBound == secondWildcardBound) {
            return wildcardCompare;
        }
        return TypeCompareEnum.CONFLICT;
    }

    private TypeCompareEnum compareGenericTypeWithObject(ArgType genericType, ArgType objType) {
        if (objType.isGenericType()) {
            return this.compareTypeVariables(genericType, objType);
        }
        boolean rootObject = objType.equals(ArgType.OBJECT);
        List<ArgType> extendTypes = genericType.getExtendTypes();
        if (extendTypes.isEmpty()) {
            return rootObject ? TypeCompareEnum.NARROW : TypeCompareEnum.CONFLICT;
        }
        if (extendTypes.contains(objType) || rootObject) {
            return TypeCompareEnum.NARROW;
        }
        for (ArgType extendType : extendTypes) {
            TypeCompareEnum res = this.compareObjectsNoPreCheck(extendType, objType);
            if (res.isNarrow()) continue;
            return res;
        }
        return TypeCompareEnum.NARROW;
    }

    private TypeCompareEnum compareTypeVariables(ArgType first, ArgType second) {
        if (first.getObject().equals(second.getObject())) {
            List<ArgType> secondExtendTypes;
            List<ArgType> firstExtendTypes = this.removeObject(first.getExtendTypes());
            if (firstExtendTypes.equals(secondExtendTypes = this.removeObject(second.getExtendTypes()))) {
                return TypeCompareEnum.EQUAL;
            }
            int firstExtSize = firstExtendTypes.size();
            int secondExtSize = secondExtendTypes.size();
            if (firstExtSize == 0) {
                return TypeCompareEnum.WIDER;
            }
            if (secondExtSize == 0) {
                return TypeCompareEnum.NARROW;
            }
            if (firstExtSize == 1 && secondExtSize == 1) {
                return this.compareTypes(firstExtendTypes.get(0), secondExtendTypes.get(0));
            }
        }
        return TypeCompareEnum.CONFLICT;
    }

    private List<ArgType> removeObject(List<ArgType> extendTypes) {
        if (extendTypes.contains(ArgType.OBJECT)) {
            if (extendTypes.size() == 1) {
                return Collections.emptyList();
            }
            ArrayList<ArgType> result = new ArrayList<ArgType>(extendTypes);
            result.remove(ArgType.OBJECT);
            return result;
        }
        return extendTypes;
    }

    public Comparator<ArgType> getComparator() {
        return this.comparator;
    }

    public Comparator<ArgType> getReversedComparator() {
        return this.reversedComparator;
    }

    private final class ArgTypeComparator
    implements Comparator<ArgType> {
        private ArgTypeComparator() {
        }

        @Override
        public int compare(ArgType a, ArgType b) {
            TypeCompareEnum result = TypeCompare.this.compareTypes(a, b);
            switch (result) {
                case CONFLICT: {
                    return -2;
                }
                case WIDER: 
                case WIDER_BY_GENERIC: {
                    return -1;
                }
                case NARROW: 
                case NARROW_BY_GENERIC: {
                    return 1;
                }
            }
            return 0;
        }
    }
}

