/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.deobf.NameMapper;
import jadx.core.deobf.TldHelper;
import jadx.core.utils.StringUtils;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetterName {
    private static final Logger LOG = LoggerFactory.getLogger(BetterName.class);
    private static final boolean DEBUG = true;

    public static String compareAndGet(String first, String second) {
        int secondRating;
        boolean firstBetter;
        if (Objects.equals(first, second)) {
            return first;
        }
        int firstRating = BetterName.calcRating(first);
        boolean bl = firstBetter = firstRating >= (secondRating = BetterName.calcRating(second));
        if (firstBetter) {
            LOG.info("Better name: '{}' > '{}' ({} > {})", new Object[]{first, second, firstRating, secondRating});
        } else {
            LOG.info("Better name: '{}' > '{}' ({} > {})", new Object[]{second, first, secondRating, firstRating});
        }
        return firstBetter ? first : second;
    }

    public static int calcRating(String str) {
        int rating = str.length() * 3;
        rating += BetterName.differentCharsCount(str) * 20;
        if (NameMapper.isAllCharsPrintable(str)) {
            rating += 100;
        }
        if (NameMapper.isValidIdentifier(str)) {
            rating += 50;
        }
        if (TldHelper.contains(str)) {
            rating += 20;
        }
        if (str.contains("_")) {
            rating += 100;
        }
        return rating;
    }

    private static int differentCharsCount(String str) {
        String lower = str.toLowerCase(Locale.ROOT);
        HashSet chars = new HashSet();
        StringUtils.visitCodePoints(lower, chars::add);
        return chars.size();
    }
}

