/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.search;

import jadx.gui.jobs.BackgroundExecutor;
import jadx.gui.jobs.CancelableBackgroundTask;
import jadx.gui.jobs.ITaskInfo;
import jadx.gui.jobs.ITaskProgress;
import jadx.gui.jobs.TaskProgress;
import jadx.gui.jobs.TaskStatus;
import jadx.gui.search.ISearchProvider;
import jadx.gui.search.SearchJob;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTask
extends CancelableBackgroundTask {
    private static final Logger LOG = LoggerFactory.getLogger(SearchTask.class);
    private final BackgroundExecutor backgroundExecutor;
    private final Consumer<JNode> resultsListener;
    private final BiConsumer<ITaskInfo, Boolean> onFinish;
    private final List<SearchJob> jobs = new ArrayList<SearchJob>();
    private final TaskProgress taskProgress = new TaskProgress();
    private final AtomicInteger resultsCount = new AtomicInteger(0);
    private int resultsLimit;
    private Future<TaskStatus> future;
    private Consumer<ITaskProgress> progressListener;

    public SearchTask(MainWindow mainWindow, Consumer<JNode> results, BiConsumer<ITaskInfo, Boolean> onFinish) {
        this.backgroundExecutor = mainWindow.getBackgroundExecutor();
        this.resultsListener = results;
        this.onFinish = onFinish;
    }

    public void addProviderJob(ISearchProvider provider) {
        this.jobs.add(new SearchJob(this, provider));
    }

    public void setResultsLimit(int limit) {
        this.resultsLimit = limit;
    }

    public synchronized void fetchResults() {
        if (this.future != null) {
            throw new IllegalStateException("Previous task not yet finished");
        }
        this.resetCancel();
        this.resultsCount.set(0);
        this.taskProgress.updateTotal(this.jobs.stream().mapToInt(s -> s.getProvider().total()).sum());
        this.future = this.backgroundExecutor.execute(this);
    }

    public synchronized boolean addResult(JNode resultNode) {
        if (this.isCanceled()) {
            return true;
        }
        this.resultsListener.accept(resultNode);
        if (this.resultsLimit != 0 && this.resultsCount.incrementAndGet() >= this.resultsLimit) {
            this.cancel();
            return true;
        }
        return false;
    }

    public synchronized void waitTask() {
        if (this.future != null) {
            try {
                this.future.get(200L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                LOG.debug("Search task wait timeout");
            }
            catch (Exception e) {
                LOG.warn("Search task wait error", (Throwable)e);
            }
            finally {
                this.future.cancel(true);
                this.future = null;
            }
        }
    }

    @Override
    public String getTitle() {
        return NLS.str("search_dialog.tip_searching");
    }

    @Override
    public List<? extends Runnable> scheduleJobs() {
        return this.jobs;
    }

    @Override
    public void onFinish(ITaskInfo task) {
        boolean complete = !this.isCanceled() && task.getStatus() == TaskStatus.COMPLETE && task.getJobsComplete() == task.getJobsCount();
        this.onFinish.accept(task, complete);
    }

    @Override
    public boolean checkMemoryUsage() {
        return true;
    }

    @Override
    @NotNull
    public ITaskProgress getTaskProgress() {
        this.taskProgress.updateProgress(this.jobs.stream().mapToInt(s -> s.getProvider().progress()).sum());
        return this.taskProgress;
    }

    public void setProgressListener(Consumer<ITaskProgress> progressListener) {
        this.progressListener = progressListener;
    }

    @Override
    @Nullable
    public Consumer<ITaskProgress> getProgressListener() {
        return this.progressListener;
    }

    @Override
    public int getCancelTimeoutMS() {
        return 0;
    }

    @Override
    public int getShutdownTimeoutMS() {
        return 10;
    }
}

