/*
 * Decompiled with CFR 0.152.
 */
package org.jf.smali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.smali.Smali;
import org.jf.smali.SmaliOptions;
import org.jf.util.jcommander.Command;
import org.jf.util.jcommander.ExtendedParameter;
import org.jf.util.jcommander.ExtendedParameters;

@Parameters(commandDescription="Assembles smali files into a dex file.")
@ExtendedParameters(commandName="assemble", commandAliases={"ass", "as", "a"})
public class AssembleCommand
extends Command {
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information for this command.")
    private boolean help;
    @Parameter(names={"-j", "--jobs"}, description="The number of threads to use. Defaults to the number of cores available.", validateWith=PositiveInteger.class)
    @ExtendedParameter(argumentNames={"n"})
    private int jobs = Runtime.getRuntime().availableProcessors();
    @Parameter(names={"-a", "--api"}, description="The numeric api level to use while assembling.")
    @ExtendedParameter(argumentNames={"api"})
    private int apiLevel = 15;
    @Parameter(names={"-o", "--output"}, description="The name/path of the dex file to write.")
    @ExtendedParameter(argumentNames={"file"})
    private String output = "out.dex";
    @Parameter(names={"--verbose"}, description="Generate verbose error messages.")
    private boolean verbose = false;
    @Parameter(names={"--allow-odex-opcodes", "--allow-odex", "--ao"}, description="Allows the odex opcodes that dalvik doesn't reject to be assembled.")
    private boolean allowOdexOpcodes;
    @Parameter(description="Assembles the given files. If a directory is specified, it will be recursively searched for any files with a .smali prefix")
    @ExtendedParameter(argumentNames={"[<file>|<dir>]+"})
    private List<String> input;

    public AssembleCommand(@Nonnull List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    public void run() {
        if (this.help || this.input == null || this.input.isEmpty()) {
            this.usage();
            return;
        }
        try {
            Smali.assemble(this.getOptions(), this.input);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected SmaliOptions getOptions() {
        SmaliOptions options = new SmaliOptions();
        options.jobs = this.jobs;
        options.apiLevel = this.apiLevel;
        options.outputDexFile = this.output;
        options.allowOdexOpcodes = this.allowOdexOpcodes;
        options.verboseErrors = this.verbose;
        return options;
    }
}

