/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import hu.akarnokd.rxjava2.swing.AbstractEventConsumer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

final class FocusEventObservable
extends Observable<FocusEvent> {
    final Component widget;

    FocusEventObservable(Component widget) {
        this.widget = widget;
    }

    protected void subscribeActual(Observer<? super FocusEvent> observer) {
        Component w = this.widget;
        FocusEventConsumer aec = new FocusEventConsumer(observer, w);
        observer.onSubscribe((Disposable)aec);
        w.addFocusListener(aec);
        if (aec.get() == null) {
            w.removeFocusListener(aec);
        }
    }

    static final class FocusEventConsumer
    extends AbstractEventConsumer<FocusEvent, Component>
    implements FocusListener {
        private static final long serialVersionUID = -3605206827474016488L;

        FocusEventConsumer(Observer<? super FocusEvent> actual, Component widget) {
            super(actual, widget);
        }

        @Override
        protected void onDispose(Component w) {
            w.removeFocusListener(this);
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.actual.onNext((Object)e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.actual.onNext((Object)e);
        }
    }
}

