/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import hu.akarnokd.rxjava2.swing.AbstractEventConsumer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

final class MouseWheelEventObservable
extends Observable<MouseWheelEvent> {
    final Component widget;

    MouseWheelEventObservable(Component widget) {
        this.widget = widget;
    }

    protected void subscribeActual(Observer<? super MouseWheelEvent> observer) {
        Component w = this.widget;
        MouseWheelEventConsumer aec = new MouseWheelEventConsumer(observer, w);
        observer.onSubscribe((Disposable)aec);
        w.addMouseWheelListener(aec);
        if (aec.get() == null) {
            w.removeMouseWheelListener(aec);
        }
    }

    static final class MouseWheelEventConsumer
    extends AbstractEventConsumer<MouseWheelEvent, Component>
    implements MouseWheelListener {
        private static final long serialVersionUID = -3605206827474016488L;

        MouseWheelEventConsumer(Observer<? super MouseWheelEvent> actual, Component widget) {
            super(actual, widget);
        }

        @Override
        protected void onDispose(Component component) {
            component.removeMouseWheelListener(this);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.actual.onNext((Object)e);
        }
    }
}

