/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import hu.akarnokd.rxjava2.swing.AbstractEventConsumer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;

final class TreeWillExpandEventObservable
extends Observable<TreeExpansionEvent> {
    final JTree widget;

    TreeWillExpandEventObservable(JTree widget) {
        this.widget = widget;
    }

    protected void subscribeActual(Observer<? super TreeExpansionEvent> observer) {
        JTree w = this.widget;
        TreeWillExpandEventConsumer aec = new TreeWillExpandEventConsumer(observer, w);
        observer.onSubscribe((Disposable)aec);
        w.addTreeWillExpandListener(aec);
        if (aec.get() == null) {
            aec.onDispose(w);
        }
    }

    static final class TreeWillExpandEventConsumer
    extends AbstractEventConsumer<TreeExpansionEvent, JTree>
    implements TreeWillExpandListener {
        private static final long serialVersionUID = -3605206827474016488L;

        TreeWillExpandEventConsumer(Observer<? super TreeExpansionEvent> actual, JTree widget) {
            super(actual, widget);
        }

        @Override
        protected void onDispose(JTree w) {
            w.removeTreeWillExpandListener(this);
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            this.actual.onNext((Object)event);
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            this.actual.onNext((Object)event);
        }
    }
}

