/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import twitter4j.Authorization;
import twitter4j.HttpParameter;
import twitter4j.HttpRequest;
import twitter4j.HttpResponse;
import twitter4j.HttpResponseCode;
import twitter4j.HttpResponseEvent;
import twitter4j.HttpResponseListener;
import twitter4j.Logger;
import twitter4j.RequestMethod;
import twitter4j.TwitterException;
import twitter4j.Version;

final class HttpClient
implements HttpResponseCode,
Serializable {
    private final String httpProxyHost;
    private final int httpProxyPort;
    private final String httpProxyUser;
    private final String httpProxyPassword;
    private final boolean httpProxySocks;
    private final int httpRetryCount;
    private final int httpRetryIntervalSeconds;
    private final int httpConnectionTimeout;
    private final int httpReadTimeout;
    private final boolean prettyDebug;
    private static final Logger logger = Logger.getLogger();
    private static final long serialVersionUID = -8016974810651763053L;
    private final Map<String, String> requestHeaders = new HashMap<String, String>();

    HttpClient(String httpProxyHost, int httpProxyPort, String httpProxyUser, String httpProxyPassword, boolean httpProxySocks, int httpRetryCount, int httpRetryIntervalSeconds, int httpConnectionTimeout, int httpReadTimeout, boolean prettyDebug, boolean gzipEnabled) {
        this.httpProxyHost = httpProxyHost;
        this.httpProxyPort = httpProxyPort;
        this.httpProxyUser = httpProxyUser;
        this.httpProxyPassword = httpProxyPassword;
        this.httpProxySocks = httpProxySocks;
        this.httpRetryCount = httpRetryCount;
        this.httpRetryIntervalSeconds = httpRetryIntervalSeconds;
        this.httpConnectionTimeout = httpConnectionTimeout;
        this.httpReadTimeout = httpReadTimeout;
        this.prettyDebug = prettyDebug;
        this.requestHeaders.put("X-Twitter-Client-Version", Version.getVersion());
        this.requestHeaders.put("X-Twitter-Client-URL", "https://twitter4j.org/en/twitter4j-" + Version.getVersion() + ".xml");
        this.requestHeaders.put("X-Twitter-Client", "Twitter4J");
        this.requestHeaders.put("User-Agent", "twitter4j https://twitter4j.org/ /" + Version.getVersion());
        if (gzipEnabled) {
            this.requestHeaders.put("Accept-Encoding", "gzip");
        }
    }

    private boolean isProxyConfigured() {
        return this.httpProxyHost != null && !this.httpProxyHost.equals("");
    }

    void write(DataOutputStream out, String outStr) throws IOException {
        out.writeBytes(outStr);
        logger.debug(outStr);
    }

    void addDefaultRequestHeader(String name, String value) {
        this.requestHeaders.put(name, value);
    }

    HttpResponse request(HttpRequest req) throws TwitterException {
        return this.handleRequest(req);
    }

    HttpResponse request(HttpRequest req, HttpResponseListener listener) throws TwitterException {
        try {
            HttpResponse res = this.handleRequest(req);
            if (listener != null) {
                listener.httpResponseReceived(new HttpResponseEvent(req, res, null));
            }
            return res;
        }
        catch (TwitterException te) {
            if (listener != null) {
                listener.httpResponseReceived(new HttpResponseEvent(req, null, te));
            }
            throw te;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpResponse handleRequest(HttpRequest req) throws TwitterException {
        int retry = this.httpRetryCount + 1;
        HttpResponse res = null;
        for (int retriedCount = 0; retriedCount < retry; ++retriedCount) {
            block29: {
                int responseCode = -1;
                try {
                    OutputStream os = null;
                    try {
                        HttpURLConnection con = this.getConnection(req.getURL());
                        con.setDoInput(true);
                        this.setHeaders(req, con);
                        con.setRequestMethod(req.getMethod().name());
                        if (req.getMethod() == RequestMethod.POST) {
                            if (HttpParameter.containsFile(req.getParameters())) {
                                String boundary = "----Twitter4J-upload" + System.currentTimeMillis();
                                con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                                boundary = "--" + boundary;
                                con.setDoOutput(true);
                                os = con.getOutputStream();
                                DataOutputStream out = new DataOutputStream(os);
                                for (HttpParameter param : req.getParameters()) {
                                    if (param.isFile()) {
                                        int length;
                                        this.write(out, boundary + "\r\n");
                                        this.write(out, "Content-Disposition: form-data; name=\"" + param.getName() + "\"; filename=\"" + param.getFile().getName() + "\"\r\n");
                                        this.write(out, "Content-Type: " + param.getContentType() + "\r\n\r\n");
                                        BufferedInputStream in = new BufferedInputStream(param.hasFileBody() ? param.getFileBody() : Files.newInputStream(param.getFile().toPath(), new OpenOption[0]));
                                        byte[] buff = new byte[1024];
                                        while ((length = in.read(buff)) != -1) {
                                            out.write(buff, 0, length);
                                        }
                                        this.write(out, "\r\n");
                                        in.close();
                                        continue;
                                    }
                                    this.write(out, boundary + "\r\n");
                                    this.write(out, "Content-Disposition: form-data; name=\"" + param.getName() + "\"\r\n");
                                    this.write(out, "Content-Type: text/plain; charset=UTF-8\r\n\r\n");
                                    logger.debug(param.getValue());
                                    out.write(param.getValue().getBytes(StandardCharsets.UTF_8));
                                    this.write(out, "\r\n");
                                }
                                this.write(out, boundary + "--\r\n");
                                this.write(out, "\r\n");
                            } else {
                                String postParam;
                                if (HttpParameter.containsJson(req.getParameters())) {
                                    con.setRequestProperty("Content-Type", "application/json");
                                    postParam = req.getParameters()[0].getJsonObject().toString();
                                } else {
                                    con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                                    postParam = HttpParameter.encodeParameters(req.getParameters());
                                }
                                logger.debug("Post Params: ", postParam);
                                byte[] bytes = postParam.getBytes(StandardCharsets.UTF_8);
                                con.setRequestProperty("Content-Length", Integer.toString(bytes.length));
                                con.setDoOutput(true);
                                os = con.getOutputStream();
                                os.write(bytes);
                            }
                            os.flush();
                            os.close();
                        }
                        res = new HttpResponse(con, this.prettyDebug);
                        responseCode = con.getResponseCode();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Response: ");
                            Map<String, List<String>> responseHeaders = con.getHeaderFields();
                            for (String key : responseHeaders.keySet()) {
                                List<String> values = responseHeaders.get(key);
                                for (String value : values) {
                                    if (key != null) {
                                        logger.debug(key + ": " + value);
                                        continue;
                                    }
                                    logger.debug(value);
                                }
                            }
                        }
                        if (responseCode >= 200 && (responseCode == 302 || 300 > responseCode)) break;
                        if (responseCode < 500 || retriedCount == this.httpRetryCount) {
                            throw new TwitterException(res.asString(), res);
                        }
                    }
                    finally {
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException ioe) {
                    if (retriedCount != this.httpRetryCount) break block29;
                    throw new TwitterException(ioe.getMessage(), ioe, responseCode);
                }
            }
            try {
                if (logger.isDebugEnabled() && res != null) {
                    res.asString();
                }
                logger.debug("Sleeping " + this.httpRetryIntervalSeconds + " seconds until the next retry.");
                Thread.sleep((long)this.httpRetryIntervalSeconds * 1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return res;
    }

    private void setHeaders(HttpRequest req, HttpURLConnection connection) {
        String authorizationHeader;
        if (logger.isDebugEnabled()) {
            logger.debug("Request: ");
            logger.debug(req.getMethod().name() + " ", req.getURL());
        }
        if (req.getAuthorization() != null && (authorizationHeader = req.getAuthorization().getAuthorizationHeader(req)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Authorization: ", authorizationHeader.replaceAll(".", "*"));
            }
            connection.addRequestProperty("Authorization", authorizationHeader);
        }
        if (req.getRequestHeaders() != null) {
            for (String key : req.getRequestHeaders().keySet()) {
                connection.addRequestProperty(key, req.getRequestHeaders().get(key));
                logger.debug(key + ": " + req.getRequestHeaders().get(key));
            }
        }
    }

    HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection con;
        if (this.isProxyConfigured()) {
            if (this.httpProxyUser != null && !this.httpProxyUser.equals("")) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Proxy AuthUser: " + this.httpProxyUser);
                    logger.debug("Proxy AuthPassword: " + this.httpProxyPassword.replaceAll(".", "*"));
                }
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                            return new PasswordAuthentication(HttpClient.this.httpProxyUser, HttpClient.this.httpProxyPassword.toCharArray());
                        }
                        return null;
                    }
                });
            }
            Proxy proxy = new Proxy(this.httpProxySocks ? Proxy.Type.SOCKS : Proxy.Type.HTTP, InetSocketAddress.createUnresolved(this.httpProxyHost, this.httpProxyPort));
            if (logger.isDebugEnabled()) {
                logger.debug("Opening proxied connection(" + this.httpProxyHost + ":" + this.httpProxyPort + ")");
            }
            con = (HttpURLConnection)new URL(url).openConnection(proxy);
        } else {
            con = (HttpURLConnection)new URL(url).openConnection();
        }
        if (this.httpConnectionTimeout > 0) {
            con.setConnectTimeout(this.httpConnectionTimeout);
        }
        if (this.httpReadTimeout > 0) {
            con.setReadTimeout(this.httpReadTimeout);
        }
        con.setInstanceFollowRedirects(false);
        return con;
    }

    HttpResponse get(String url, HttpParameter[] parameters, Authorization authorization, HttpResponseListener listener) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.GET, url, parameters, authorization, this.requestHeaders), listener);
    }

    HttpResponse get(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.GET, url, null, null, this.requestHeaders));
    }

    HttpResponse post(String url, HttpParameter[] parameters, Authorization authorization, HttpResponseListener listener) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, parameters, authorization, this.requestHeaders), listener);
    }

    HttpResponse post(String url, HttpParameter[] params) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, params, null, null));
    }

    HttpResponse post(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, null, null, this.requestHeaders));
    }

    HttpResponse delete(String url, HttpParameter[] parameters, Authorization authorization, HttpResponseListener listener) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, parameters, authorization, this.requestHeaders), listener);
    }

    HttpResponse delete(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, null, null, this.requestHeaders));
    }

    HttpResponse head(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, null, null, this.requestHeaders));
    }

    HttpResponse put(String url, HttpParameter[] parameters, Authorization authorization, HttpResponseListener listener) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, parameters, authorization, this.requestHeaders), listener);
    }

    HttpResponse put(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, null, null, this.requestHeaders));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClient that = (HttpClient)o;
        return this.httpProxyPort == that.httpProxyPort && this.httpProxySocks == that.httpProxySocks && this.httpRetryCount == that.httpRetryCount && this.httpRetryIntervalSeconds == that.httpRetryIntervalSeconds && this.httpConnectionTimeout == that.httpConnectionTimeout && this.httpReadTimeout == that.httpReadTimeout && this.prettyDebug == that.prettyDebug && Objects.equals(this.httpProxyHost, that.httpProxyHost) && Objects.equals(this.httpProxyUser, that.httpProxyUser) && Objects.equals(this.httpProxyPassword, that.httpProxyPassword) && Objects.equals(this.requestHeaders, that.requestHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.httpProxyHost, this.httpProxyPort, this.httpProxyUser, this.httpProxyPassword, this.httpProxySocks, this.httpRetryCount, this.httpRetryIntervalSeconds, this.httpConnectionTimeout, this.httpReadTimeout, this.prettyDebug, this.requestHeaders);
    }

    public String toString() {
        return "HttpClient{httpProxyHost='" + this.httpProxyHost + '\'' + ", httpProxyPort=" + this.httpProxyPort + ", httpProxyUser='" + this.httpProxyUser + '\'' + ", httpProxyPassword='" + this.httpProxyPassword + '\'' + ", httpProxySocks=" + this.httpProxySocks + ", httpRetryCount=" + this.httpRetryCount + ", httpRetryIntervalSeconds=" + this.httpRetryIntervalSeconds + ", httpConnectionTimeout=" + this.httpConnectionTimeout + ", httpReadTimeout=" + this.httpReadTimeout + ", prettyDebug=" + this.prettyDebug + ", requestHeaders=" + this.requestHeaders + '}';
    }
}

