/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.AttributeConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.FilterDef;
import org.hibernate.boot.model.internal.AnnotationHelper;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.usertype.UserType;

public class FilterDefBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(FilterDefBinder.class);

    public static void bindFilterDefs(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        ModelsContext modelsContext = context.getBootstrapContext().getModelsContext();
        annotatedElement.forEachAnnotationUsage(FilterDef.class, modelsContext, usage -> FilterDefBinder.bindFilterDef(usage, context));
    }

    public static void bindFilterDef(FilterDef filterDef, MetadataBuildingContext context) {
        Map<String, ManagedBean<Supplier<?>>> parameterResolvers;
        Map<String, JdbcMapping> paramJdbcMappings;
        String name = filterDef.name();
        if (context.getMetadataCollector().getFilterDefinition(name) != null) {
            throw new AnnotationException("Multiple '@FilterDef' annotations define a filter named '" + name + "'");
        }
        Object[] explicitParameters = filterDef.parameters();
        if (CollectionHelper.isEmpty(explicitParameters)) {
            paramJdbcMappings = Collections.emptyMap();
            parameterResolvers = Collections.emptyMap();
        } else {
            paramJdbcMappings = new HashMap();
            parameterResolvers = new HashMap();
            for (Object explicitParameter : explicitParameters) {
                String parameterName = explicitParameter.name();
                Class<?> typeClassDetails = explicitParameter.type();
                JdbcMapping jdbcMapping = FilterDefBinder.resolveFilterParamType(typeClassDetails, context);
                if (jdbcMapping == null) {
                    throw new MappingException(String.format(Locale.ROOT, "Unable to resolve type specified for parameter (%s) defined for @FilterDef (%s)", parameterName, name));
                }
                paramJdbcMappings.put(parameterName, jdbcMapping);
                Class<? extends Supplier> resolverClass = explicitParameter.resolver();
                if (Supplier.class.equals(resolverClass)) continue;
                parameterResolvers.put(explicitParameter.name(), FilterDefBinder.resolveParamResolver(resolverClass, context));
            }
        }
        FilterDefinition filterDefinition = new FilterDefinition(name, filterDef.defaultCondition(), filterDef.autoEnabled(), filterDef.applyToLoadByKey(), paramJdbcMappings, parameterResolvers);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Binding filter definition: " + filterDefinition.getFilterName());
        }
        context.getMetadataCollector().addFilterDefinition(filterDefinition);
    }

    private static ManagedBean<? extends Supplier<?>> resolveParamResolver(Class<? extends Supplier> resolverClass, MetadataBuildingContext context) {
        assert (resolverClass != Supplier.class);
        BootstrapContext bootstrapContext = context.getBootstrapContext();
        return bootstrapContext.getManagedBeanRegistry().getBean(resolverClass, bootstrapContext.getCustomTypeProducer());
    }

    public static JdbcMapping resolveFilterParamType(Class<?> type, MetadataBuildingContext context) {
        if (UserType.class.isAssignableFrom(type)) {
            return AnnotationHelper.resolveUserType(type, context);
        }
        if (AttributeConverter.class.isAssignableFrom(type)) {
            return AnnotationHelper.resolveAttributeConverter(type, context);
        }
        if (JavaType.class.isAssignableFrom(type)) {
            return AnnotationHelper.resolveJavaType(type, context);
        }
        return AnnotationHelper.resolveBasicType(type, context);
    }
}

