/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.JsonArrayAggFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonNullBehavior;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.type.spi.TypeConfiguration;

public class MariaDBJsonArrayAggFunction
extends JsonArrayAggFunction {
    public MariaDBJsonArrayAggFunction(TypeConfiguration typeConfiguration) {
        super(false, typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, List<SortSpecification> withinGroup, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        Expression arg;
        boolean caseWrapper = filter != null;
        sqlAppender.appendSql("concat('[',group_concat(");
        JsonNullBehavior nullBehavior = sqlAstArguments.size() > 1 ? (JsonNullBehavior)sqlAstArguments.get(1) : JsonNullBehavior.ABSENT;
        SqlAstNode firstArg = sqlAstArguments.get(0);
        if (firstArg instanceof Distinct) {
            Distinct distinct = (Distinct)firstArg;
            sqlAppender.appendSql("distinct ");
            arg = distinct.getExpression();
        } else {
            arg = (Expression)firstArg;
        }
        if (caseWrapper) {
            if (nullBehavior != JsonNullBehavior.ABSENT) {
                throw new QueryException("Can't emulate json_arrayagg filter clause when using 'null on null' clause.");
            }
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql("case when ");
            filter.accept(translator);
            translator.getCurrentClauseStack().pop();
            sqlAppender.appendSql(" then ");
            this.renderArgument(sqlAppender, arg, nullBehavior, translator);
            sqlAppender.appendSql(" else null end)");
        } else {
            this.renderArgument(sqlAppender, arg, nullBehavior, translator);
        }
        if (withinGroup != null && !withinGroup.isEmpty()) {
            translator.getCurrentClauseStack().push(Clause.WITHIN_GROUP);
            sqlAppender.appendSql(" order by ");
            withinGroup.get(0).accept(translator);
            for (int i = 1; i < withinGroup.size(); ++i) {
                sqlAppender.appendSql(',');
                withinGroup.get(i).accept(translator);
            }
            translator.getCurrentClauseStack().pop();
        }
        sqlAppender.appendSql(" separator ','),']')");
    }

    @Override
    protected void renderArgument(SqlAppender sqlAppender, Expression arg, JsonNullBehavior nullBehavior, SqlAstTranslator<?> translator) {
        if (nullBehavior != JsonNullBehavior.NULL) {
            sqlAppender.appendSql("nullif(");
        }
        sqlAppender.appendSql("json_extract(json_array(");
        arg.accept(translator);
        sqlAppender.appendSql("),'$[0]')");
        if (nullBehavior != JsonNullBehavior.NULL) {
            sqlAppender.appendSql(",'null')");
        }
    }
}

