/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.internal;

import jakarta.persistence.Timeout;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.lock.PessimisticLockStyle;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;

public class LockingSupportSimple
implements LockingSupport,
LockingSupport.Metadata {
    public static final LockingSupport STANDARD_SUPPORT = new LockingSupportSimple(PessimisticLockStyle.CLAUSE, LockTimeoutType.QUERY, OuterJoinLockingType.FULL, ConnectionLockTimeoutStrategy.NONE);
    public static final LockingSupport NO_OUTER_JOIN = new LockingSupportSimple(PessimisticLockStyle.CLAUSE, LockTimeoutType.QUERY, OuterJoinLockingType.UNSUPPORTED, ConnectionLockTimeoutStrategy.NONE);
    private final PessimisticLockStyle lockStyle;
    private final RowLockStrategy rowLockStrategy;
    private final LockTimeoutType lockTimeoutType;
    private final OuterJoinLockingType joinLockingType;
    private final ConnectionLockTimeoutStrategy connectionStrategy;

    public LockingSupportSimple(PessimisticLockStyle lockStyle, LockTimeoutType lockTimeoutType, OuterJoinLockingType joinLockingType, ConnectionLockTimeoutStrategy connectionStrategy) {
        this(lockStyle, RowLockStrategy.NONE, lockTimeoutType, joinLockingType, connectionStrategy);
    }

    public LockingSupportSimple(PessimisticLockStyle lockStyle, RowLockStrategy rowLockStrategy, LockTimeoutType lockTimeoutType, OuterJoinLockingType joinLockingType, ConnectionLockTimeoutStrategy connectionStrategy) {
        this.lockStyle = lockStyle;
        this.rowLockStrategy = rowLockStrategy;
        this.lockTimeoutType = lockTimeoutType;
        this.joinLockingType = joinLockingType;
        this.connectionStrategy = connectionStrategy;
    }

    @Override
    public LockingSupport.Metadata getMetadata() {
        return this;
    }

    @Override
    public PessimisticLockStyle getPessimisticLockStyle() {
        return this.lockStyle;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return this.rowLockStrategy;
    }

    @Override
    public LockTimeoutType getLockTimeoutType(Timeout timeout) {
        return this.lockTimeoutType;
    }

    @Override
    public OuterJoinLockingType getOuterJoinLockingType() {
        return this.joinLockingType;
    }

    @Override
    public ConnectionLockTimeoutStrategy getConnectionLockTimeoutStrategy() {
        return this.connectionStrategy;
    }
}

