/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.proxy.SerializableBlobProxy;
import org.hibernate.engine.jdbc.proxy.SerializableClobProxy;
import org.hibernate.engine.jdbc.proxy.SerializableNClobProxy;
import org.hibernate.engine.jdbc.proxy.WrappedBlob;
import org.hibernate.engine.jdbc.proxy.WrappedClob;
import org.hibernate.engine.jdbc.proxy.WrappedNClob;

public abstract class AbstractLobCreator
implements LobCreator {
    @Override
    public Blob wrap(Blob blob) {
        return SerializableBlobProxy.generateProxy(blob);
    }

    @Override
    public Clob wrap(Clob clob) {
        Clob clob2;
        if (clob instanceof NClob) {
            NClob nclob = (NClob)clob;
            clob2 = this.wrap(nclob);
        } else {
            clob2 = SerializableClobProxy.generateProxy(clob);
        }
        return clob2;
    }

    @Override
    public NClob wrap(NClob nclob) {
        return SerializableNClobProxy.generateProxy(nclob);
    }

    @Override
    public Blob toJdbcBlob(Blob blob) {
        if (blob instanceof WrappedBlob) {
            WrappedBlob wrappedBlob = (WrappedBlob)((Object)blob);
            blob = wrappedBlob.getWrappedBlob();
        }
        return blob;
    }

    @Override
    public Clob toJdbcClob(Clob clob) {
        if (clob instanceof WrappedClob) {
            WrappedClob wrappedClob = (WrappedClob)((Object)clob);
            clob = wrappedClob.getWrappedClob();
        }
        return clob;
    }

    @Override
    public NClob toJdbcNClob(NClob clob) {
        if (clob instanceof WrappedNClob) {
            WrappedNClob wrappedNClob = (WrappedNClob)((Object)clob);
            clob = wrappedNClob.getWrappedNClob();
        }
        return clob;
    }
}

