/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.SessionEventListener;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;

public class ContextualJdbcConnectionAccess
implements JdbcConnectionAccess,
Serializable {
    private final Object tenantIdentifier;
    private final SessionEventListener listener;
    private final MultiTenantConnectionProvider<Object> connectionProvider;
    private final SharedSessionContractImplementor session;

    public ContextualJdbcConnectionAccess(Object tenantIdentifier, SessionEventListener listener, MultiTenantConnectionProvider<Object> connectionProvider, SharedSessionContractImplementor session) {
        this.tenantIdentifier = tenantIdentifier;
        this.listener = listener;
        this.connectionProvider = connectionProvider;
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection obtainConnection() throws SQLException {
        if (this.tenantIdentifier == null) {
            throw new HibernateException("Tenant identifier required");
        }
        EventMonitor eventMonitor = this.session.getEventMonitor();
        DiagnosticEvent connectionAcquisitionEvent = eventMonitor.beginJdbcConnectionAcquisitionEvent();
        try {
            this.listener.jdbcConnectionAcquisitionStart();
            Connection connection = this.connectionProvider.getConnection(this.tenantIdentifier);
            return connection;
        }
        finally {
            eventMonitor.completeJdbcConnectionAcquisitionEvent(connectionAcquisitionEvent, this.session, this.tenantIdentifier);
            this.listener.jdbcConnectionAcquisitionEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(Connection connection) throws SQLException {
        if (this.tenantIdentifier == null) {
            throw new HibernateException("Tenant identifier required");
        }
        EventMonitor eventMonitor = this.session.getEventMonitor();
        DiagnosticEvent connectionReleaseEvent = eventMonitor.beginJdbcConnectionReleaseEvent();
        try {
            this.listener.jdbcConnectionReleaseStart();
            this.connectionProvider.releaseConnection(this.tenantIdentifier, connection);
        }
        finally {
            eventMonitor.completeJdbcConnectionReleaseEvent(connectionReleaseEvent, this.session, this.tenantIdentifier);
            this.listener.jdbcConnectionReleaseEnd();
        }
    }

    @Override
    public boolean supportsAggressiveRelease() {
        return this.connectionProvider.supportsAggressiveRelease();
    }
}

