/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.PersistenceException;
import jakarta.transaction.SystemException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.hibernate.AssertionFailure;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.SessionException;
import org.hibernate.StatelessSession;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.internal.PersistenceContexts;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.event.internal.DefaultInitializeCollectionEventListener;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.event.service.spi.EventListenerGroups;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PostUpsertEvent;
import org.hibernate.event.spi.PostUpsertEventListener;
import org.hibernate.event.spi.PreCollectionRecreateEvent;
import org.hibernate.event.spi.PreCollectionRecreateEventListener;
import org.hibernate.event.spi.PreCollectionRemoveEvent;
import org.hibernate.event.spi.PreCollectionRemoveEventListener;
import org.hibernate.event.spi.PreCollectionUpdateEvent;
import org.hibernate.event.spi.PreCollectionUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.event.spi.PreUpsertEvent;
import org.hibernate.event.spi.PreUpsertEventListener;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.loader.internal.CacheLoadHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.tuple.entity.EntityMetamodel;

public class StatelessSessionImpl
extends AbstractSharedSessionContract
implements StatelessSession {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(StatelessSessionImpl.class);
    public static final MultiIdLoadOptions MULTI_ID_LOAD_OPTIONS = new MultiLoadOptions();
    private final LoadQueryInfluencers influencers;
    private final PersistenceContext temporaryPersistenceContext;
    private final boolean connectionProvided;
    private final List<AfterTransactionCompletionProcess> afterCompletions = new ArrayList<AfterTransactionCompletionProcess>();
    private final EventListenerGroups eventListenerGroups;

    public StatelessSessionImpl(SessionFactoryImpl factory, SessionCreationOptions options) {
        super(factory, options);
        this.connectionProvided = options.getConnection() != null;
        this.temporaryPersistenceContext = PersistenceContexts.createPersistenceContext(this);
        this.influencers = new LoadQueryInfluencers(this.getFactory());
        this.eventListenerGroups = factory.getEventListenerGroups();
        this.setUpMultitenancy(factory, this.influencers);
        this.setJdbcBatchSize(0);
    }

    @Override
    public boolean shouldAutoJoinTransaction() {
        return true;
    }

    @Override
    public FlushMode getHibernateFlushMode() {
        return FlushMode.MANUAL;
    }

    @Override
    public Object insert(Object entity) {
        return this.insert(null, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertMultiple(List<?> entities) {
        Integer batchSize = this.getJdbcBatchSize();
        this.setJdbcBatchSize(entities.size());
        try {
            for (Object entity : entities) {
                this.insert(null, entity);
            }
        }
        finally {
            this.setJdbcBatchSize(batchSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object insert(String entityName, Object entity) {
        Object id;
        Generator generator;
        this.checkOpen();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object[] state = persister.getValues(entity);
        if (persister.isVersioned() && Versioning.seedVersion(entity, state, persister, this)) {
            persister.setValues(entity, state);
        }
        if ((generator = persister.getGenerator()).generatedBeforeExecution(entity, this)) {
            if (!generator.generatesOnInsert()) {
                throw new IdentifierGenerationException("Identifier generator must generate on insert");
            }
            Object currentValue = generator.allowAssignedIdentifiers() ? persister.getIdentifier(entity) : null;
            id = ((BeforeExecutionGenerator)generator).generate(this, entity, currentValue, EventType.INSERT);
            persister.setIdentifier(entity, id, this);
            if (this.firePreInsert(entity, id, state, persister)) {
                return id;
            }
            this.getInterceptor().onInsert(entity, id, state, persister.getPropertyNames(), persister.getPropertyTypes());
            EventMonitor eventMonitor = this.getEventMonitor();
            DiagnosticEvent event = eventMonitor.beginEntityInsertEvent();
            boolean success = false;
            try {
                persister.getInsertCoordinator().insert(entity, id, state, this);
                success = true;
            }
            finally {
                eventMonitor.completeEntityInsertEvent(event, id, persister.getEntityName(), success, this);
            }
        }
        if (generator.generatedOnExecution(entity, this)) {
            if (!generator.generatesOnInsert()) {
                throw new IdentifierGenerationException("Identifier generator must generate on insert");
            }
            if (this.firePreInsert(entity, null, state, persister)) {
                return null;
            }
            this.getInterceptor().onInsert(entity, null, state, persister.getPropertyNames(), persister.getPropertyTypes());
            EventMonitor eventMonitor = this.getEventMonitor();
            DiagnosticEvent event = eventMonitor.beginEntityInsertEvent();
            boolean success = false;
            Object generatedId = null;
            try {
                GeneratedValues generatedValues = persister.getInsertCoordinator().insert(entity, state, this);
                id = generatedId = NullnessUtil.castNonNull(generatedValues).getGeneratedValue(persister.getIdentifierMapping());
                success = true;
                eventMonitor.completeEntityInsertEvent(event, generatedId, persister.getEntityName(), success, this);
            }
            catch (Throwable throwable) {
                eventMonitor.completeEntityInsertEvent(event, generatedId, persister.getEntityName(), success, this);
                throw throwable;
            }
            persister.setIdentifier(entity, id, this);
        } else {
            id = persister.getIdentifier(entity, this);
            if (id == null) {
                throw new IdentifierGenerationException("Identifier of entity '" + persister.getEntityName() + "' must be manually assigned before calling 'insert()'");
            }
            if (this.firePreInsert(entity, id, state, persister)) {
                return id;
            }
            this.getInterceptor().onInsert(entity, id, state, persister.getPropertyNames(), persister.getPropertyTypes());
            EventMonitor eventMonitor = this.getEventMonitor();
            DiagnosticEvent event = eventMonitor.beginEntityInsertEvent();
            boolean success = false;
            try {
                persister.getInsertCoordinator().insert(entity, id, state, this);
                success = true;
            }
            finally {
                eventMonitor.completeEntityInsertEvent(event, id, persister.getEntityName(), success, this);
            }
        }
        this.recreateCollections(entity, id, persister);
        this.firePostInsert(entity, id, state, persister);
        StatisticsImplementor statistics = this.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled()) {
            statistics.insertEntity(persister.getEntityName());
        }
        return id;
    }

    private void recreateCollections(Object entity, Object id, EntityPersister persister) {
        if (persister.hasOwnedCollections()) {
            String entityName = persister.getEntityName();
            EventMonitor eventMonitor = this.getEventMonitor();
            StatisticsImplementor statistics = this.getFactory().getStatistics();
            this.forEachOwnedCollection(entity, id, persister, (descriptor, collection) -> {
                String role = descriptor.getRole();
                this.firePreRecreate((PersistentCollection<?>)collection, id, entityName, entity);
                DiagnosticEvent event = eventMonitor.beginCollectionRecreateEvent();
                boolean success = false;
                try {
                    descriptor.recreate((PersistentCollection<?>)collection, id, this);
                    success = true;
                }
                finally {
                    eventMonitor.completeCollectionRecreateEvent(event, id, role, success, this);
                }
                if (statistics.isStatisticsEnabled()) {
                    statistics.recreateCollection(role);
                }
                this.firePostRecreate((PersistentCollection<?>)collection, id, entityName, entity);
            });
        }
    }

    @Override
    public void delete(Object entity) {
        this.delete(null, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMultiple(List<?> entities) {
        Integer batchSize = this.getJdbcBatchSize();
        this.setJdbcBatchSize(entities.size());
        try {
            for (Object entity : entities) {
                this.delete(null, entity);
            }
        }
        finally {
            this.setJdbcBatchSize(batchSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String entityName, Object entity) {
        this.checkOpen();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object id = persister.getIdentifier(entity, this);
        Object version = persister.getVersion(entity);
        if (!this.firePreDelete(entity, id, persister)) {
            this.getInterceptor().onDelete(entity, id, persister.getPropertyNames(), persister.getPropertyTypes());
            this.removeCollections(entity, id, persister);
            Object ck = this.lockCacheItem(id, version, persister);
            EventMonitor eventMonitor = this.getEventMonitor();
            DiagnosticEvent event = eventMonitor.beginEntityDeleteEvent();
            boolean success = false;
            try {
                persister.getDeleteCoordinator().delete(entity, id, version, this);
                success = true;
            }
            finally {
                eventMonitor.completeEntityDeleteEvent(event, id, persister.getEntityName(), success, this);
            }
            this.removeCacheItem(ck, persister);
            this.firePostDelete(entity, id, persister);
            StatisticsImplementor statistics = this.getFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.deleteEntity(persister.getEntityName());
            }
        }
    }

    private void removeCollections(Object entity, Object id, EntityPersister persister) {
        if (persister.hasOwnedCollections()) {
            String entityName = persister.getEntityName();
            EventMonitor eventMonitor = this.getEventMonitor();
            StatisticsImplementor statistics = this.getFactory().getStatistics();
            this.forEachOwnedCollection(entity, id, persister, (descriptor, collection) -> {
                String role = descriptor.getRole();
                this.firePreRemove((PersistentCollection<?>)collection, id, entityName, entity);
                DiagnosticEvent event = eventMonitor.beginCollectionRemoveEvent();
                boolean success = false;
                try {
                    descriptor.remove(id, this);
                    success = true;
                }
                finally {
                    eventMonitor.completeCollectionRemoveEvent(event, id, role, success, this);
                }
                this.firePostRemove((PersistentCollection<?>)collection, id, entityName, entity);
                if (statistics.isStatisticsEnabled()) {
                    statistics.removeCollection(role);
                }
            });
        }
    }

    @Override
    public void update(Object entity) {
        this.update(null, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMultiple(List<?> entities) {
        Integer batchSize = this.getJdbcBatchSize();
        this.setJdbcBatchSize(entities.size());
        try {
            for (Object entity : entities) {
                this.update(null, entity);
            }
        }
        finally {
            this.setJdbcBatchSize(batchSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String entityName, Object entity) {
        Object oldVersion;
        this.checkOpen();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object id = persister.getIdentifier(entity, this);
        Object[] state = persister.getValues(entity);
        if (persister.isVersioned()) {
            oldVersion = persister.getVersion(entity);
            Object newVersion = Versioning.incrementVersion(entity, oldVersion, persister, this);
            Versioning.setVersion(state, newVersion, persister);
            persister.setValues(entity, state);
        } else {
            oldVersion = null;
        }
        if (!this.firePreUpdate(entity, id, state, persister)) {
            this.getInterceptor().onUpdate(entity, id, state, persister.getPropertyNames(), persister.getPropertyTypes());
            Object ck = this.lockCacheItem(id, oldVersion, persister);
            EventMonitor eventMonitor = this.getEventMonitor();
            DiagnosticEvent event = eventMonitor.beginEntityUpdateEvent();
            boolean success = false;
            try {
                persister.getUpdateCoordinator().update(entity, id, null, state, oldVersion, null, null, false, this);
                success = true;
            }
            finally {
                eventMonitor.completeEntityUpdateEvent(event, id, persister.getEntityName(), success, this);
            }
            this.removeCacheItem(ck, persister);
            this.removeAndRecreateCollections(entity, id, persister);
            this.firePostUpdate(entity, id, state, persister);
            StatisticsImplementor statistics = this.getFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.updateEntity(persister.getEntityName());
            }
        }
    }

    private void removeAndRecreateCollections(Object entity, Object id, EntityPersister persister) {
        if (persister.hasOwnedCollections()) {
            String entityName = persister.getEntityName();
            EventMonitor eventMonitor = this.getEventMonitor();
            StatisticsImplementor statistics = this.getFactory().getStatistics();
            this.forEachOwnedCollection(entity, id, persister, (descriptor, collection) -> {
                String role = descriptor.getRole();
                this.firePreUpdate((PersistentCollection<?>)collection, id, entityName, entity);
                DiagnosticEvent event = eventMonitor.beginCollectionRemoveEvent();
                boolean success = false;
                try {
                    descriptor.remove(id, this);
                    descriptor.recreate((PersistentCollection<?>)collection, id, this);
                    success = true;
                }
                finally {
                    eventMonitor.completeCollectionRemoveEvent(event, id, role, success, this);
                }
                this.firePostUpdate((PersistentCollection<?>)collection, id, entityName, entity);
                if (statistics.isStatisticsEnabled()) {
                    statistics.updateCollection(role);
                }
            });
        }
    }

    @Override
    public void upsert(Object entity) {
        this.upsert(null, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upsertMultiple(List<?> entities) {
        Integer batchSize = this.getJdbcBatchSize();
        this.setJdbcBatchSize(entities.size());
        try {
            for (Object entity : entities) {
                this.upsert(null, entity);
            }
        }
        finally {
            this.setJdbcBatchSize(batchSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upsert(String entityName, Object entity) {
        this.checkOpen();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object id = this.idToUpsert(entity, persister);
        Object[] state = persister.getValues(entity);
        if (!this.firePreUpsert(entity, id, state, persister)) {
            this.getInterceptor().onUpsert(entity, id, state, persister.getPropertyNames(), persister.getPropertyTypes());
            Object oldVersion = this.versionToUpsert(entity, persister, state);
            Object ck = this.lockCacheItem(id, oldVersion, persister);
            EventMonitor eventMonitor = this.getEventMonitor();
            DiagnosticEvent event = eventMonitor.beginEntityUpsertEvent();
            boolean success = false;
            try {
                persister.getMergeCoordinator().update(entity, id, null, state, oldVersion, null, null, false, this);
                success = true;
            }
            finally {
                eventMonitor.completeEntityUpsertEvent(event, id, persister.getEntityName(), success, this);
            }
            this.removeCacheItem(ck, persister);
            StatisticsImplementor statistics = this.getFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.upsertEntity(persister.getEntityName());
            }
            this.removeAndRecreateCollections(entity, id, persister);
            this.firePostUpsert(entity, id, state, persister);
        }
    }

    protected Object versionToUpsert(Object entity, EntityPersister persister, Object[] state) {
        if (persister.isVersioned()) {
            Object oldVersion = persister.getVersion(entity);
            Boolean knownTransient = persister.getVersionMapping().getUnsavedStrategy().isUnsaved(oldVersion);
            if (knownTransient != null && knownTransient.booleanValue()) {
                if (Versioning.seedVersion(entity, state, persister, this)) {
                    persister.setValues(entity, state);
                }
                return state[persister.getVersionProperty()];
            }
            Object newVersion = Versioning.incrementVersion(entity, oldVersion, persister, this);
            Versioning.setVersion(state, newVersion, persister);
            persister.setValues(entity, state);
            return oldVersion;
        }
        return null;
    }

    protected Object idToUpsert(Object entity, EntityPersister persister) {
        Object id = persister.getIdentifier(entity, this);
        Boolean unsaved = persister.getIdentifierMapping().getUnsavedStrategy().isUnsaved(id);
        if (unsaved != null && unsaved.booleanValue()) {
            throw new TransientObjectException("Object passed to upsert() has an unsaved identifier value: " + persister.getEntityName());
        }
        return id;
    }

    protected boolean firePreInsert(Object entity, Object id, Object[] state, EntityPersister persister) {
        if (this.eventListenerGroups.eventListenerGroup_PRE_INSERT.isEmpty()) {
            return false;
        }
        boolean veto = false;
        PreInsertEvent event = new PreInsertEvent(entity, id, state, persister, null);
        for (PreInsertEventListener listener : this.eventListenerGroups.eventListenerGroup_PRE_INSERT.listeners()) {
            veto |= listener.onPreInsert(event);
        }
        return veto;
    }

    protected boolean firePreUpdate(Object entity, Object id, Object[] state, EntityPersister persister) {
        if (this.eventListenerGroups.eventListenerGroup_PRE_UPDATE.isEmpty()) {
            return false;
        }
        boolean veto = false;
        PreUpdateEvent event = new PreUpdateEvent(entity, id, state, null, persister, null);
        for (PreUpdateEventListener listener : this.eventListenerGroups.eventListenerGroup_PRE_UPDATE.listeners()) {
            veto |= listener.onPreUpdate(event);
        }
        return veto;
    }

    protected boolean firePreUpsert(Object entity, Object id, Object[] state, EntityPersister persister) {
        if (this.eventListenerGroups.eventListenerGroup_PRE_UPSERT.isEmpty()) {
            return false;
        }
        boolean veto = false;
        PreUpsertEvent event = new PreUpsertEvent(entity, id, state, persister, null);
        for (PreUpsertEventListener listener : this.eventListenerGroups.eventListenerGroup_PRE_UPSERT.listeners()) {
            veto |= listener.onPreUpsert(event);
        }
        return veto;
    }

    protected boolean firePreDelete(Object entity, Object id, EntityPersister persister) {
        if (this.eventListenerGroups.eventListenerGroup_PRE_DELETE.isEmpty()) {
            return false;
        }
        boolean veto = false;
        PreDeleteEvent event = new PreDeleteEvent(entity, id, null, persister, null);
        for (PreDeleteEventListener listener : this.eventListenerGroups.eventListenerGroup_PRE_DELETE.listeners()) {
            veto |= listener.onPreDelete(event);
        }
        return veto;
    }

    protected void firePostInsert(Object entity, Object id, Object[] state, EntityPersister persister) {
        this.eventListenerGroups.eventListenerGroup_POST_INSERT.fireLazyEventOnEachListener(() -> new PostInsertEvent(entity, id, state, persister, null), PostInsertEventListener::onPostInsert);
    }

    protected void firePostUpdate(Object entity, Object id, Object[] state, EntityPersister persister) {
        this.eventListenerGroups.eventListenerGroup_POST_UPDATE.fireLazyEventOnEachListener(() -> new PostUpdateEvent(entity, id, state, null, null, persister, null), PostUpdateEventListener::onPostUpdate);
    }

    protected void firePostUpsert(Object entity, Object id, Object[] state, EntityPersister persister) {
        this.eventListenerGroups.eventListenerGroup_POST_UPSERT.fireLazyEventOnEachListener(() -> new PostUpsertEvent(entity, id, state, null, persister, null), PostUpsertEventListener::onPostUpsert);
    }

    protected void firePostDelete(Object entity, Object id, EntityPersister persister) {
        this.eventListenerGroups.eventListenerGroup_POST_DELETE.fireLazyEventOnEachListener(() -> new PostDeleteEvent(entity, id, null, persister, null), PostDeleteEventListener::onPostDelete);
    }

    protected void firePreRecreate(PersistentCollection<?> collection, Object id, String entityName, Object owner) {
        this.eventListenerGroups.eventListenerGroup_PRE_COLLECTION_RECREATE.fireLazyEventOnEachListener(() -> new PreCollectionRecreateEvent(collection, id, entityName, owner), PreCollectionRecreateEventListener::onPreRecreateCollection);
    }

    protected void firePreUpdate(PersistentCollection<?> collection, Object id, String entityName, Object owner) {
        this.eventListenerGroups.eventListenerGroup_PRE_COLLECTION_UPDATE.fireLazyEventOnEachListener(() -> new PreCollectionUpdateEvent(collection, id, entityName, owner), PreCollectionUpdateEventListener::onPreUpdateCollection);
    }

    protected void firePreRemove(PersistentCollection<?> collection, Object id, String entityName, Object owner) {
        this.eventListenerGroups.eventListenerGroup_PRE_COLLECTION_REMOVE.fireLazyEventOnEachListener(() -> new PreCollectionRemoveEvent(collection, id, entityName, owner), PreCollectionRemoveEventListener::onPreRemoveCollection);
    }

    protected void firePostRecreate(PersistentCollection<?> collection, Object id, String entityName, Object owner) {
        this.eventListenerGroups.eventListenerGroup_POST_COLLECTION_RECREATE.fireLazyEventOnEachListener(() -> new PostCollectionRecreateEvent(collection, id, entityName, owner), PostCollectionRecreateEventListener::onPostRecreateCollection);
    }

    protected void firePostUpdate(PersistentCollection<?> collection, Object id, String entityName, Object owner) {
        this.eventListenerGroups.eventListenerGroup_POST_COLLECTION_UPDATE.fireLazyEventOnEachListener(() -> new PostCollectionUpdateEvent(collection, id, entityName, owner), PostCollectionUpdateEventListener::onPostUpdateCollection);
    }

    protected void firePostRemove(PersistentCollection<?> collection, Object id, String entityName, Object owner) {
        this.eventListenerGroups.eventListenerGroup_POST_COLLECTION_REMOVE.fireLazyEventOnEachListener(() -> new PostCollectionRemoveEvent(collection, id, entityName, owner), PostCollectionRemoveEventListener::onPostRemoveCollection);
    }

    protected void forEachOwnedCollection(Object entity, Object key, EntityPersister persister, BiConsumer<CollectionPersister, PersistentCollection<?>> action) {
        persister.visitAttributeMappings(attribute -> {
            if (attribute.isPluralAttributeMapping()) {
                CollectionPersister descriptor = attribute.asPluralAttributeMapping().getCollectionDescriptor();
                Object ck = this.lockCacheItem(key, descriptor);
                if (!descriptor.isInverse()) {
                    PersistentCollection<Object> collection;
                    Object value = attribute.getPropertyAccess().getGetter().get(entity);
                    if (value instanceof PersistentCollection) {
                        PersistentCollection<Object> persistentCollection = (PersistentCollection<Object>)value;
                        if (!persistentCollection.wasInitialized()) {
                            return;
                        }
                        collection = persistentCollection;
                    } else {
                        collection = value == null ? this.instantiateEmpty(key, descriptor) : this.wrap(descriptor, value);
                    }
                    action.accept(descriptor, collection);
                }
                this.removeCacheItem(ck, descriptor);
            }
        });
    }

    protected PersistentCollection<?> instantiateEmpty(Object key, CollectionPersister descriptor) {
        return descriptor.getCollectionSemantics().instantiateWrapper(key, descriptor, this);
    }

    protected PersistentCollection<?> wrap(CollectionPersister descriptor, Object collection) {
        CollectionSemantics<?, ?> collectionSemantics = descriptor.getCollectionSemantics();
        return collectionSemantics.wrap(collection, descriptor, this);
    }

    @Override
    public <T> T get(Class<T> entityClass, Object id) {
        return (T)this.get(entityClass.getName(), id);
    }

    @Override
    public <T> T get(Class<T> entityClass, Object id, LockMode lockMode) {
        return (T)this.get(entityClass.getName(), id, lockMode);
    }

    @Override
    public Object get(String entityName, Object id) {
        return this.get(entityName, id, LockMode.NONE);
    }

    @Override
    public Object get(String entityName, Object id, LockMode lockMode) {
        Object cachedEntity;
        this.checkOpen();
        EntityPersister persister = this.requireEntityPersister(entityName);
        if (persister.canReadFromCache() && (cachedEntity = this.loadFromSecondLevelCache(persister, this.generateEntityKey(id, persister), null, lockMode)) != null) {
            this.temporaryPersistenceContext.clear();
            return cachedEntity;
        }
        Object result = persister.load(id, null, this.getNullSafeLockMode(lockMode), (SharedSessionContractImplementor)this);
        if (this.temporaryPersistenceContext.isLoadFinished()) {
            this.temporaryPersistenceContext.clear();
        }
        return result;
    }

    @Override
    public <T> T get(EntityGraph<T> graph, Object id) {
        return this.get(graph, GraphSemantic.LOAD, id);
    }

    @Override
    public <T> T get(EntityGraph<T> graph, Object id, LockMode lockMode) {
        return this.get(graph, GraphSemantic.LOAD, id, lockMode);
    }

    @Override
    public <T> T get(EntityGraph<T> graph, GraphSemantic graphSemantic, Object id) {
        return this.get(graph, graphSemantic, id, LockMode.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(EntityGraph<T> graph, GraphSemantic graphSemantic, Object id, LockMode lockMode) {
        RootGraphImplementor rootGraph = (RootGraphImplementor)graph;
        this.checkOpen();
        EffectiveEntityGraph effectiveEntityGraph = this.getLoadQueryInfluencers().getEffectiveEntityGraph();
        effectiveEntityGraph.applyGraph(rootGraph, graphSemantic);
        try {
            Object object = this.get(rootGraph.getGraphedType().getTypeName(), id, lockMode);
            return (T)object;
        }
        finally {
            effectiveEntityGraph.clear();
        }
    }

    @Override
    public <T> List<T> getMultiple(Class<T> entityClass, List<?> ids, LockMode lockMode) {
        for (Object id : ids) {
            if (id != null) continue;
            throw new IllegalArgumentException("Null id");
        }
        EntityPersister persister = this.requireEntityPersister(entityClass.getName());
        List<?> results = persister.multiLoad(ids.toArray(), this, (MultiIdLoadOptions)new MultiLoadOptions(lockMode));
        return results;
    }

    @Override
    public <T> List<T> getMultiple(EntityGraph<T> entityGraph, List<?> ids) {
        return this.getMultiple(entityGraph, GraphSemantic.LOAD, ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getMultiple(EntityGraph<T> entityGraph, GraphSemantic graphSemantic, List<?> ids) {
        for (Object id : ids) {
            if (id != null) continue;
            throw new IllegalArgumentException("Null id");
        }
        RootGraphImplementor rootGraph = (RootGraphImplementor)entityGraph;
        EffectiveEntityGraph effectiveEntityGraph = this.getLoadQueryInfluencers().getEffectiveEntityGraph();
        effectiveEntityGraph.applyGraph(rootGraph, graphSemantic);
        try {
            List<?> results;
            EntityPersister persister = this.requireEntityPersister(rootGraph.getGraphedType().getTypeName());
            List<?> list = results = persister.multiLoad(ids.toArray(), this, MULTI_ID_LOAD_OPTIONS);
            return list;
        }
        finally {
            effectiveEntityGraph.clear();
        }
    }

    @Override
    public <T> List<T> getMultiple(Class<T> entityClass, List<?> ids) {
        for (Object id : ids) {
            if (id != null) continue;
            throw new IllegalArgumentException("Null id");
        }
        EntityPersister persister = this.requireEntityPersister(entityClass.getName());
        List<?> results = persister.multiLoad(ids.toArray(), this, MULTI_ID_LOAD_OPTIONS);
        return results;
    }

    @Override
    public void refresh(Object entity) {
        this.refresh(this.bestGuessEntityName(entity), entity, LockMode.NONE);
    }

    @Override
    public void refresh(String entityName, Object entity) {
        this.refresh(entityName, entity, LockMode.NONE);
    }

    @Override
    public void refresh(Object entity, LockMode lockMode) {
        this.refresh(this.bestGuessEntityName(entity), entity, lockMode);
    }

    @Override
    public void refresh(String entityName, Object entity, LockMode lockMode) {
        EntityDataAccess cacheAccess;
        this.checkOpen();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object id = persister.getIdentifier(entity, this);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Refreshing transient {0}", MessageHelper.infoString(persister, id, this.getFactory()));
        }
        if (persister.canWriteToCache() && (cacheAccess = persister.getCacheAccessStrategy()) != null) {
            Object ck = cacheAccess.generateCacheKey(id, persister, this.getFactory(), this.getTenantIdentifier());
            cacheAccess.evict(ck);
        }
        Object result = this.getLoadQueryInfluencers().fromInternalFetchProfile(CascadingFetchProfile.REFRESH, () -> persister.load(id, entity, this.getNullSafeLockMode(lockMode), (SharedSessionContractImplementor)this));
        UnresolvableObjectException.throwIfNull(result, id, persister.getEntityName());
        if (this.temporaryPersistenceContext.isLoadFinished()) {
            this.temporaryPersistenceContext.clear();
        }
    }

    @Override
    public Object immediateLoad(String entityName, Object id) {
        if (this.getPersistenceContextInternal().isLoadFinished()) {
            throw new SessionException("proxies cannot be fetched by a stateless session");
        }
        return this.get(entityName, id);
    }

    @Override
    public void initializeCollection(PersistentCollection<?> collection, boolean writing) {
        this.checkOpen();
        PersistenceContext persistenceContext = this.getPersistenceContextInternal();
        CollectionEntry ce = persistenceContext.getCollectionEntry(collection);
        if (ce == null) {
            throw new HibernateException("no entry for collection");
        }
        if (!collection.wasInitialized()) {
            boolean foundInCache;
            CollectionPersister loadedPersister = ce.getLoadedPersister();
            Object loadedKey = ce.getLoadedKey();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Initializing collection " + MessageHelper.collectionInfoString(loadedPersister, collection, loadedKey, this));
            }
            if (foundInCache = CacheLoadHelper.initializeCollectionFromCache(loadedKey, loadedPersister, collection, this)) {
                LOG.trace("Collection initialized from cache");
            } else {
                loadedPersister.initialize(loadedKey, this);
                DefaultInitializeCollectionEventListener.handlePotentiallyEmptyCollection(collection, persistenceContext, loadedKey, loadedPersister);
                LOG.trace("Collection initialized");
                StatisticsImplementor statistics = this.getFactory().getStatistics();
                if (statistics.isStatisticsEnabled()) {
                    statistics.fetchCollection(loadedPersister.getRole());
                }
            }
        }
    }

    @Override
    @Deprecated
    public Object instantiate(String entityName, Object id) {
        return this.instantiate(this.requireEntityPersister(entityName), id);
    }

    @Override
    public Object instantiate(EntityPersister persister, Object id) {
        this.checkOpen();
        return persister.instantiate(id, this);
    }

    @Override
    public Object internalLoad(String entityName, Object id, boolean eager, boolean nullable) {
        this.checkOpen();
        EntityPersister persister = this.requireEntityPersister(entityName);
        EntityKey entityKey = this.generateEntityKey(id, persister);
        PersistenceContext persistenceContext = this.getPersistenceContext();
        EntityHolder holder = persistenceContext.getEntityHolder(entityKey);
        if (holder != null && holder.getEntity() != null) {
            return holder.getEntity();
        }
        if (!eager) {
            EntityMetamodel entityMetamodel = persister.getEntityMetamodel();
            BytecodeEnhancementMetadata enhancementMetadata = entityMetamodel.getBytecodeEnhancementMetadata();
            if (enhancementMetadata.isEnhancedForLazyLoading()) {
                if (persister.getRepresentationStrategy().getProxyFactory() != null) {
                    Object proxy;
                    Object object = proxy = holder == null ? null : holder.getProxy();
                    if (proxy != null) {
                        LOG.trace("Entity proxy found in session cache");
                        if (LOG.isDebugEnabled() && HibernateProxy.extractLazyInitializer(proxy).isUnwrap()) {
                            LOG.debug("Ignoring NO_PROXY to honor laziness");
                        }
                        return persistenceContext.narrowProxy(proxy, persister, entityKey, null);
                    }
                    if (entityMetamodel.hasSubclasses()) {
                        LOG.trace("Creating a HibernateProxy for to-one association with subclasses to honor laziness");
                        return this.createProxy(entityKey);
                    }
                    return enhancementMetadata.createEnhancedProxy(entityKey, false, this);
                }
                if (!entityMetamodel.hasSubclasses()) {
                    return enhancementMetadata.createEnhancedProxy(entityKey, false, this);
                }
            } else if (persister.hasProxy()) {
                Object existingProxy;
                Object object = existingProxy = holder == null ? null : holder.getProxy();
                if (existingProxy != null) {
                    return persistenceContext.narrowProxy(existingProxy, persister, entityKey, null);
                }
                return this.createProxy(entityKey);
            }
        }
        return this.internalLoadGet(entityName, id, persistenceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalLoadGet(String entityName, Object id, PersistenceContext persistenceContext) {
        persistenceContext.beforeLoad();
        try {
            Object object = this.get(entityName, id);
            return object;
        }
        finally {
            persistenceContext.afterLoad();
        }
    }

    private Object createProxy(EntityKey entityKey) {
        Object proxy = entityKey.getPersister().createProxy(entityKey.getIdentifier(), this);
        this.getPersistenceContext().addProxy(entityKey, proxy);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetch(Object association) {
        PersistentCollection collection;
        this.checkOpen();
        PersistenceContext persistenceContext = this.getPersistenceContext();
        LazyInitializer initializer = HibernateProxy.extractLazyInitializer(association);
        if (initializer != null) {
            if (initializer.isUninitialized()) {
                String entityName = initializer.getEntityName();
                Object id = initializer.getInternalIdentifier();
                initializer.setSession(this);
                persistenceContext.beforeLoad();
                try {
                    Object entity = initializer.getImplementation();
                    if (entity == null) {
                        this.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(entityName, id);
                    }
                    initializer.setImplementation(entity);
                }
                finally {
                    initializer.unsetSession();
                    persistenceContext.afterLoad();
                    if (persistenceContext.isLoadFinished()) {
                        persistenceContext.clear();
                    }
                }
            }
        } else if (ManagedTypeHelper.isPersistentAttributeInterceptable(association)) {
            PersistentAttributeInterceptor id = ManagedTypeHelper.asPersistentAttributeInterceptable(association).$$_hibernate_getInterceptor();
            if (id instanceof EnhancementAsProxyLazinessInterceptor) {
                EnhancementAsProxyLazinessInterceptor proxyInterceptor = (EnhancementAsProxyLazinessInterceptor)id;
                proxyInterceptor.setSession(this);
                try {
                    proxyInterceptor.forceInitialize(association, null);
                }
                finally {
                    proxyInterceptor.unsetSession();
                    if (persistenceContext.isLoadFinished()) {
                        persistenceContext.clear();
                    }
                }
            }
        } else if (association instanceof PersistentCollection && !(collection = (PersistentCollection)association).wasInitialized()) {
            CollectionPersister collectionDescriptor = this.requireCollectionPersister(collection.getRole());
            Object key = collection.getKey();
            persistenceContext.addUninitializedCollection(collectionDescriptor, collection, key);
            collection.setCurrentSession(this);
            try {
                boolean foundInCache = CacheLoadHelper.initializeCollectionFromCache(key, collectionDescriptor, collection, this);
                if (foundInCache) {
                    LOG.trace("Collection fetched from cache");
                } else {
                    collectionDescriptor.initialize(key, this);
                    DefaultInitializeCollectionEventListener.handlePotentiallyEmptyCollection(collection, this.getPersistenceContextInternal(), key, collectionDescriptor);
                    LOG.trace("Collection fetched");
                    StatisticsImplementor statistics = this.getFactory().getStatistics();
                    if (statistics.isStatisticsEnabled()) {
                        statistics.fetchCollection(collectionDescriptor.getRole());
                    }
                }
            }
            finally {
                collection.$$_hibernate_setInstanceId(0);
                collection.unsetSession(this);
                if (persistenceContext.isLoadFinished()) {
                    persistenceContext.clear();
                }
            }
        }
    }

    @Override
    public Object getIdentifier(Object entity) {
        this.checkOpen();
        return this.getFactory().getPersistenceUnitUtil().getIdentifier(entity);
    }

    public boolean isAutoCloseSessionEnabled() {
        return this.getSessionFactoryOptions().isAutoCloseSessionEnabled();
    }

    public boolean shouldAutoClose() {
        return this.isAutoCloseSessionEnabled() && !this.isClosed();
    }

    private boolean isFlushModeNever() {
        return false;
    }

    private void managedClose() {
        if (this.isClosed()) {
            throw new SessionException("Session was already closed");
        }
        this.close();
    }

    private void managedFlush() {
        this.checkOpen();
        this.getJdbcCoordinator().executeBatch();
    }

    @Override
    public String bestGuessEntityName(Object object) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            object = lazyInitializer.getImplementation();
        }
        return this.guessEntityName(object);
    }

    @Override
    public Object getContextEntityIdentifier(Object object) {
        this.checkOpen();
        return null;
    }

    @Override
    public String guessEntityName(Object entity) {
        this.checkOpen();
        if (entity == null) {
            throw new IllegalArgumentException("Entity may not be null");
        }
        return entity.getClass().getName();
    }

    @Override
    public EntityPersister getEntityPersister(String entityName, Object entity) {
        this.checkOpen();
        if (entity == null) {
            throw new IllegalArgumentException("Entity may not be null");
        }
        return entityName == null ? this.requireEntityPersister(this.guessEntityName(entity)) : this.requireEntityPersister(entityName).getSubclassEntityPersister(entity, this.getFactory());
    }

    @Override
    public Object getEntityUsingInterceptor(EntityKey key) {
        this.checkOpen();
        PersistenceContext persistenceContext = this.getPersistenceContext();
        Object result = persistenceContext.getEntity(key);
        if (result != null) {
            return result;
        }
        Object newObject = this.getInterceptor().getEntity(key.getEntityName(), key.getIdentifier());
        if (newObject != null) {
            persistenceContext.addEntity(key, newObject);
            return newObject;
        }
        return null;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.temporaryPersistenceContext;
    }

    @Override
    public boolean isDefaultReadOnly() {
        return false;
    }

    @Override
    public boolean isIdentifierRollbackEnabled() {
        return false;
    }

    @Override
    public void afterOperation(boolean success) {
        this.temporaryPersistenceContext.clear();
        if (!this.isTransactionInProgress()) {
            this.getJdbcCoordinator().afterTransaction();
        }
    }

    @Override
    public void afterScrollOperation() {
        this.temporaryPersistenceContext.clear();
    }

    @Override
    public void autoPreFlush() {
    }

    @Override
    public void flush() {
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.influencers;
    }

    @Override
    public PersistenceContext getPersistenceContextInternal() {
        return this.temporaryPersistenceContext;
    }

    @Override
    public boolean autoFlushIfRequired(Set<String> querySpaces, boolean skipPreFlush) {
        return false;
    }

    @Override
    public void afterTransactionBegin() {
        this.afterTransactionBeginEvents();
    }

    @Override
    public void beforeTransactionCompletion() {
        this.flushBeforeTransactionCompletion();
        this.beforeTransactionCompletionEvents();
    }

    @Override
    public void afterTransactionCompletion(boolean successful, boolean delayed) {
        this.processAfterCompletions(successful);
        this.afterTransactionCompletionEvents(successful);
        if (this.shouldAutoClose() && !this.isClosed()) {
            this.managedClose();
        }
    }

    private void processAfterCompletions(boolean successful) {
        for (AfterTransactionCompletionProcess completion : this.afterCompletions) {
            try {
                completion.doAfterTransactionCompletion(successful, this);
            }
            catch (CacheException ce) {
                LOG.unableToReleaseCacheLock(ce);
            }
            catch (Exception e) {
                throw new HibernateException("Unable to perform afterTransactionCompletion callback: " + e.getMessage(), e);
            }
        }
        this.afterCompletions.clear();
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.connectionProvided || super.isTransactionInProgress();
    }

    @Override
    public void flushBeforeTransactionCompletion() {
        boolean flush;
        try {
            flush = !this.isClosed() && !this.isFlushModeNever() && !JtaStatusHelper.isRollback(this.getJtaPlatform().getCurrentStatus());
        }
        catch (SystemException se) {
            throw new HibernateException("could not determine transaction status in beforeCompletion()", se);
        }
        if (flush) {
            this.managedFlush();
        }
    }

    private JtaPlatform getJtaPlatform() {
        return this.getFactory().getServiceRegistry().requireService(JtaPlatform.class);
    }

    private LockMode getNullSafeLockMode(LockMode lockMode) {
        return lockMode == null ? LockMode.NONE : lockMode;
    }

    protected Object lockCacheItem(Object id, Object previousVersion, EntityPersister persister) {
        if (persister.canWriteToCache()) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            Object ck = cache.generateCacheKey(id, persister, this.getFactory(), this.getTenantIdentifier());
            SoftLock lock = cache.lockItem(this, ck, previousVersion);
            this.afterCompletions.add((success, session) -> cache.unlockItem(session, ck, lock));
            return ck;
        }
        return null;
    }

    protected void removeCacheItem(Object ck, EntityPersister persister) {
        if (persister.canWriteToCache()) {
            persister.getCacheAccessStrategy().remove(this, ck);
        }
    }

    protected Object lockCacheItem(Object key, CollectionPersister persister) {
        if (persister.hasCache()) {
            CollectionDataAccess cache = persister.getCacheAccessStrategy();
            Object ck = cache.generateCacheKey(key, persister, this.getFactory(), this.getTenantIdentifier());
            SoftLock lock = cache.lockItem(this, ck, null);
            this.afterCompletions.add((success, session) -> cache.unlockItem(this, ck, lock));
            return ck;
        }
        return null;
    }

    protected void removeCacheItem(Object ck, CollectionPersister persister) {
        if (persister.hasCache()) {
            persister.getCacheAccessStrategy().remove(this, ck);
        }
    }

    @Override
    public void registerProcess(AfterTransactionCompletionProcess process) {
        this.afterCompletions.add(process);
    }

    @Override
    public void lock(String entityName, Object child, LockOptions lockOptions) {
        EntityPersister persister = this.getEntityPersister(entityName, child);
        persister.lock(persister.getIdentifier(child), persister.getVersion(child), child, lockOptions, (SharedSessionContractImplementor)this);
        EntityEntry entry = this.getPersistenceContextInternal().getEntry(child);
        if (entry == null) {
            throw new AssertionFailure("no entry in temporary persistence context");
        }
        LoaderHelper.upgradeLock(child, entry, lockOptions, this);
    }

    @Override
    public Object loadFromSecondLevelCache(EntityPersister persister, EntityKey entityKey, Object instanceToLoad, LockMode lockMode) {
        return CacheLoadHelper.loadFromSecondLevelCache(this, instanceToLoad, lockMode, persister, entityKey);
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        this.checkOpen();
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        throw new PersistenceException("Hibernate cannot unwrap '" + this.getClass().getName() + "' as '" + type.getName() + "'");
    }

    private static final class MultiLoadOptions
    implements MultiIdLoadOptions {
        private final LockOptions lockOptions;

        private MultiLoadOptions() {
            this.lockOptions = null;
        }

        private MultiLoadOptions(LockMode lockMode) {
            this.lockOptions = new LockOptions(lockMode);
        }

        @Override
        public boolean isSessionCheckingEnabled() {
            return false;
        }

        @Override
        public boolean isSecondLevelCacheCheckingEnabled() {
            return true;
        }

        @Override
        public Boolean getReadOnly(SessionImplementor session) {
            return null;
        }

        @Override
        public boolean isReturnOfDeletedEntitiesEnabled() {
            return false;
        }

        @Override
        public boolean isOrderReturnEnabled() {
            return true;
        }

        @Override
        public LockOptions getLockOptions() {
            return this.lockOptions;
        }

        @Override
        public Integer getBatchSize() {
            return null;
        }
    }
}

