/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import jakarta.json.Json;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logmanager.formatters.StructuredFormatter;

public class JsonFormatter
extends StructuredFormatter {
    private final Map<String, Object> config = new HashMap<String, Object>();
    private JsonGeneratorFactory factory = Json.createGeneratorFactory(this.config);

    public JsonFormatter() {
    }

    public JsonFormatter(String keyOverrides) {
        super(keyOverrides);
    }

    public JsonFormatter(Map<StructuredFormatter.Key, String> keyOverrides) {
        super(keyOverrides);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrettyPrint() {
        Map<String, Object> map = this.config;
        synchronized (map) {
            return this.config.containsKey("jakarta.json.stream.JsonGenerator.prettyPrinting") ? (Boolean)this.config.get("jakarta.json.stream.JsonGenerator.prettyPrinting") : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrettyPrint(boolean prettyPrint) {
        Map<String, Object> map = this.config;
        synchronized (map) {
            if (prettyPrint) {
                this.config.put("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
            } else {
                this.config.remove("jakarta.json.stream.JsonGenerator.prettyPrinting");
            }
            this.factory = Json.createGeneratorFactory(this.config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StructuredFormatter.Generator createGenerator(Writer writer) {
        JsonGeneratorFactory factory;
        Map<String, Object> map = this.config;
        synchronized (map) {
            factory = this.factory;
        }
        return new FormatterJsonGenerator(factory.createGenerator(writer));
    }

    private static class FormatterJsonGenerator
    implements StructuredFormatter.Generator {
        private final JsonGenerator generator;

        private FormatterJsonGenerator(JsonGenerator generator) {
            this.generator = generator;
        }

        @Override
        public StructuredFormatter.Generator begin() {
            this.generator.writeStartObject();
            return this;
        }

        @Override
        public StructuredFormatter.Generator add(String key, int value) {
            this.generator.write(key, value);
            return this;
        }

        @Override
        public StructuredFormatter.Generator add(String key, long value) {
            this.generator.write(key, value);
            return this;
        }

        @Override
        public StructuredFormatter.Generator add(String key, Map<String, ?> value) {
            this.generator.writeStartObject(key);
            if (value != null) {
                for (Map.Entry<String, ?> entry : value.entrySet()) {
                    this.writeObject(entry.getKey(), entry.getValue());
                }
            }
            this.generator.writeEnd();
            return this;
        }

        @Override
        public StructuredFormatter.Generator add(String key, String value) {
            if (value == null) {
                this.generator.writeNull(key);
            } else {
                this.generator.write(key, value);
            }
            return this;
        }

        @Override
        public StructuredFormatter.Generator startObject(String key) throws Exception {
            if (key == null) {
                this.generator.writeStartObject();
            } else {
                this.generator.writeStartObject(key);
            }
            return this;
        }

        @Override
        public StructuredFormatter.Generator endObject() throws Exception {
            this.generator.writeEnd();
            return this;
        }

        @Override
        public StructuredFormatter.Generator startArray(String key) throws Exception {
            if (key == null) {
                this.generator.writeStartArray();
            } else {
                this.generator.writeStartArray(key);
            }
            return this;
        }

        @Override
        public StructuredFormatter.Generator endArray() throws Exception {
            this.generator.writeEnd();
            return this;
        }

        @Override
        public StructuredFormatter.Generator end() {
            this.generator.writeEnd();
            this.generator.flush();
            this.generator.close();
            return this;
        }

        private void writeObject(String key, Object obj) {
            if (obj == null) {
                if (key == null) {
                    this.generator.writeNull();
                } else {
                    this.generator.writeNull(key);
                }
            } else if (obj instanceof Boolean) {
                Boolean value = (Boolean)obj;
                if (key == null) {
                    this.generator.write(value.booleanValue());
                } else {
                    this.generator.write(key, value.booleanValue());
                }
            } else if (obj instanceof Integer) {
                Integer value = (Integer)obj;
                if (key == null) {
                    this.generator.write(value.intValue());
                } else {
                    this.generator.write(key, value.intValue());
                }
            } else if (obj instanceof Long) {
                Long value = (Long)obj;
                if (key == null) {
                    this.generator.write(value.longValue());
                } else {
                    this.generator.write(key, value.longValue());
                }
            } else if (obj instanceof Double) {
                Double value = (Double)obj;
                if (key == null) {
                    this.generator.write(value.doubleValue());
                } else {
                    this.generator.write(key, value.doubleValue());
                }
            } else if (obj instanceof BigInteger) {
                BigInteger value = (BigInteger)obj;
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            } else if (obj instanceof BigDecimal) {
                BigDecimal value = (BigDecimal)obj;
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            } else if (obj instanceof String) {
                String value = (String)obj;
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            } else if (obj instanceof JsonValue) {
                JsonValue value = (JsonValue)obj;
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            } else {
                String value = String.valueOf(obj);
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            }
        }
    }
}

