/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;
import org.hibernate.models.spi.TypeVariableReferenceDetails;

public class TypeVariableReferenceDetailsImpl
implements TypeVariableReferenceDetails {
    private final String identifier;
    private TypeVariableDetails target;

    public TypeVariableReferenceDetailsImpl(String identifier) {
        this.identifier = identifier;
    }

    public TypeVariableReferenceDetailsImpl(String identifier, TypeVariableDetails target) {
        this.identifier = identifier;
        this.target = target;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public TypeVariableDetails getTarget() {
        if (this.target == null) {
            throw new IllegalStateException("Type variable reference " + this.identifier + " was not patched correctly");
        }
        return this.target;
    }

    public void setTarget(TypeVariableDetails target) {
        if (target == null) {
            throw new IllegalArgumentException("Type variable reference target must not be null");
        }
        this.target = target;
    }

    @Override
    public String getName() {
        if (this.target == null) {
            throw new IllegalStateException("Type variable reference " + this.identifier + " was not patched correctly");
        }
        return this.target.getName();
    }

    @Override
    public boolean isImplementor(Class<?> checkType) {
        return this.getTarget().isImplementor(checkType);
    }

    @Override
    public TypeDetails resolveTypeVariable(TypeVariableDetails typeVariable) {
        return this.identifier.equals(typeVariable.getIdentifier()) ? this.target : null;
    }
}

