/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.write.BackupAckCommand;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;

public class BackupMultiKeyAckCommand
extends BackupAckCommand {
    public static final byte COMMAND_ID = 41;
    private int segment;

    public BackupMultiKeyAckCommand() {
        super(null);
    }

    public BackupMultiKeyAckCommand(ByteString cacheName) {
        super(cacheName);
    }

    public BackupMultiKeyAckCommand(ByteString cacheName, long id, int segment, int topologyId) {
        super(cacheName, id, topologyId);
        this.segment = segment;
    }

    @Override
    public void ack(CommandAckCollector ackCollector) {
        ackCollector.backupAck(this.id, this.getOrigin(), this.segment, this.topologyId);
    }

    @Override
    public byte getCommandId() {
        return 41;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        output.writeInt(this.segment);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        this.segment = input.readInt();
    }

    @Override
    public String toString() {
        return "BackupMultiKeyAckCommand{id=" + this.id + ", segment=" + this.segment + ", topologyId=" + this.topologyId + "}";
    }
}

