/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.interceptors.distribution.CountDownCompletableFuture;
import org.infinispan.interceptors.distribution.MergingCompletableFuture;
import org.infinispan.interceptors.distribution.PutMapHelper;
import org.infinispan.interceptors.distribution.ReadWriteManyEntriesHelper;
import org.infinispan.interceptors.distribution.ReadWriteManyHelper;
import org.infinispan.interceptors.distribution.WriteManyCommandHelper;
import org.infinispan.interceptors.distribution.WriteOnlyManyEntriesHelper;
import org.infinispan.interceptors.distribution.WriteOnlyManyHelper;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.remoting.transport.impl.SingletonMapResponseCollector;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.CacheTopologyUtil;

public class NonTxDistributionInterceptor
extends BaseDistributionInterceptor {
    private final PutMapHelper putMapHelper = new PutMapHelper(this::createRemoteCallback);
    private final ReadWriteManyHelper readWriteManyHelper = new ReadWriteManyHelper(this::createRemoteCallback);
    private final ReadWriteManyEntriesHelper readWriteManyEntriesHelper = new ReadWriteManyEntriesHelper(this::createRemoteCallback);
    private final WriteOnlyManyEntriesHelper writeOnlyManyEntriesHelper = new WriteOnlyManyEntriesHelper(this::createRemoteCallback);
    private final WriteOnlyManyHelper writeOnlyManyHelper = new WriteOnlyManyHelper(this::createRemoteCallback);

    private Map<Address, IntSet> primaryOwnersOfSegments(ConsistentHash ch) {
        HashMap<Address, IntSet> map = new HashMap<Address, IntSet>(ch.getMembers().size());
        for (Address member : ch.getMembers()) {
            Set<Integer> segments = ch.getPrimarySegmentsForOwner(member);
            if (segments.isEmpty()) continue;
            map.put(member, IntSets.from(segments));
        }
        return map;
    }

    private Map<Address, IntSet> backupOwnersOfSegments(LocalizedCacheTopology topology, IntSet segments) {
        HashMap<Address, IntSet> map = new HashMap<Address, IntSet>(topology.getMembers().size() * 3 / 2);
        if (topology.getReadConsistentHash().isReplicated()) {
            List<Address> writeOwners = topology.getSegmentDistribution(0).writeOwners();
            for (Address writeOwner : writeOwners) {
                if (writeOwner.equals(topology.getLocalAddress())) continue;
                map.put(writeOwner, segments);
            }
        } else {
            int numSegments = topology.getNumSegments();
            PrimitiveIterator.OfInt iter = segments.iterator();
            while (iter.hasNext()) {
                int segment = iter.nextInt();
                Collection<Address> backupOwners = topology.getSegmentDistribution(segment).writeBackups();
                for (Address backupOwner : backupOwners) {
                    if (backupOwner.equals(topology.getLocalAddress())) continue;
                    map.computeIfAbsent(backupOwner, o -> IntSets.mutableEmptySet((int)numSegments)).set(segment);
                }
            }
        }
        return map;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleReadWriteManyCommand(ctx, command, this.putMapHelper);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        return this.handleWriteOnlyManyCommand(ctx, command, this.writeOnlyManyEntriesHelper);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        return this.handleWriteOnlyManyCommand(ctx, command, this.writeOnlyManyHelper);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        return this.handleReadWriteManyCommand(ctx, command, this.readWriteManyHelper);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return this.handleReadWriteManyCommand(ctx, command, this.readWriteManyEntriesHelper);
    }

    private <C extends WriteCommand, Container, Item> Object handleWriteOnlyManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, Container, Item> helper) throws Exception {
        LocalizedCacheTopology cacheTopology = CacheTopologyUtil.checkTopology(command, this.getCacheTopology());
        ConsistentHash ch = cacheTopology.getWriteConsistentHash();
        if (ctx.isOriginLocal()) {
            Map<Address, IntSet> segmentMap = this.primaryOwnersOfSegments(ch);
            CountDownCompletableFuture allFuture = new CountDownCompletableFuture(segmentMap.size());
            for (Map.Entry<Address, IntSet> pair : segmentMap.entrySet()) {
                Address member = pair.getKey();
                IntSet segments = pair.getValue();
                this.handleSegmentsForWriteOnlyManyCommand(ctx, command, helper, allFuture, member, segments, cacheTopology);
            }
            return NonTxDistributionInterceptor.asyncValue(allFuture);
        }
        return this.handleRemoteWriteOnlyManyCommand(ctx, command, helper);
    }

    private <C extends WriteCommand, Container, Item> void handleSegmentsForWriteOnlyManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, Container, Item> helper, CountDownCompletableFuture allFuture, Address member, IntSet segments, LocalizedCacheTopology topology) {
        if (member.equals(this.rpcManager.getAddress())) {
            Container myItems = this.filterAndWrap(ctx, command, segments, helper);
            C localCommand = helper.copyForLocal(command, myItems);
            localCommand.setTopologyId(command.getTopologyId());
            this.invokeNextAndFinally(ctx, localCommand, this.createLocalInvocationHandler(allFuture, segments, helper, (f, rv) -> {}, topology));
            return;
        }
        C copy = helper.copyForPrimary(command, topology, segments);
        copy.setTopologyId(command.getTopologyId());
        int size = helper.getItems(copy).size();
        if (size <= 0) {
            allFuture.countDown();
            return;
        }
        SingletonMapResponseCollector collector = SingletonMapResponseCollector.validOnly();
        this.rpcManager.invokeCommand(member, (ReplicableCommand)copy, collector, this.rpcManager.getSyncRpcOptions()).whenComplete((responseMap, throwable) -> {
            if (throwable != null) {
                allFuture.completeExceptionally((Throwable)throwable);
            } else {
                if (NonTxDistributionInterceptor.getSuccessfulResponseOrFail(responseMap, allFuture, rsp -> allFuture.completeExceptionally((Throwable)((Object)OutdatedTopologyException.RETRY_NEXT_TOPOLOGY))) == null) {
                    return;
                }
                allFuture.countDown();
            }
        });
    }

    private <C extends WriteCommand, Item> Object handleRemoteWriteOnlyManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, ?, Item> helper) {
        for (Object key : command.getAffectedKeys()) {
            if (ctx.lookupEntry(key) != null) continue;
            this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
        }
        if (helper.shouldRegisterRemoteCallback(command)) {
            return this.invokeNextThenApply(ctx, command, helper.getRemoteCallback());
        }
        return this.invokeNext(ctx, command);
    }

    private <C extends WriteCommand, Container, Item> Container filterAndWrap(InvocationContext ctx, C command, IntSet segments, WriteManyCommandHelper<C, Container, Item> helper) {
        Container myItems = helper.newContainer();
        for (Item item : helper.getItems(command)) {
            Object key = helper.item2key(item);
            if (!segments.contains(this.keyPartitioner.getSegment(key))) continue;
            helper.accumulate(myItems, item);
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry != null) continue;
            this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
        }
        return myItems;
    }

    protected <C extends WriteCommand, Container, Item> Object handleReadWriteManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, Item, Container> helper) throws Exception {
        LocalizedCacheTopology topology = CacheTopologyUtil.checkTopology(command, this.getCacheTopology());
        ConsistentHash ch = topology.getWriteConsistentHash();
        if (ctx.isOriginLocal()) {
            Map<Address, IntSet> segmentMap = this.primaryOwnersOfSegments(ch);
            Object[] results = null;
            if (!command.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES)) {
                results = new Object[helper.getItems(command).size()];
            }
            MergingCompletableFuture<Object> allFuture = new MergingCompletableFuture<Object>(segmentMap.size(), results, helper::transformResult);
            MutableInt offset = new MutableInt();
            for (Map.Entry<Address, IntSet> pair : segmentMap.entrySet()) {
                Address member = pair.getKey();
                IntSet segments = pair.getValue();
                if (member.equals(this.rpcManager.getAddress())) {
                    this.handleLocalSegmentsForReadWriteManyCommand(ctx, command, helper, allFuture, offset, segments, topology);
                    continue;
                }
                this.handleRemoteSegmentsForReadWriteManyCommand(command, helper, allFuture, offset, member, segments, topology);
            }
            return NonTxDistributionInterceptor.asyncValue(allFuture);
        }
        return this.handleRemoteReadWriteManyCommand(ctx, command, helper);
    }

    private <C extends WriteCommand, Container, Item> void handleLocalSegmentsForReadWriteManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, Container, Item> helper, MergingCompletableFuture<Object> allFuture, MutableInt offset, IntSet segments, LocalizedCacheTopology topology) {
        Container myItems = helper.newContainer();
        ArrayList<Object> remoteKeys = null;
        for (Item item : helper.getItems(command)) {
            Object key = helper.item2key(item);
            if (!segments.contains(this.keyPartitioner.getSegment(key))) continue;
            helper.accumulate(myItems, item);
            CacheEntry cacheEntry = ctx.lookupEntry(key);
            if (cacheEntry != null) continue;
            if (command.hasAnyFlag(FlagBitSets.SKIP_REMOTE_LOOKUP | FlagBitSets.CACHE_MODE_LOCAL)) {
                this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
                continue;
            }
            if (remoteKeys == null) {
                remoteKeys = new ArrayList<Object>();
            }
            remoteKeys.add(key);
        }
        CompletionStage<Void> retrievals = remoteKeys != null ? this.remoteGetMany(ctx, command, (Collection<?>)remoteKeys) : null;
        int size = helper.containerSize(myItems);
        if (size == 0) {
            allFuture.countDown();
            return;
        }
        int myOffset = offset.value;
        offset.value += size;
        C localCommand = helper.copyForLocal(command, myItems);
        localCommand.setTopologyId(command.getTopologyId());
        InvocationFinallyAction<C> handler = this.createLocalInvocationHandler(allFuture, segments, helper, MergingCompletableFuture.moveListItemsToFuture(myOffset), topology);
        if (retrievals == null) {
            this.invokeNextAndFinally(ctx, localCommand, handler);
        } else {
            Object result = this.asyncInvokeNext(ctx, command, retrievals);
            NonTxDistributionInterceptor.makeStage(result).andFinally(ctx, command, handler);
        }
    }

    private <C extends WriteCommand, Item> void handleRemoteSegmentsForReadWriteManyCommand(C command, WriteManyCommandHelper<C, ?, Item> helper, MergingCompletableFuture<Object> allFuture, MutableInt offset, Address member, IntSet segments, LocalizedCacheTopology topology) {
        int myOffset = offset.value;
        C copy = helper.copyForPrimary(command, topology, segments);
        copy.setTopologyId(command.getTopologyId());
        int size = helper.getItems(copy).size();
        offset.value += size;
        if (size <= 0) {
            allFuture.countDown();
            return;
        }
        SingletonMapResponseCollector collector = SingletonMapResponseCollector.validOnly();
        this.rpcManager.invokeCommand(member, (ReplicableCommand)copy, collector, this.rpcManager.getSyncRpcOptions()).whenComplete((responses, throwable) -> {
            if (throwable != null) {
                allFuture.completeExceptionally((Throwable)throwable);
            } else {
                SuccessfulResponse response = NonTxDistributionInterceptor.getSuccessfulResponseOrFail(responses, allFuture, rsp -> allFuture.completeExceptionally((Throwable)((Object)OutdatedTopologyException.RETRY_NEXT_TOPOLOGY)));
                if (response == null) {
                    return;
                }
                Object responseValue = response.getResponseValue();
                MergingCompletableFuture.moveListItemsToFuture(responseValue, allFuture, myOffset);
                allFuture.countDown();
            }
        });
    }

    private <C extends WriteCommand, Item> Object handleRemoteReadWriteManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, ?, Item> helper) throws Exception {
        ArrayList remoteKeys = null;
        for (Object key : command.getAffectedKeys()) {
            CacheEntry cacheEntry = ctx.lookupEntry(key);
            if (cacheEntry != null) continue;
            if (command.hasAnyFlag(FlagBitSets.SKIP_REMOTE_LOOKUP | FlagBitSets.CACHE_MODE_LOCAL)) {
                this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
                continue;
            }
            if (remoteKeys == null) {
                remoteKeys = new ArrayList();
            }
            remoteKeys.add(key);
        }
        Object result = remoteKeys != null ? this.asyncInvokeNext(ctx, command, this.remoteGetMany(ctx, command, remoteKeys)) : this.invokeNext(ctx, command);
        if (helper.shouldRegisterRemoteCallback(command)) {
            return NonTxDistributionInterceptor.makeStage(result).thenApply(ctx, command, helper.getRemoteCallback());
        }
        return result;
    }

    private <C extends WriteCommand, F extends CountDownCompletableFuture, Item> InvocationFinallyAction<C> createLocalInvocationHandler(F allFuture, IntSet segments, WriteManyCommandHelper<C, ?, Item> helper, BiConsumer<F, Object> returnValueConsumer, LocalizedCacheTopology topology) {
        return (rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                allFuture.completeExceptionally(throwable);
            } else {
                try {
                    returnValueConsumer.accept(allFuture, rv);
                    Map<Address, IntSet> backupOwners = this.backupOwnersOfSegments(topology, segments);
                    for (Map.Entry<Address, IntSet> backup : backupOwners.entrySet()) {
                        WriteCommand backupCopy = helper.copyForBackup(rCommand, topology, backup.getKey(), backup.getValue());
                        backupCopy.setTopologyId(rCommand.getTopologyId());
                        if (helper.getItems(backupCopy).isEmpty()) continue;
                        Address backupOwner = backup.getKey();
                        if (this.isSynchronous(backupCopy)) {
                            allFuture.increment();
                            this.rpcManager.invokeCommand(backupOwner, (ReplicableCommand)backupCopy, SingleResponseCollector.validOnly(), this.rpcManager.getSyncRpcOptions()).whenComplete((response, remoteThrowable) -> {
                                if (remoteThrowable != null) {
                                    allFuture.completeExceptionally((Throwable)remoteThrowable);
                                } else {
                                    allFuture.countDown();
                                }
                            });
                            continue;
                        }
                        this.rpcManager.sendTo(backupOwner, backupCopy, DeliverOrder.PER_SENDER);
                    }
                    allFuture.countDown();
                }
                catch (Throwable t) {
                    allFuture.completeExceptionally(t);
                }
            }
        };
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    private <C extends WriteCommand> Object writeManyRemoteCallback(WriteManyCommandHelper<C, ?, ?> helper, InvocationContext ctx, C command, Object rv) {
        LocalizedCacheTopology topology = CacheTopologyUtil.checkTopology(command, this.getCacheTopology());
        Map<Address, IntSet> backups = this.backupOwnersOfSegments(topology, this.extractCommandSegments(command, topology));
        if (backups.isEmpty()) {
            return rv;
        }
        boolean isSync = this.isSynchronous(command);
        CompletableFuture[] futures = isSync ? new CompletableFuture[backups.size()] : null;
        int future = 0;
        for (Map.Entry<Address, IntSet> backup : backups.entrySet()) {
            C copy = helper.copyForBackup(command, topology, backup.getKey(), backup.getValue());
            copy.setTopologyId(command.getTopologyId());
            Address backupOwner = backup.getKey();
            if (isSync) {
                futures[future++] = this.rpcManager.invokeCommand(backupOwner, (ReplicableCommand)copy, SingleResponseCollector.validOnly(), this.rpcManager.getSyncRpcOptions()).toCompletableFuture();
                continue;
            }
            this.rpcManager.sendTo(backupOwner, (ReplicableCommand)copy, DeliverOrder.PER_SENDER);
        }
        return isSync ? NonTxDistributionInterceptor.asyncValue(CompletableFuture.allOf(futures).thenApply(nil -> rv)) : rv;
    }

    private <C extends WriteCommand> IntSet extractCommandSegments(C command, LocalizedCacheTopology topology) {
        IntSet keySegments = IntSets.mutableEmptySet((int)topology.getNumSegments());
        for (Object key : command.getAffectedKeys()) {
            keySegments.set(this.keyPartitioner.getSegment(key));
        }
        return keySegments;
    }

    private <C extends WriteCommand> InvocationSuccessFunction createRemoteCallback(WriteManyCommandHelper<C, ?, ?> helper) {
        return (ctx, command, rv) -> this.writeManyRemoteCallback(helper, ctx, (WriteCommand)command, rv);
    }

    private static final class MutableInt {
        public int value;

        private MutableInt() {
        }
    }
}

