/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.Collections;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.FunctionalNotifier;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class NotifyHelper {
    public static <K, V> CompletionStage<Void> entryCommitted(CacheNotifier<K, V> notifier, FunctionalNotifier<K, V> functionalNotifier, CacheEntry<K, V> entry, InvocationContext ctx, FlagAffectedCommand command, V previousValue, Metadata previousMetadata, EvictionManager<K, V> evictionManager) {
        CompletionStage<Void> stage;
        boolean isWriteOnly;
        if (FlagBitSets.extractStateTransferFlag(ctx, command) != null) {
            return CompletableFutures.completedNull();
        }
        boolean bl = isWriteOnly = command instanceof WriteCommand && ((WriteCommand)command).isWriteOnly();
        if (entry.isRemoved()) {
            if (command instanceof RemoveExpiredCommand) {
                V expiredValue = previousValue != null ? previousValue : ((RemoveExpiredCommand)command).getValue();
                Metadata expiredMetadata = entry.getMetadata() != null ? entry.getMetadata() : ((RemoveExpiredCommand)command).getMetadata();
                stage = notifier.notifyCacheEntryExpired(entry.getKey(), expiredValue, expiredMetadata, ctx);
            } else if (command instanceof EvictCommand) {
                stage = evictionManager.onEntryEviction(Collections.singletonMap(entry.getKey(), entry), command);
            } else if (command instanceof RemoveCommand) {
                stage = notifier.notifyCacheEntryRemoved(entry.getKey(), previousValue, entry.getMetadata(), false, ctx, command);
            } else if (entry.isInvalidated() || command instanceof InvalidateCommand) {
                stage = notifier.notifyCacheEntryInvalidated(entry.getKey(), previousValue, entry.getMetadata(), false, ctx, command);
            } else {
                MVCCEntry mvccEntry;
                stage = entry instanceof MVCCEntry && (mvccEntry = (MVCCEntry)entry).isExpired() ? notifier.notifyCacheEntryExpired(entry.getKey(), previousValue, previousMetadata, ctx) : notifier.notifyCacheEntryRemoved(entry.getKey(), previousValue, previousMetadata, false, ctx, command);
                if (!isWriteOnly) {
                    functionalNotifier.notifyOnRemove(EntryViews.readOnly(entry.getKey(), previousValue, previousMetadata));
                }
                functionalNotifier.notifyOnWriteRemove(entry.getKey());
            }
        } else if (entry.isCreated()) {
            stage = notifier.notifyCacheEntryCreated(entry.getKey(), entry.getValue(), entry.getMetadata(), false, ctx, command);
            if (!isWriteOnly) {
                functionalNotifier.notifyOnCreate(entry);
            }
            functionalNotifier.notifyOnWrite(entry);
        } else {
            stage = notifier.notifyCacheEntryModified(entry.getKey(), entry.getValue(), entry.getMetadata(), previousValue, previousMetadata, false, ctx, command);
            if (!isWriteOnly) {
                functionalNotifier.notifyOnModify(entry, previousValue, previousMetadata);
            }
            functionalNotifier.notifyOnWrite(entry);
        }
        return stage;
    }
}

