/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.endpoints.IframeUtil;
import org.keycloak.protocol.oidc.utils.WebOriginsUtils;
import org.keycloak.services.Urls;
import org.keycloak.urls.UrlType;
import org.keycloak.utils.FreemarkerUtils;
import org.keycloak.utils.SecureContextResolver;

public class LoginStatusIframeEndpoint {
    private static final Logger logger = Logger.getLogger(LoginStatusIframeEndpoint.class);
    private final KeycloakSession session;

    public LoginStatusIframeEndpoint(KeycloakSession session) {
        this.session = session;
    }

    @GET
    @Produces(value={"text/html; charset=utf-8"})
    public Response getLoginStatusIframe(@QueryParam(value="version") String version) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isSecureContext = SecureContextResolver.isSecureContext(this.session);
        URI serverBaseUri = this.session.getContext().getUri(UrlType.FRONTEND).getBaseUri();
        map.put("isSecureContext", isSecureContext);
        map.put("resourceCommonUrl", Urls.themeRoot(serverBaseUri).getPath() + "/common/keycloak");
        return IframeUtil.returnIframe(version, this.session, () -> {
            try {
                return FreemarkerUtils.loadTemplateFromClasspath(map, "login-status-iframe.ftl", this.getClass());
            }
            catch (Exception e) {
                logger.error((Object)"Failure when loading login-status-iframe.ftl", (Throwable)e);
                return null;
            }
        });
    }

    @GET
    @Path(value="init")
    public Response preCheck(@QueryParam(value="client_id") String clientId, @QueryParam(value="origin") String origin) {
        try {
            KeycloakUriInfo uriInfo = this.session.getContext().getUri();
            RealmModel realm = this.session.getContext().getRealm();
            ClientModel client = this.session.clients().getClientByClientId(realm, clientId);
            if (client != null && client.isEnabled()) {
                Set<String> validWebOrigins = WebOriginsUtils.resolveValidWebOrigins(this.session, client);
                String requestOrigin = UriUtils.getOrigin((URI)uriInfo.getRequestUri());
                validWebOrigins.add(requestOrigin);
                if (validWebOrigins.contains("*") || validWebOrigins.contains(origin)) {
                    return Response.noContent().build();
                }
                logger.debugf("client %s does not allow origin=%s for requestOrigin=%s (as determined by the proxy-header setting), init will return a 403", (Object)clientId, (Object)origin, (Object)requestOrigin);
            } else {
                logger.debugf("client %s does not exist or not enabled, init will return a 403", (Object)clientId);
            }
        }
        catch (Throwable t) {
            logger.debug((Object)"Exception in init, will return a 403", t);
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

